<?php
	/**************************************************************************\
	* eGroupWare API - Contacts manager for SQL                                *
	* Reworked with new DB-functions by RalfBecker-AT-outdoor-training.de      *
	* This file written by Joseph Engo <jengo@phpgroupware.org>                *
	*   and Miles Lott <milosch@groupwhere.org>                                *
	* View and manipulate contact records using SQL                            *
	* Copyright (C) 2001 Joseph Engo                                           *
	* ------------------------------------------------------------------------ *
	* This library is part of the eGroupWare API                               *
	* http://www.egroupware.org/api                                            *
	* ------------------------------------------------------------------------ *
	* This library is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU Lesser General Public License as published by *
	* the Free Software Foundation; either version 2.1 of the License,         *
	* or any later version.                                                    *
	* This library is distributed in the hope that it will be useful, but      *
	* WITHOUT ANY WARRANTY; without even the implied warranty of               *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     *
	* See the GNU Lesser General Public License for more details.              *
	* You should have received a copy of the GNU Lesser General Public License *
	* along with this library; if not, write to the Free Software Foundation,  *
	* Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA            *
	\**************************************************************************/

	/**
	* This class provides a contact database scheme.
	* It attempts to be based on the vcard 2.1 standard, with mods as needed
	* to make for more reasonable sql storage.
	* Note that changes here must also work in the LDAP version.
	* Syntax: CreateObject('phpgwapi.contacts');
	* Example1: $contacts = CreateObject('phpgwapi.contacts');
	*
	* The contacts class now uses user-time in all param- and return-values.
	* The time stored in the DB is in server-time, as in all other eGW apps.
	*
	* Last Editor: $Author: ralfbecker $
	* @class contacts_
	* @abstract Contact Management System
	* @author jengo/Milosch
	* @version $Revision: 22506 $
	* @license LGPL
	*/

	/* $Id: class.contacts_sql.inc.php 22506 2006-09-27 04:16:09Z ralfbecker $ */

	class contacts_
	{
		var $db = '';
		var $std_table='egw_addressbook';
		var $ext_table='egw_addressbook_extra';

		/**
		 * @var int $tz_offset_s offset in secconds between user and server-time,
		 *	it need to be add to a server-time to get the user-time or substracted from a user-time to get the server-time
		 */
		var $tz_offset_s;

		var $account_id = 0;
		var $total_records = 0;
		var $grants = '';

		/* The left side are the array elements used throughout phpgw, right side are the db field names. */
		var $stock_contact_fields = array(
			'fn'                  => 'fn',
			'n_given'             => 'n_given',
			'n_family'            => 'n_family',
			'n_middle'            => 'n_middle',
			'n_prefix'            => 'n_prefix',
			'n_suffix'            => 'n_suffix',
			'sound'               => 'sound',
			'bday'                => 'bday',
			'note'                => 'note',
			'tz'                  => 'tz',
			'geo'                 => 'geo',
			'url'                 => 'url',
			'pubkey'              => 'pubkey',
			'org_name'            => 'org_name',
			'org_unit'            => 'org_unit',
			'title'               => 'title',
			'adr_one_street'      => 'adr_one_street',
			'adr_one_locality'    => 'adr_one_locality',
			'adr_one_region'      => 'adr_one_region',
			'adr_one_postalcode'  => 'adr_one_postalcode',
			'adr_one_countryname' => 'adr_one_countryname',
			'adr_one_type'        => 'adr_one_type',
			'label'               => 'label',
			'adr_two_street'      => 'adr_two_street',
			'adr_two_locality'    => 'adr_two_locality',
			'adr_two_region'      => 'adr_two_region',
			'adr_two_postalcode'  => 'adr_two_postalcode',
			'adr_two_countryname' => 'adr_two_countryname',
			'adr_two_type'        => 'adr_two_type',
			'tel_work'            => 'tel_work',
			'tel_home'            => 'tel_home',
			'tel_voice'           => 'tel_voice',
			'tel_fax'             => 'tel_fax',
			'tel_msg'             => 'tel_msg',
			'tel_cell'            => 'tel_cell',
			'tel_pager'           => 'tel_pager',
			'tel_bbs'             => 'tel_bbs',
			'tel_modem'           => 'tel_modem',
			'tel_car'             => 'tel_car',
			'tel_isdn'            => 'tel_isdn',
			'tel_video'           => 'tel_video',
			'tel_prefer'          => 'tel_prefer',
			'email'               => 'email',
			'email_type'          => 'email_type',
			'email_home'          => 'email_home',
			'email_home_type'     => 'email_home_type'
		);

		var $non_contact_fields = array(
			'id'     => 'id',
			'lid'    => 'lid',
			'tid'    => 'tid',
			'cat_id' => 'cat_id',
			'access' => 'access',
			'owner'  => 'owner'
		);

		var $adr_types = array();

		/* Used to set preferred number field */
		var $tel_types = array(
			'work'  => 'work',
			'home'  => 'home',
			'voice' => 'voice',
			'fax'   => 'fax',
			'msg'   => 'msg',
			'cell'  => 'cell',
			'pager' => 'pager',
			'bbs'   => 'bbs',
			'modem' => 'modem',
			'car'   => 'car',
			'isdn'  => 'isdn',
			'video' => 'video'
		);

		/* Used to set email_type fields */
		var $email_types = array(
			'INTERNET'   => 'INTERNET',
			'CompuServe' => 'CompuServe',
			'AOL'        => 'AOL',
			'Prodigy'    => 'Prodigy',
			'eWorld'     => 'eWorld',
			'AppleLink'  => 'AppleLink',
			'AppleTalk'  => 'AppleTalk',
			'PowerShare' => 'PowerShare',
			'IBMMail'    => 'IBMMail',
			'ATTMail'    => 'ATTMail',
			'MCIMail'    => 'MCIMail',
			'X.400'      => 'X.400',
			'TLX'        => 'TLX'
		);

		function contacts_($useacl=True)
		{
			$this->db = clone($GLOBALS['egw']->db);
			$this->db->set_app('phpgwapi');

			if($useacl)
			{
				$this->grants = $GLOBALS['egw']->acl->get_grants('addressbook');
			}
			$this->account_id = $GLOBALS['egw_info']['user']['account_id'];

			/* Used to flag an address as being:
			   domestic AND/OR international(default)
			   parcel(default)
			   postal(default)
			*/
			$this->adr_types = array(
				'dom'    => lang('Domestic'),
				'intl'   => lang('International'),
				'parcel' => lang('Parcel'),
				'postal' => lang('Postal')
			);
			if (!is_object($GLOBALS['egw']->datetime))
			{
				$GLOBALS['egw']->datetime =& CreateObject('phpgwapi.datetime');
			}
			$this->tz_offset_s = $GLOBALS['egw']->datetime->tz_offset;
		}

		/* send this the id and whatever fields you want to see */
		function read_single_entry($id,$fields='')
		{
			if (!$fields || empty($fields))
			{
				$fields = $this->stock_contact_fields;
			}
			list($stock_fields,$stock_fieldnames,$extra_fields) = $this->split_stock_and_extras($fields);

			if (count($stock_fieldnames))
			{
				$t_fields = ',' . implode(',',$stock_fieldnames);
				if ($t_fields == ',')
				{
					unset($t_fields);
				}
			}

			$this->db->select($this->std_table,'id,lid,tid,owner,access,cat_id'.$t_fields,array('id' => $id),__LINE__,__FILE__);
			$this->db->next_record();

			$return_fields[0]['id']     = $this->db->f('id');
			$return_fields[0]['lid']    = $this->db->f('lid');
			$return_fields[0]['tid']    = $this->db->f('tid');
			$return_fields[0]['owner']  = $this->db->f('owner');
			$return_fields[0]['access'] = $this->db->f('access');
			$return_fields[0]['cat_id'] = $this->db->f('cat_id');
			$return_fields[0]['rights'] = (int)$this->grants[$this->db->f('owner')];

			if(@is_array($stock_fieldnames))
			{
				foreach($stock_fieldnames as $f_name)
				{
					$return_fields[0][$f_name] = $this->db->f($f_name);
				}
			}

			/* Setup address type fields for ui forms display */
			if ($this->db->f('adr_one_type'))
			{
				$one_type = $this->db->f('adr_one_type');
				foreach($this->adr_types as $name => $val)
				{
					if (strstr($one_type,$name))
					{
						$return_fields[0]['one_'.$name] = 'on';
					}
				}
			}
			if ($this->db->f('adr_two_type'))
			{
				$two_type = $this->db->f('adr_two_type');
				foreach($this->adr_types as $name => $val)
				{
					if (strstr($two_type,$name))
					{
						$return_fields[0]['two_'.$name] = 'on';
					}
				}
			}

			$this->db->select($this->ext_table,'contact_name,contact_value',array('contact_id'=>$id),__LINE__,__FILE__);
			while ($this->db->next_record())
			{
				if ($extra_fields[$this->db->f('contact_name')])
				{
					$return_fields[0][$this->db->f('contact_name')] = $this->db->f('contact_value');
				}
			}
			return $return_fields;
		}

		// better use get_last_insert_id !!!
		function read_last_entry($fields='')
		{
			$this->db->select($this->std_table,'max(id)',False,__LINE__,__FILE__);
			$this->db->next_record();

			return $this->read_single_entry($this->db->f(0),$fields);
		}

		/**
		 * Searches for contacts meating certain criteria and evtl. return only a range of them
		 *
		 * @param int $start=0 starting number of the range, if $limit != 0
		 * @param int $limit=0 max. number of entries to return, 0=all
		 * @param array $fields=null fields to return or null for all stock fields
		 * @param string $query='' search pattern or '' for none
		 * @param string $filter='' filters with syntax like <name>=<value>,<name2>=<value2> OR <name3>=<value3>,<name4>=!'' for not empty
		 * @param string $sort='' sorting: ASC or DESC
		 * @param string $order='' column to order, default ('') n_family,n_given,email ASC
		 * @param int $lastmod=-1 return only values modified after given timestamp, default (-1) return all
		 * @param string $cquery='' return only entries starting with given character, default ('') all
		 * @return array of contacts
		 */
		function read($start=0,$limit=0,$fields=null,$query='',$filter='',$sort='',$order='', $lastmod=-1,$cquery='')
		{
			if (!$limit)
			{
				$limit = -1;	// db::query uses -1 for all
			}
			elseif (!$start)
			{
				$start  = 0;
			}
			if(!$filter) { $filter = 'tid=n'; }

			if (!$fields || empty($fields)) { $fields = $this->stock_contact_fields; }
			$DEBUG = 0;

			list($stock_fields,$stock_fieldnames,$extra_fields) = $this->split_stock_and_extras($fields);
			if (count($stock_fieldnames))
			{
				$t_fields = ',' . implode(',',$stock_fieldnames);
				if ($t_fields == ',')
				{
					unset($t_fields);
				}
			}

			/* turn filter's a=b,c=d OR a=b into an array */
			if ($filter)
			{
				$check_stock = $this->stock_contact_fields + $this->non_contact_fields;

				if ($DEBUG) { echo 'DEBUG - Inbound filter is: #'.$filter.'#'; }

				$filterlist = array();
				foreach(explode(',',$filter) as $pair)
				{
					list($name,$value) = explode('=',$pair,2);
					if (!$name || !isset($check_stock[$name]))	// only use valid column-names
					{
						continue;
					}
					if ($DEBUG) { echo '<br>DEBUG - Filter intermediate strings 2: #'.$name.'# => #'.$value.'#'; }

					if (empty($value))
					{
						if ($DEBUG) { echo '<br>DEBUG - filter field "'.$name.'" is empty (NULL)'; }

						$filterlist[] = $name.' is NULL';
					}
					else
					{
						if($name == 'cat_id')
						{
							if (!(int)$value) continue;	// nothing to filter

							//$filterlist[] = "(" . $name . " LIKE '%," . (int)$value . ",%' OR " . $name."='".(int)$value."')";
							if (!is_object($GLOBALS['egw']->categories))
							{
								$GLOBALS['egw']->categories = CreateObject('phpgwapi.categories');
							}
							$cats = $GLOBALS['egw']->categories->return_all_children((int)$value);
							foreach($cats as $cat)
							{
								$cat_filter[] = $this->db->concat("','",cat_id,"','")." LIKE '%,$cat,%'";
							}
							$filterlist[] = '('.implode(' OR ',$cat_filter).')';
						}
						elseif(@is_int($value))
						{
							$filterlist[] = $name . '=' . $value;
						}
						elseif ($value == "!''")	// check for not empty
						{
							$filterlist[] = $name . "!=''";
						}
						else
						{
							$filterlist[] = $name . "='" . $this->db->db_addslashes($value) . "'";
						}
					}
				}
				$filterlist = implode(' AND ',$filterlist);

				if ($DEBUG)
				{
					echo '<br>DEBUG - Filter output string: #'.$filterlist.'#';
				}

				if ($filterlist)
				{
					$filtermethod = '('.$filterlist.') ';
					$fwhere = ' WHERE '; $fand = ' AND ';
				}
			}
			else
			{
				$filtermethod = " AND (tid='n' OR tid is null)";
			}

			if (!$filtermethod)
			{
				if($this->account_id)
				{
					$fwhere .= ' (owner=' . $this->account_id;
					$fand   .= ' (owner=' . $this->account_id;
				}
			}
			else
			{
				if($this->account_id)
				{
					$fwhere .= $filtermethod . ' AND (owner=' . $this->account_id;
					$fand   .= $filtermethod . ' AND (owner=' . $this->account_id;
				}
				else
				{
					$filtermethod = substr($filtermethod,0,-2);
					$fwhere .= $filtermethod;
					$fand   .= $filtermethod;
				}
			}

			if(@is_array($this->grants))
			{
				$grants = $this->grants;
				foreach($grants as $user => $_right)
				{
					$public_user_list[] = $user;
				}
				$fwhere .= " OR (access='public' AND owner in(" . implode(',',$public_user_list) . "))) ";
				$fand   .= " OR (access='public' AND owner in(" . implode(',',$public_user_list) . "))) ";
			}
			else
			{
				$fwhere .= ') '; $fand .= ') ';
			}

			if ($DEBUG && $filtermethod)
			{
				echo '<br>DEBUG - Filtering with: #' . $filtermethod . '#';
			}

			if (!$sort) { $sort = 'ASC'; }

			if (!empty($order) && preg_match('/^[a-zA-Z_0-9, ]+$/',$order) && (empty($sort) || preg_match('/^(DESC|ASC|desc|asc)$/',$sort)))
			{
				$ordermethod = "ORDER BY $order $sort ";
			}
			else
			{
				$ordermethod = "ORDER BY n_family,n_given,org_name ASC";
			}

			if ($DEBUG && $ordermethod)
			{
				echo "<br>DEBUG - $ordermethod";
			}

			if($lastmod >= 0)
			{
				if (!$fwhere) $fwhere = ' WHERE ';
				$fwhere .= " AND last_mod > ".(int)($lastmod - $this->tz_offset_s).' ';

				if ($DEBUG)
				{
					echo "<br>DEBUG - last_mod_filter added to fwhere: $fwhere";
				}
			}

			$filtermethod = '';

			if($cquery)
			{
				$sql = 'SELECT * FROM ' . $this->std_table . ' WHERE (';
				$sqlcount = 'SELECT COUNT(id) FROM ' . $this->std_table  . ' WHERE (';
				foreach(array(
					'fn'       => 'cn',
					'n_family' => 'sn',
					'n_given'  => 'givenname',
					'org_name' => 'o'
				) as $f => $x)
				{
					$cquery = strtoupper($this->db->db_addslashes($cquery));
					$sql .= " UPPER($f) LIKE '$cquery%' OR ";
					$sqlcount .= " UPPER($f) LIKE '$cquery%' OR ";
				}
				$sql = substr($sql,0,-3) . ') ' . $fand . $filtermethod . $ordermethod;
				$sqlcount = substr($sqlcount,0,-3) . ') ' . $fand . $filtermethod;
				unset($f); unset($x);
			}
			elseif($query)
			{
				if(is_array($query))
				{
					$sql = "SELECT * FROM $this->std_table WHERE (";
					$sqlcount = "SELECT COUNT(id) FROM $this->std_table WHERE (";
					foreach($query as $queryKey => $queryValue)
					{
						if (!preg_match('/^[a-zA-Z0-9_]+$/',$queryKey))
						{
							continue;	// this can be something nasty
						}
						// special handling of text columns for certain db's;
						if (in_array($f,array('note','pubkey','label')))
						{
							switch($this->db->Type)
							{
								case 'sapdb': case 'maxdb':
									$queryKey = false;	// sapdb cant use LIKE on text/LONG columns
									break;
								case 'mssql':
									$queryKey = "CAST($queryKey AS varchar)";	// mssql cant use UPPER on text columns
									break;
							}
							if (!$queryKey) continue;
						}
						$queryValue  = strtoupper($this->db->db_addslashes($queryValue));
						if(empty($queryValue)) {
							$sql .= " ($queryKey IS NULL OR $queryKey = '') AND ";
							$sqlcount .= " ($queryKey IS NULL OR $queryKey = '') AND ";
						} else {
							$sql .= " UPPER($queryKey) LIKE '$queryValue' AND ";
							$sqlcount .= " UPPER($queryKey) LIKE '$queryValue' AND ";
						}
					}
					$sql = substr($sql,0,-5) . ') ' . $fand . $filtermethod . $ordermethod;
					$sqlcount = substr($sqlcount,0,-5) . ') ' . $fand . $filtermethod;
					unset($queryKey); unset($queryValue);
				}
				else
				{
					$query = strtoupper($this->db->db_addslashes($query));

					$sql = "SELECT * FROM $this->std_table WHERE (";
					$sqlcount = "SELECT COUNT(*) FROM $this->std_table WHERE (";
					foreach($this->stock_contact_fields as $f => $x)
					{
						// special handling of text columns for certain db's;
						if (in_array($f,array('note','pubkey','label')))
						{
							switch($this->db->Type)
							{
								case 'sapdb': case 'maxdb':
									$f = false;	// sapdb cant use LIKE on text/LONG columns
									break;
								case 'mssql':
									$f = "CAST($f AS varchar)";	// mssql cant use UPPER on text columns
									break;
							}
							if (!$f) continue;
						}
						$sql .= " UPPER($f) LIKE '%$query%' OR ";
						$sqlcount .= " UPPER($f) LIKE '%$query%' OR ";
					}
					$sql = substr($sql,0,-3) . ') ' . $fand . $filtermethod . $ordermethod;
					$sqlcount = substr($sqlcount,0,-3) . ') ' . $fand . $filtermethod;
					unset($f); unset($x);
				}
			}
			else
			{
				$sql = "SELECT id,lid,tid,owner,access,cat_id,last_mod $t_fields FROM $this->std_table " . $fwhere
					. $filtermethod . ' ' . $ordermethod;
				$sqlcount = "SELECT COUNT(*) FROM $this->std_table " . $fwhere . $filtermethod;
			}
			if($DEBUG)
			{
				echo '<br>COUNT QUERY' . $sqlcount;
				echo '<br>FULL  QUERY' . $sql;
			}

//			$db2 = $this->db;
			copyobj($this->db,$db2);

			/* Perhaps it is more efficient to count records for this query, which is all we need here */
			$this->db->query($sqlcount,__LINE__,__FILE__);
			$this->db->next_record();
			unset($sqlcount);
			$this->total_records = $this->db->f(0);

			//echo "<p align=right>search() start=$start, limit=$limit, total=$this->total_records</p>\n";
			if ($this->total_records < $start) $start = 0;

			$this->db->query($sql,__LINE__,__FILE__,$start,$limit);

			$i = 0;
			while($this->db->next_record())
			{
				$return_fields[$i]['id']       = $this->db->f('id');
				$return_fields[$i]['lid']      = $this->db->f('lid');
				$return_fields[$i]['tid']      = $this->db->f('tid');
				$return_fields[$i]['owner']    = $this->db->f('owner');
				$return_fields[$i]['access']   = $this->db->f('access');
				$return_fields[$i]['cat_id']   = $this->db->f('cat_id');
				$return_fields[$i]['last_mod'] = $this->db->f('last_mod')+$this->tz_offset_s;
				$return_fields[$i]['rights']   = (int)$this->grants[$this->db->f('owner')];

				if(@is_array($stock_fieldnames))
				{
					foreach($stock_fieldnames as $f_name)
					{
						$return_fields[$i][$f_name] = $this->db->f($f_name);
					}
					reset($stock_fieldnames);
				}
				$db2->select($this->ext_table,'contact_name,contact_value',array('contact_id'=>$this->db->f('id')),__LINE__,__FILE__);
				while($db2->next_record())
				{
					if($extra_fields[$db2->f('contact_name')])
					{
						$return_fields[$i][$db2->f('contact_name')] = $db2->f('contact_value');
					}
				}
				$i++;
			}
			return $return_fields;
		}

		function add($owner,$fields,$access=NULL,$cat_id=NULL,$tid=NULL)
		{
			$owner = (int)$owner;
			// access, cat_id and tid can be in $fields now or as extra params
			foreach(array('access','cat_id','tid') as $extra)
			{
				if (!is_null($$extra))
				{
					$fields[$extra] = $$extra;
				}
			}
			if(empty($fields['tid']))
			{
				$fields['tid'] = 'n';
			}
			// setting the telephone numbers to empty if unset, as otherwise the db-default adds '+1 (000) 000-0000' 
			// I dont want to change the default in the stable release
			foreach($this->stock_contact_fields as $name)
			{
				if (substr($name,0,4) == 'tel_' && !isset($fields[$name])) $fields[$name] = '';
			}
			list($stock_fields,$stock_fieldnames,$extra_fields) = $this->split_stock_and_extras($fields);

			//this is added here so it is never tainted
			$this->stock_contact_fields['last_mod'] = 'last_mod';
			$stock_fields['last_mod'] = time();

			$data = array(
				'owner'		=> $owner,
				'access'	=> $fields['access'],
				'cat_id'	=> $fields['cat_id'],
				'tid'		=> $fields['tid'],
			);
			if (isset($fields['lid'])) $data['lid'] = $fields['lid'];
			

			$this->db->insert($this->std_table,array_merge($data,$stock_fields),False,__LINE__,__FILE__);

			$id = $this->db->get_last_insert_id($this->std_table, 'id');

			if($id && count($extra_fields))
			{
				foreach($extra_fields as $name => $value)
				{
					$this->db->insert($this->ext_table,array(
							'contact_id'	=> $id,
							'contact_owner'	=> $owner,
							'contact_name'	=> $name,
							'contact_value'	=> $value,
						),False,__LINE__,__FILE__);
				}
			}
			return ($id ? $id : False);
		}

		function field_exists($id,$field_name)
		{
			$this->db->select($this->ext_table,'COUNT(*)',array(
					'contact_id'	=> $id,
					'contact_name'	=> $field_name,
				),__LINE__,__FILE__);
			$this->db->next_record();
			return $this->db->f(0);
		}

		function add_single_extra_field($id,$owner,$field_name,$field_value)
		{
			$this->db->insert($this->ext_table,array(
					'contact_id'	=> $id,
					'contact_owner'	=> $owner,
					'contact_name'	=> $field_name,
					'contact_value'	=> $field_value,
				),False,__LINE__,__FILE__);
		}

		function delete_single_extra_field($id,$field_name)
		{
			$this->db->delete($this->ext_table,array(
					'contact_id'	=> $id,
					'contact_name'	=> $field_name,
				),__LINE__,__FILE__);
		}

		function update($id,$owner,$fields,$access=NULL,$cat_id=NULL,$tid=NULL)
		{
			/* First make sure that id number exists */
			$this->db->select($this->std_table,'COUNT(*)',array('id'=>$id),__LINE__,__FILE__);
			$this->db->next_record();
			if (!$this->db->f(0))
			{
				return False;
			}

			list($stock_fields,,$extra_fields) = $this->split_stock_and_extras($fields);
			// access, cat_id and tid can be in $fields now or as extra params
			foreach(array('access','cat_id','tid','owner') as $extra)
			{
				if (!is_null($$extra))
				{
					$fields[$extra] = $$extra;
				}
				if (isset($fields[$extra]))
				{
					$stock_fields[$extra] = $fields[$extra];
				}
			}

			if (count($stock_fields))
			{
				$stock_fields['last_mod'] = time();
				$this->db->update($this->std_table,$stock_fields,array('id'=>$id),__LINE__,__FILE__);
			}
			if (is_array($extra_fields))
			{
				foreach($extra_fields as $x_name => $x_value)
				{
					if ($this->field_exists($id,$x_name))
					{
						if (!$x_value)
						{
							$this->delete_single_extra_field($id,$x_name);
						}
						else
						{
							$this->db->update($this->ext_table,array(
									'contact_value'	=> $x_value,
									'contact_owner'	=> $owner,
								),array(
									'contact_name'	=> $x_name,
									'contact_id'	=> $id,
								),__LINE__,__FILE__);
						}
					}
					elseif($x_value)	// dont write emtpy extra-fields
					{
						$this->add_single_extra_field($id,$owner,$x_name,$x_value);
					}
				}
			}
			return True;
		}

		/* Used by admin to change ownership on account delete */
		function change_owner($old_owner,$new_owner)
		{
			if (!(int)$new_owner || !(int)$old_owner)
			{
				return False;
			}
			$this->db->update($this->std_table,array('owner'=>$new_owner),array('owner'=>$old_owner),__LINE__,__FILE__);
			$this->db->update($this->ext_table,array('contact_owner'=>$new_owner),array('contact_owner'=>$old_owner),__LINE__,__FILE__);
		}

		/* This is where the real work of delete() is done, shared class file contains calling function */
		function delete_($id)
		{
			$this->db->delete($this->std_table,array('id'=>$id),__LINE__,__FILE__);
			$this->db->delete($this->ext_table,array('contact_id'=>$id),__LINE__,__FILE__);
		}

		/* This is for the admin script deleteaccount.php */
		function delete_all($owner=0)
		{
			if ($owner)
			{
				$this->db->delete($this->std_table,array('owner'=>$owner),__LINE__,__FILE__);
				$this->db->delete($this->ext_table,array('contact_owner'=>$owner),__LINE__,__FILE__);
			}
		}
	}
?>
