/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <config.hpp>
#include <gtkmm.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnome/libgnome.h>
#include <gettext.h>

#include "eiciel_main_controler.hpp"
#include "eiciel_main_window.hpp"

#ifdef ENABLE_USER_XATTR
#include "eiciel_xattr_controler.hpp"
#include "eiciel_xattr_window.hpp"
#endif

class EicielContainer : public Gtk::Window
{
	private:
		Gtk::VBox principal;
		Gtk::VBox paginaACL;
		Gtk::VBox paginaXAttr;
		Gtk::HBox superior;
		Gtk::HBox inferior;
		Gtk::Button escollirFitxer;
		Gtk::Label etiquetaFitxer;
		Gtk::Label nomFitxer;
		Gtk::Button sortir;
		Gtk::Button ajuda;
		Gtk::Button quantA;

		Gtk::Notebook paginador;

		EicielWindow* widget_principal;
		EicielMainControler* controlador_widget;

#ifdef ENABLE_USER_XATTR
		EicielXAttrWindow* widget_xattr;
		EicielXAttrControler* controlador_xattr;
#endif

		
		void sortidaAplicacio();
		void oberturaFitxer();
		Glib::ustring missatgeError();
		void mostrarQuantA();
		void mostrarAjuda();

		// FileChooser stuff
		void chooser_file_activated(Gtk::FileChooserDialog* dialeg);

	public:
		EicielContainer();
		bool obrirFitxer(Glib::ustring nom);
};

class EicielAboutBox : public Gtk::Dialog
{
	private:
		Gtk::Label titol;
		Gtk::Label autor;
	public:
		EicielAboutBox(Gtk::Window& parent);
};
