/*
 * uni_norm.c --
 *
 *	Declarations of Unicode character information tables.  This file is
 *	automatically generated by the uni_parse2.tcl script.  Do not
 *	modify this file by hand.
 *
 * Copyright (c) 1998 by Scriptics Corporation.
 * All rights reserved.
 *
 * Modified for ejabberd by Alexey Shchepin
 *
 * RCS: @(#) $Id: uni_norm.c,v 1.3 2003/10/09 18:08:34 aleksey Exp $
 */

/*
 * A 16-bit Unicode character is split into two parts in order to index
 * into the following tables.  The lower CCLASS_OFFSET_BITS comprise an offset
 * into a page of characters.  The upper bits comprise the page number.
 */

#define CCLASS_OFFSET_BITS 6

/*
 * The pageMap is indexed by page number and returns an alternate page number
 * that identifies a unique page of characters.  Many Unicode characters map
 * to the same alternate page number.
 */

static unsigned char cclassPageMap[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 3, 0, 0, 0, 4, 
    5, 6, 7, 0, 8, 9, 10, 0, 0, 0, 0, 0, 0, 11, 12, 11, 13, 11, 13, 11, 
    13, 11, 13, 0, 13, 0, 14, 11, 13, 0, 13, 0, 15, 16, 17, 18, 19, 20, 
    21, 22, 23, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 26, 0, 0, 27, 0, 28, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 
    0, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 0, 
    0, 0, 0, 0, 0
};

/*
 * The cclassGroupMap is indexed by combining the alternate page number with
 * the page offset and returns a combining class number.
 */

static unsigned char cclassGroupMap[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 230, 230, 
    230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 
    230, 230, 230, 230, 232, 220, 220, 220, 220, 232, 216, 220, 220, 220, 
    220, 220, 202, 202, 220, 220, 220, 220, 202, 202, 220, 220, 220, 220, 
    220, 220, 220, 220, 220, 220, 220, 1, 1, 1, 1, 1, 220, 220, 220, 220, 
    230, 230, 230, 230, 230, 230, 230, 230, 240, 230, 220, 220, 220, 230, 
    230, 230, 220, 220, 0, 230, 230, 230, 220, 220, 220, 220, 230, 0, 0, 
    0, 0, 0, 234, 234, 233, 234, 234, 233, 230, 230, 230, 230, 230, 230, 
    230, 230, 230, 230, 230, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 230, 230, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 230, 
    230, 230, 230, 220, 230, 230, 230, 222, 220, 230, 230, 230, 230, 230, 
    230, 0, 220, 220, 220, 220, 220, 230, 230, 220, 230, 230, 222, 228, 
    230, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 0, 20, 21, 22, 0, 23, 
    0, 24, 25, 0, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 230, 230, 230, 230, 230, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 31, 32, 33, 34, 230, 230, 220, 
    220, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 
    230, 230, 230, 230, 230, 230, 0, 0, 230, 230, 230, 230, 220, 230, 0, 
    0, 230, 230, 0, 220, 230, 230, 220, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 220, 230, 230, 220, 230, 230, 220, 
    220, 220, 230, 220, 220, 230, 220, 230, 230, 230, 220, 230, 220, 230, 
    220, 230, 220, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 9, 0, 0, 0, 230, 220, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 
    0, 0, 84, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 103, 103, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    107, 107, 107, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    118, 118, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122, 122, 122, 
    122, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 220, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 0, 220, 0, 
    216, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 130, 0, 132, 0, 0, 0, 0, 0, 130, 
    130, 130, 130, 0, 0, 130, 0, 230, 230, 9, 0, 230, 230, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 228, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222, 230, 220, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 230, 
    1, 1, 230, 230, 230, 230, 1, 1, 1, 230, 230, 0, 0, 0, 0, 230, 0, 0, 
    0, 1, 1, 230, 220, 230, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 218, 228, 232, 222, 224, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 230, 230, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

#define GetUniCharCClass(ch) (cclassGroupMap[(cclassPageMap[(((int)(ch)) & 0xffff) >> CCLASS_OFFSET_BITS] << CCLASS_OFFSET_BITS) | ((ch) & ((1 << CCLASS_OFFSET_BITS)-1))])


#define DECOMP_OFFSET_BITS 5

/*
 * The pageMap is indexed by page number and returns an alternate page number
 * that identifies a unique page of characters.  Many Unicode characters map
 * to the same alternate page number.
 */

static unsigned char decompPageMap[] = {
    0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 12, 0, 0, 0, 13, 
    14, 15, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 26, 27, 
    0, 0, 0, 0, 28, 0, 0, 0, 0, 29, 0, 30, 0, 0, 31, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 33, 0, 0, 0, 34, 0, 0, 35, 
    36, 0, 0, 0, 0, 0, 0, 0, 37, 0, 38, 0, 39, 0, 0, 0, 40, 0, 0, 0, 41, 
    0, 0, 0, 42, 0, 0, 0, 43, 0, 0, 44, 0, 0, 0, 45, 46, 0, 47, 0, 48, 
    49, 50, 51, 0, 0, 0, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 54, 
    55, 0, 0, 0, 0, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
    69, 70, 71, 72, 73, 74, 75, 76, 77, 0, 0, 78, 79, 80, 81, 82, 83, 84, 
    0, 85, 86, 87, 88, 89, 90, 0, 91, 0, 92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    93, 94, 95, 96, 97, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 98, 0, 0, 99, 0, 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 0, 0, 102, 103, 
    104, 105, 106, 107, 108, 109, 0, 110, 111, 112, 113, 114, 115, 116, 
    117, 0, 118, 119, 120, 121, 0, 0, 0, 122, 123, 124, 125, 126, 127, 
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 
    148, 149, 0, 0, 0, 0, 150, 151, 152, 153, 154, 155, 156, 157, 158, 
    159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
    173, 0, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 
    186, 187, 188
};

/*
 * The decompGroupMap is indexed by combining the alternate page number with
 * the page offset and returns a group number that identifies a length and
 * shift of decomposition sequence in decompList
 */

static int decompGroupMap[] = {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65536, 
    -1, -1, -1, -1, -1, -1, -1, 131073, -1, 65539, -1, -1, -1, -1, 131076, 
    -1, -1, 65542, 65543, 131080, 65546, -1, -1, 131083, 65549, 65550, 
    -1, 196623, 196626, 196629, -1, 131096, 131098, 131100, 131102, 131104, 
    131106, -1, 131108, 131110, 131112, 131114, 131116, 131118, 131120, 
    131122, 131124, -1, 131126, 131128, 131130, 131132, 131134, 131136, 
    -1, -1, 131138, 131140, 131142, 131144, 131146, -1, -1, 131148, 131150, 
    131152, 131154, 131156, 131158, -1, 131160, 131162, 131164, 131166, 
    131168, 131170, 131172, 131174, 131176, -1, 131178, 131180, 131182, 
    131184, 131186, 131188, -1, -1, 131190, 131192, 131194, 131196, 131198, 
    -1, 131200, 131202, 131204, 131206, 131208, 131210, 131212, 131214, 
    131216, 131218, 131220, 131222, 131224, 131226, 131228, 131230, 131232, 
    -1, -1, 131234, 131236, 131238, 131240, 131242, 131244, 131246, 131248, 
    131250, 131252, 131254, 131256, 131258, 131260, 131262, 131264, 131266, 
    131268, 131270, 131272, -1, -1, 131274, 131276, 131278, 131280, 131282, 
    131284, 131286, 131288, 131290, -1, 131292, 131294, 131296, 131298, 
    131300, 131302, -1, 131304, 131306, 131308, 131310, 131312, 131314, 
    131316, 131318, -1, -1, 131320, 131322, 131324, 131326, 131328, 131330, 
    131332, -1, -1, 131334, 131336, 131338, 131340, 131342, 131344, -1, 
    -1, 131346, 131348, 131350, 131352, 131354, 131356, 131358, 131360, 
    131362, 131364, 131366, 131368, 131370, 131372, 131374, 131376, 131378, 
    131380, -1, -1, 131382, 131384, 131386, 131388, 131390, 131392, 131394, 
    131396, 131398, 131400, 131402, 131404, 131406, 131408, 131410, 131412, 
    131414, 131416, 131418, 131420, 131422, 131424, 131426, 65892, 131429, 
    131431, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 131433, 
    131435, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 131437, 131439, 131441, 131443, 131445, 131447, 131449, 
    131451, 131453, 131455, 131457, 131459, 131461, 131463, 131465, 131467, 
    131469, 197007, 197010, 197013, 197016, 197019, 197022, 197025, 197028, 
    -1, 197031, 197034, 197037, 197040, 131507, 131509, -1, -1, 131511, 
    131513, 131515, 131517, 131519, 131521, 197059, 197062, 131529, 131531, 
    131533, 131535, 131537, 131539, 131541, 131543, -1, -1, 131545, 131547, 
    197085, 197088, 131555, 131557, 131559, 131561, 131563, 131565, 131567, 
    131569, 131571, 131573, 131575, 131577, 131579, 131581, 131583, 131585, 
    131587, 131589, 131591, 131593, 131595, 131597, 131599, 131601, 131603, 
    131605, 131607, 131609, 131611, 131613, 131615, 131617, -1, -1, 131619, 
    131621, -1, -1, -1, -1, -1, -1, 131623, 131625, 131627, 131629, 197167, 
    197170, 197173, 197176, 131643, 131645, 197183, 197186, 131653, 131655, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 66121, 66122, 66123, 66124, 
    66125, 66126, 66127, 66128, 66129, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 131666, 131668, 131670, 131672, 131674, 131676, 
    -1, -1, 66142, 66143, 65892, 66144, 66145, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 66146, 66147, -1, 66148, 131685, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 66151, -1, -1, -1, -1, -1, 131688, 
    -1, -1, -1, 66154, -1, -1, -1, -1, -1, 131080, 197227, 131694, 66160, 
    131697, 131699, 131701, -1, 131703, -1, 131705, 131707, 197245, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 131712, 131714, 131716, 131718, 131720, 
    131722, 197260, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 131727, 131729, 131731, 
    131733, 131735, -1, 66201, 66202, 66203, 131705, 131714, 66204, 66205, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 66206, 66207, 66208, -1, 66209, 66210, 
    -1, -1, -1, 66211, -1, -1, -1, -1, -1, -1, 131748, 131750, -1, 131752, 
    -1, -1, -1, 131754, -1, -1, -1, -1, 131756, 131758, 131760, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 131762, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 131764, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 131766, 131768, 
    -1, 131770, -1, -1, -1, 131772, -1, -1, -1, -1, 131774, 131776, 131778, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 131780, 131782, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 131784, 131786, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 131788, 131790, 131792, 131794, -1, -1, 131796, 131798, -1, 
    -1, 131800, 131802, 131804, 131806, 131808, 131810, -1, -1, 131812, 
    131814, 131816, 131818, 131820, 131822, -1, -1, 131824, 131826, 131828, 
    131830, 131832, 131834, 131836, 131838, 131840, 131842, 131844, 131846, 
    -1, -1, 131848, 131850, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 131852, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 131854, 131856, 
    131858, 131860, 131862, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 131864, 131866, 131868, 131870, -1, -1, -1, -1, -1, -1, -1, 131872, 
    -1, 131874, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 131876, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 131878, -1, -1, -1, -1, -1, -1, -1, 
    131880, -1, -1, 131882, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 131884, 131886, 131888, 131890, 131892, 
    131894, 131896, 131898, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    131900, 131902, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 131904, 131906, -1, 131908, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 131910, -1, -1, 131912, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    131914, 131916, 131918, -1, -1, 131920, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 131922, -1, -1, 131924, 131926, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 131928, 131930, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    131932, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 131934, 131936, 131938, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 131940, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 131942, -1, -1, 
    -1, -1, -1, -1, 131944, 131946, -1, 131948, 197486, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 131953, 131955, 131957, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 131959, -1, 131961, 197499, 131966, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 131968, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 131970, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 131972, 131974, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 66440, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 131977, -1, -1, -1, -1, -1, -1, -1, -1, -1, 131979, -1, -1, -1, 
    -1, 131981, -1, -1, -1, -1, 131983, -1, -1, -1, -1, 131985, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 131987, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 131989, -1, 131991, 131993, 131995, 131997, 131999, 
    -1, -1, -1, -1, -1, -1, -1, 132001, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 132003, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 132005, -1, -1, -1, -1, 132007, -1, -1, -1, -1, 132009, 
    -1, -1, -1, -1, 132011, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 132013, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 132015, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 66481, 66482, 66483, -1, 66484, 66485, 66486, 66487, 66488, 
    66489, 66490, 66491, 66492, 66493, 66494, -1, 66495, 66496, 66497, 
    66498, 66499, 66500, 66501, 65539, 66502, 66503, 66504, 66505, 66506, 
    66507, 66508, 66509, 66510, 66511, -1, 66512, 66513, 66514, 65550, 
    66515, 66516, 66517, 66518, 66519, 66520, 66521, 66522, 66523, 66524, 
    66201, 66525, 66526, 66204, 66527, 66528, 66124, 66520, 66523, 66201, 
    66525, 66207, 66204, 66527, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 132065, 132067, 132069, 
    132071, 132073, 132075, 132077, 132079, 197617, 197620, 132087, 132089, 
    132091, 132093, 132095, 132097, 132099, 132101, 132103, 132105, 197643, 
    197646, 197649, 197652, 132119, 132121, 132123, 132125, 197663, 197666, 
    132133, 132135, 132137, 132139, 132141, 132143, 132145, 132147, 132149, 
    132151, 132153, 132155, 132157, 132159, 132161, 132163, 197701, 197704, 
    132171, 132173, 132175, 132177, 132179, 132181, 132183, 132185, 197723, 
    197726, 132193, 132195, 132197, 132199, 132201, 132203, 132205, 132207, 
    132209, 132211, 132213, 132215, 132217, 132219, 132221, 132223, 132225, 
    132227, 197765, 197768, 197771, 197774, 197777, 197780, 197783, 197786, 
    132253, 132255, 132257, 132259, 132261, 132263, 132265, 132267, 197805, 
    197808, 132275, 132277, 132279, 132281, 132283, 132285, 197823, 197826, 
    197829, 197832, 197835, 197838, 132305, 132307, 132309, 132311, 132313, 
    132315, 132317, 132319, 132321, 132323, 132325, 132327, 132329, 132331, 
    197869, 197872, 197875, 197878, 132345, 132347, 132349, 132351, 132353, 
    132355, 132357, 132359, 132361, 132363, 132365, 132367, 132369, 132371, 
    132373, 132375, 132377, 132379, 132381, 132383, 132385, 132387, 132389, 
    132391, 132393, 132395, 132397, 132399, 132401, 132403, 132405, 132281, 
    -1, -1, -1, -1, 132407, 132409, 132411, 132413, 197951, 197954, 197957, 
    197960, 197963, 197966, 197969, 197972, 197975, 197978, 197981, 197984, 
    197987, 197990, 197993, 197996, 197999, 198002, 198005, 198008, 132475, 
    132477, 132479, 132481, 132483, 132485, 198023, 198026, 198029, 198032, 
    198035, 198038, 198041, 198044, 198047, 198050, 132517, 132519, 132521, 
    132523, 132525, 132527, 132529, 132531, 198069, 198072, 198075, 198078, 
    198081, 198084, 198087, 198090, 198093, 198096, 198099, 198102, 198105, 
    198108, 198111, 198114, 198117, 198120, 198123, 198126, 132593, 132595, 
    132597, 132599, 198137, 198140, 198143, 198146, 198149, 198152, 198155, 
    198158, 198161, 198164, 132631, 132633, 132635, 132637, 132639, 132641, 
    132643, 132645, -1, -1, -1, -1, -1, -1, 132647, 132649, 198187, 198190, 
    198193, 198196, 198199, 198202, 132669, 132671, 198209, 198212, 198215, 
    198218, 198221, 198224, 132691, 132693, 198231, 198234, 198237, 198240, 
    -1, -1, 132707, 132709, 198247, 198250, 198253, 198256, -1, -1, 132723, 
    132725, 198263, 198266, 198269, 198272, 198275, 198278, 132745, 132747, 
    198285, 198288, 198291, 198294, 198297, 198300, 132767, 132769, 198307, 
    198310, 198313, 198316, 198319, 198322, 132789, 132791, 198329, 198332, 
    198335, 198338, 198341, 198344, 132811, 132813, 198351, 198354, 198357, 
    198360, -1, -1, 132827, 132829, 198367, 198370, 198373, 198376, -1, 
    -1, 132843, 132845, 198383, 198386, 198389, 198392, 198395, 198398, 
    -1, 132865, -1, 198403, -1, 198406, -1, 198409, 132876, 132878, 198416, 
    198419, 198422, 198425, 198428, 198431, 132898, 132900, 198438, 198441, 
    198444, 198447, 198450, 198453, 132920, 131716, 132922, 131718, 132924, 
    131720, 132926, 131722, 132928, 131731, 132930, 131733, 132932, 131735, 
    -1, -1, 198470, 198473, 264012, 264016, 264020, 264024, 264028, 264032, 
    198500, 198503, 264042, 264046, 264050, 264054, 264058, 264062, 198530, 
    198533, 264072, 264076, 264080, 264084, 264088, 264092, 198560, 198563, 
    264102, 264106, 264110, 264114, 264118, 264122, 198590, 198593, 264132, 
    264136, 264140, 264144, 264148, 264152, 198620, 198623, 264162, 264166, 
    264170, 264174, 264178, 264182, 133114, 133116, 198654, 133121, 198659, 
    -1, 133126, 198664, 133131, 133133, 133135, 131694, 133137, 133139, 
    67605, 133139, 133142, 198680, 198683, 133150, 198688, -1, 133155, 
    198693, 133160, 131697, 133162, 131699, 133164, 198702, 198705, 198708, 
    133175, 133177, 198715, 197245, -1, -1, 133182, 198720, 133187, 133189, 
    133191, 131701, -1, 198729, 198732, 198735, 133202, 133204, 198742, 
    197260, 133209, 133211, 133213, 198751, 133218, 133220, 133222, 131705, 
    133224, 198762, 197227, 67693, -1, -1, 198766, 133233, 198771, -1, 
    133238, 198776, 133243, 131703, 133245, 131707, 133247, 131080, 133249, 
    -1, 65536, 65536, 65536, 65536, 65536, 65536, 65536, 65536, 65536, 
    65536, 65536, -1, -1, -1, -1, -1, -1, 67715, -1, -1, -1, -1, -1, 133252, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 67718, 133255, 198793, 
    -1, -1, -1, -1, -1, -1, -1, -1, 65536, -1, -1, -1, 133260, 198798, 
    -1, 133265, 198803, -1, -1, -1, -1, 133270, -1, 133272, -1, -1, -1, 
    -1, -1, -1, -1, -1, 133274, 133276, 133278, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 264352, -1, -1, -1, -1, -1, -1, -1, 65536, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 67748, 
    66528, -1, -1, 67749, 67750, 67751, 67752, 67753, 67754, 67755, 67756, 
    67757, 67758, 67759, 67760, 67748, 65549, 65542, 65543, 67749, 67750, 
    67751, 67752, 67753, 67754, 67755, 67756, 67757, 67758, 67759, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 133297, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 198835, 
    198838, 67769, 133306, -1, 198844, 198847, 67778, -1, 133315, 66511, 
    66488, 66488, 66488, 66121, 67781, 66489, 66489, 66492, 66143, -1, 
    66494, 133318, -1, -1, 66497, 67784, 66498, 66498, 66498, -1, -1, 133321, 
    198859, 133326, -1, 67792, -1, 67793, -1, 67792, -1, 66491, 131106, 
    66483, 67769, -1, 66507, 66485, 67794, -1, 66493, 65550, 67795, 67796, 
    67797, 67798, 66528, -1, 198871, -1, 66525, 67802, 67803, 67804, -1, 
    -1, -1, -1, 66484, 66506, 66507, 66528, 66123, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 198877, 198880, 198883, 198886, 198889, 198892, 198895, 
    198898, 198901, 198904, 198907, 198910, 133377, 66489, 133379, 198917, 
    133384, 67850, 133387, 198925, 264464, 133396, 67862, 133399, 198937, 
    66492, 67769, 66484, 66493, 66528, 133404, 198942, 133409, 66523, 133411, 
    198949, 264488, 133420, 66144, 133422, 198960, 66143, 67891, 66506, 
    66513, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 133428, 133430, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 133432, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 133434, 133436, 
    133438, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 133440, -1, -1, -1, -1, 133442, -1, -1, 133444, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 133446, -1, 133448, -1, -1, -1, -1, -1, 133450, 
    198988, -1, 133455, 198993, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 133460, -1, -1, 133462, -1, -1, 133464, -1, 
    133466, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 133468, -1, 133470, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 133472, 133474, 133476, 133478, 133480, -1, -1, 
    133482, 133484, -1, -1, 133486, 133488, -1, -1, -1, -1, -1, -1, 133490, 
    133492, -1, -1, 133494, 133496, -1, -1, 133498, 133500, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 133502, 133504, 
    133506, 133508, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 133510, 133512, 133514, 133516, -1, -1, -1, -1, -1, -1, 
    133518, 133520, 133522, 133524, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 67990, 67991, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 65549, 65542, 65543, 67749, 67750, 
    67751, 67752, 67753, 67754, 133528, 133530, 133532, 133534, 133536, 
    133538, 133540, 133542, 133544, 133546, 133548, 199086, 199089, 199092, 
    199095, 199098, 199101, 199104, 199107, 199110, 264649, 264653, 264657, 
    264661, 264665, 264669, 264673, 264677, 264681, 264685, 264689, 133621, 
    133623, 133625, 133627, 133629, 133631, 133633, 133635, 133637, 199175, 
    199178, 199181, 199184, 199187, 199190, 199193, 199196, 199199, 199202, 
    199205, 199208, 199211, 199214, 199217, 199220, 199223, 199226, 199229, 
    199232, 199235, 199238, 199241, 199244, 199247, 199250, 199253, 199256, 
    199259, 199262, 199265, 199268, 199271, 199274, 199277, 199280, 199283, 
    66481, 66483, 67769, 66484, 66485, 67794, 66487, 66488, 66489, 66490, 
    66491, 66492, 66493, 66494, 66495, 66497, 67784, 66498, 68214, 66499, 
    66500, 67850, 66501, 67862, 68215, 67792, 65539, 66505, 67891, 66506, 
    66507, 68216, 66511, 66121, 66528, 66123, 66512, 66143, 66513, 67760, 
    65550, 66518, 68217, 66124, 65892, 66519, 66520, 66523, 66128, 66144, 
    66129, 68218, 67748, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 264827, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 199295, 133762, 199300, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 133767, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 68233, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 68234, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 68235, 68236, 68237, 68238, 68239, 68240, 68241, 
    68242, 68243, 68244, 68245, 68246, 68247, 68248, 68249, 68250, 68251, 
    68252, 68253, 68254, 68255, 68256, 68257, 68258, 68259, 68260, 68261, 
    68262, 68263, 68264, 68265, 68266, 68267, 68268, 68269, 68270, 68271, 
    68272, 68273, 68274, 68275, 68276, 68277, 68278, 68279, 68280, 68281, 
    68282, 68283, 68284, 68285, 68286, 68287, 68288, 68289, 68290, 68291, 
    68292, 68293, 68294, 68295, 68296, 68297, 68298, 68299, 68300, 68301, 
    68302, 68303, 68304, 68305, 68306, 68307, 68308, 68309, 68310, 68311, 
    68312, 68313, 68314, 68315, 68316, 68317, 68318, 68319, 68320, 68321, 
    68322, 68323, 68324, 68325, 68326, 68327, 68328, 68329, 68330, 68331, 
    68332, 68333, 68334, 68335, 68336, 68337, 68338, 68339, 68340, 68341, 
    68342, 68343, 68344, 68345, 68346, 68347, 68348, 68349, 68350, 68351, 
    68352, 68353, 68354, 68355, 68356, 68357, 68358, 68359, 68360, 68361, 
    68362, 68363, 68364, 68365, 68366, 68367, 68368, 68369, 68370, 68371, 
    68372, 68373, 68374, 68375, 68376, 68377, 68378, 68379, 68380, 68381, 
    68382, 68383, 68384, 68385, 68386, 68387, 68388, 68389, 68390, 68391, 
    68392, 68393, 68394, 68395, 68396, 68397, 68398, 68399, 68400, 68401, 
    68402, 68403, 68404, 68405, 68406, 68407, 68408, 68409, 68410, 68411, 
    68412, 68413, 68414, 68415, 68416, 68417, 68418, 68419, 68420, 68421, 
    68422, 68423, 68424, 68425, 68426, 68427, 68428, 68429, 68430, 68431, 
    68432, 68433, 68434, 68435, 68436, 68437, 68438, 68439, 68440, 68441, 
    68442, 68443, 68444, 68445, 68446, 68447, 68448, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 65536, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 68449, -1, 68258, 68450, 68451, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    133988, -1, 133990, -1, 133992, -1, 133994, -1, 133996, -1, 133998, 
    -1, 134000, -1, 134002, -1, 134004, -1, 134006, -1, 134008, -1, 134010, 
    -1, -1, 134012, -1, 134014, -1, 134016, -1, -1, -1, -1, -1, -1, 134018, 
    134020, -1, 134022, 134024, -1, 134026, 134028, -1, 134030, 134032, 
    -1, 134034, 134036, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 134038, -1, -1, -1, -1, -1, 
    -1, 134040, 134042, -1, 134044, 134046, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 134048, -1, 134050, -1, 134052, -1, 134054, -1, 
    134056, -1, 134058, -1, 134060, -1, 134062, -1, 134064, -1, 134066, 
    -1, 134068, -1, 134070, -1, -1, 134072, -1, 134074, -1, 134076, -1, 
    -1, -1, -1, -1, -1, 134078, 134080, -1, 134082, 134084, -1, 134086, 
    134088, -1, 134090, 134092, -1, 134094, 134096, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    134098, -1, -1, 134100, 134102, 134104, 134106, -1, -1, -1, 134108, 
    134110, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 68576, 68577, 68578, 68579, 68580, 68581, 68582, 68583, 68584, 
    68585, 68586, 68587, 68588, 68589, 68590, 68591, 68592, 68593, 68594, 
    68595, 68596, 68597, 68598, 68599, 68600, 68601, 68602, 68603, 68604, 
    68605, 68606, 68607, 68608, 68609, 68610, 68611, 68612, 68613, 68614, 
    68615, 68616, 68617, 68618, 68619, 68620, 68621, 68622, 68623, 68624, 
    68625, 68626, 68627, 68628, 68629, 68630, 68631, 68632, 68633, 68634, 
    68635, 68636, 68637, 68638, 68639, 68640, 68641, 68642, 68643, 68644, 
    68645, 68646, 68647, 68648, 68649, 68650, 68651, 68652, 68653, 68654, 
    68655, 68656, 68657, 68658, 68659, 68660, 68661, 68662, 68663, 68664, 
    68665, 68666, 68667, 68668, 68669, -1, -1, -1, 68235, 68241, 68670, 
    68671, 68672, 68673, 68674, 68675, 68239, 68676, 68677, 68678, 68679, 
    68243, 199752, 199755, 199758, 199761, 199764, 199767, 199770, 199773, 
    199776, 199779, 199782, 199785, 199788, 199791, 265330, 265334, 265338, 
    265342, 265346, 265350, 265354, 265358, 265362, 265366, 265370, 265374, 
    265378, 265382, 265386, 461998, 396469, -1, 199867, 199870, 199873, 
    199876, 199879, 199882, 199885, 199888, 199891, 199894, 199897, 199900, 
    199903, 199906, 199909, 199912, 199915, 199918, 199921, 199924, 199927, 
    199930, 199933, 199936, 199939, 199942, 199945, 199948, 199951, 199954, 
    199957, 199960, 199963, 199966, 199969, 199972, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 199975, 134442, 134444, 134446, 134448, 
    134450, 134452, 134454, 134456, 134458, 134460, 134462, 134464, 134466, 
    134468, 134470, 68576, 68579, 68582, 68584, 68592, 68593, 68596, 68598, 
    68599, 68601, 68602, 68603, 68604, 68605, 134472, 134474, 134476, 134478, 
    134480, 134482, 134484, 134486, 134488, 134490, 134492, 134494, 134496, 
    134498, 331108, 265577, -1, -1, 68235, 68241, 68670, 68671, 68973, 
    68974, 68975, 68246, 68976, 68258, 68308, 68320, 68319, 68309, 68401, 
    68266, 68306, 68977, 68978, 68979, 68980, 68981, 68982, 68983, 68984, 
    68985, 68986, 68272, 68987, 68988, 68989, 68990, 68991, 68992, 68993, 
    68994, 68672, 68673, 68674, 68995, 68996, 68997, 68998, 68999, 69000, 
    69001, 69002, 69003, 69004, 134541, 134543, 134545, 134547, 134549, 
    134551, 134553, 134555, 134557, 134559, 134561, 134563, 134565, 134567, 
    134569, 134571, 134573, 134575, 134577, 134579, 134581, 134583, 134585, 
    134587, 200125, 200128, 200131, 134598, 200136, 134603, 200141, 69072, 
    69073, 69074, 69075, 69076, 69077, 69078, 69079, 69080, 69081, 69082, 
    69083, 69084, 69085, 69086, 69087, 69088, 69089, 69090, 69091, 69092, 
    69093, 69094, 69095, 69096, 69097, 69098, 69099, 69100, 69101, 69102, 
    69103, 69104, 69105, 69106, 69107, 69108, 69109, 69110, 69111, 69112, 
    69113, 69114, 69115, 69116, 69117, 69118, -1, 265727, 265731, 265735, 
    200203, 265742, 200210, 200213, 331288, 265757, 200225, 200228, 200231, 
    265770, 265774, 265778, 265782, 200250, 265789, 265793, 331333, 134730, 
    331340, 396881, 331351, 265820, 396896, 331366, 265835, 200303, 200306, 
    200309, 265848, 331388, 265857, 200325, 200328, 265867, 200335, 200338, 
    134805, 134807, 200345, 200348, 396959, 265893, 331433, 396974, 265908, 
    200376, 200379, 331454, 265923, 396999, 200397, 331472, 200405, 265944, 
    200412, 265951, 265955, 265959, 331499, 265968, 134900, 265974, 200442, 
    200445, 265984, 200452, 200455, 200458, 331533, 266002, 134934, 331544, 
    134941, 266015, 266019, 200487, 200490, 200493, 266032, 134964, 200502, 
    266041, 134973, 331583, 200516, 134983, 134985, 134987, 134989, 134991, 
    134993, 134995, 134997, 134999, 135001, 200539, 200542, 200545, 200548, 
    200551, 200554, 200557, 200560, 200563, 200566, 200569, 200572, 200575, 
    200578, 200581, 200584, 135051, 135053, 200591, 135058, 135060, 135062, 
    200600, 200603, 135070, 135072, 135074, 135076, 135078, 266152, 135084, 
    135086, 135088, 135090, 135092, 135094, 135096, 135098, 200636, 266175, 
    135107, 135109, 135111, 135113, 135115, 135117, 135119, 200657, 200660, 
    200663, 200666, 135133, 135135, 135137, 135139, 135141, 135143, 135145, 
    135147, 135149, 135151, 200689, 200692, 135159, 200697, 200700, 200703, 
    135170, 200708, 200711, 266250, 135182, 200720, 200723, 200726, 200729, 
    331804, 397345, 135207, 135209, 135211, 135213, 135215, 135217, 135219, 
    135221, 135223, 135225, 135227, 135229, 135231, 135233, 135235, 135237, 
    135239, 135241, 266315, 135247, 135249, 135251, 266325, 200793, 135260, 
    135262, 135264, 135266, 135268, 135270, 135272, 135274, 135276, 135278, 
    200816, 135283, 135285, 200823, 200826, 135293, 266367, 200835, 135302, 
    135304, 135306, 135308, 200846, 200849, 135316, 135318, 135320, 135322, 
    135324, 135326, 135328, 135330, 135332, 200870, 200873, 200876, 200879, 
    200882, 200885, 200888, 200891, 200894, 200897, 200900, 200903, 200906, 
    200909, 200912, 200915, 200918, 200921, 200924, 200927, 200930, 200933, 
    200936, 69867, 69868, 68393, 69869, 69870, 69871, 69872, 68447, 68447, 
    69873, 68401, 69874, 69875, 69876, 69877, 69878, 69879, 69880, 69881, 
    69882, 69883, 69884, 69885, 69886, 69887, 69888, 69889, 69890, 69891, 
    69892, 69893, 69894, 69895, 69896, 69897, 69898, 69899, 69900, 69901, 
    69902, 69903, 69904, 69905, 69906, 69907, 69908, 69909, 69910, 69911, 
    69912, 69913, 69914, 68359, 69915, 69916, 69917, 69918, 69919, 69920, 
    69921, 69922, 69923, 69924, 69925, 68432, 69926, 69927, 69928, 69929, 
    69930, 69931, 69932, 69933, 69934, 69935, 69936, 69937, 69938, 69939, 
    69940, 69941, 69942, 69943, 69944, 69945, 69946, 69947, 69948, 69949, 
    69950, 69951, 69952, 69883, 69953, 69954, 69955, 69956, 69957, 69958, 
    69959, 69960, 69961, 69962, 69963, 69964, 69965, 69966, 69967, 69968, 
    69969, 69970, 69971, 69972, 68395, 69973, 69974, 69975, 69976, 69977, 
    69978, 69979, 69980, 69981, 69982, 69983, 69984, 69985, 69986, 69987, 
    68272, 69988, 69989, 69990, 69991, 69992, 69993, 69994, 69995, 68253, 
    69996, 69997, 69998, 69999, 70000, 70001, 70002, 70003, 70004, 70005, 
    70006, 70007, 70008, 70009, 70010, 70011, 70012, 70013, 70014, 70015, 
    70016, 70017, 69971, 70018, 70019, 70020, 70021, 70022, 70023, 70024, 
    70025, 69955, 70026, 70027, 70028, 70029, 70030, 70031, 70032, 70033, 
    70034, 70035, 70036, 70037, 70038, 70039, 70040, 70041, 70042, 70043, 
    70044, 70045, 69883, 70046, 70047, 70048, 70049, 68446, 70050, 70051, 
    70052, 70053, 70054, 70055, 70056, 70057, 70058, 70059, 70060, 70061, 
    68974, 70062, 70063, 70064, 70065, 70066, 70067, 70068, 70069, 70070, 
    69957, 70071, 70072, 70073, 70074, 70075, 70076, 70077, 70078, 70079, 
    70080, 70081, 70082, 70083, 68400, 70084, 70085, 70086, 70087, 70088, 
    70089, 70090, 70091, 70092, 70093, 70094, 70095, 70096, 68351, 70097, 
    70098, 70099, 70100, 70101, 70102, 70103, 70104, 70105, 70106, 70107, 
    70108, 70109, 70110, 70111, 70112, 68378, 70113, 68381, 70114, 70115, 
    70116, -1, -1, 70117, -1, 70118, -1, -1, 70119, 70120, 70121, 70122, 
    70123, 70124, 70125, 70126, 70127, 68358, -1, 70128, -1, 70129, -1, 
    -1, 70130, 70131, -1, -1, -1, 70132, 70133, 70134, 70135, -1, -1, 70136, 
    70137, 70138, 70139, 70140, 70141, 70142, 70143, 70144, 70145, 70146, 
    70147, 68279, 70148, 70149, 70150, 70151, 70152, 70153, 70154, 70155, 
    70156, 70157, 70158, 70159, 70160, 70161, 70162, 68979, 70163, 70164, 
    70165, 70166, 68983, 70167, 70168, 70169, 70170, 70171, 70007, 70172, 
    70173, 70174, 70175, 70176, 70177, 70177, 70178, 70179, 70180, 70181, 
    70182, 70183, 70184, 70185, 70130, 70186, 70187, 70188, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 135725, 135727, 135729, 201267, 201270, 135737, 135737, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 135739, 135741, 135743, 135745, 
    135747, -1, -1, -1, -1, -1, 135749, -1, 135751, 70217, 67795, 67798, 
    70218, 70219, 70220, 70221, 70222, 70223, 67755, 135760, 135762, 201300, 
    201303, 135770, 135772, 135774, 135776, 135778, 135780, 135782, 135784, 
    135786, -1, 135788, 135790, 135792, 135794, 135796, -1, 135798, -1, 
    135800, 135802, -1, 135804, 135806, -1, 135808, 135810, 135812, 135814, 
    135816, 135818, 135820, 135822, 135824, 135826, 70292, 70292, 70293, 
    70293, 70293, 70293, 70294, 70294, 70294, 70294, 70295, 70295, 70295, 
    70295, 70296, 70296, 70296, 70296, 70297, 70297, 70297, 70297, 70298, 
    70298, 70298, 70298, 70299, 70299, 70299, 70299, 70300, 70300, 70300, 
    70300, 70301, 70301, 70301, 70301, 70302, 70302, 70302, 70302, 70303, 
    70303, 70303, 70303, 70304, 70304, 70304, 70304, 70305, 70305, 70306, 
    70306, 70307, 70307, 70308, 70308, 70309, 70309, 70310, 70310, 70311, 
    70311, 70311, 70311, 70312, 70312, 70312, 70312, 70313, 70313, 70313, 
    70313, 70314, 70314, 70314, 70314, 70315, 70315, 70316, 70316, 70316, 
    70316, 131872, 131872, 70317, 70317, 70317, 70317, 70318, 70318, 70318, 
    70318, 70319, 70319, 131876, 131876, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 70320, 70320, 70320, 70320, 70321, 
    70321, 70322, 70322, 70323, 70323, 131868, 70324, 70324, 70325, 70325, 
    70326, 70326, 70327, 70327, 70327, 70327, 70328, 70328, 201401, 201401, 
    201404, 201404, 201407, 201407, 201410, 201410, 201413, 201413, 201416, 
    201416, 201419, 201419, 201419, 201422, 201422, 201422, 70353, 70353, 
    70353, 70353, 201426, 201429, 201432, 201422, 201435, 135902, 135904, 
    135906, 135908, 135910, 135912, 135914, 135916, 135918, 135920, 135922, 
    135924, 135926, 135928, 135930, 135932, 135934, 135936, 135938, 135940, 
    135942, 135944, 135946, 135948, 135950, 135952, 135954, 135956, 135958, 
    135960, 135962, 135964, 135966, 135968, 135970, 135972, 135974, 135976, 
    135978, 135980, 135982, 135984, 135986, 135988, 135990, 135992, 135994, 
    135996, 135998, 136000, 136002, 136004, 136006, 136008, 136010, 136012, 
    136014, 136016, 136018, 136020, 136022, 136024, 136026, 136028, 136030, 
    136032, 136034, 136036, 136038, 136040, 136042, 136044, 136046, 136048, 
    136050, 136052, 136054, 136056, 136058, 136060, 136062, 136064, 136066, 
    136068, 136070, 136072, 136074, 136076, 136078, 201616, 201619, 201622, 
    201625, 201628, 201631, 201634, 201637, 201432, 201640, 201422, 201435, 
    136107, 136109, 135908, 136111, 135910, 135912, 136113, 136115, 135920, 
    136117, 135922, 135924, 136119, 136121, 135928, 136123, 135930, 135932, 
    135990, 135992, 135998, 136000, 136002, 136010, 136012, 136014, 136016, 
    136024, 136026, 136028, 136125, 136036, 136127, 136129, 136048, 136131, 
    136050, 136052, 136078, 136133, 136135, 136068, 136137, 136070, 136072, 
    201426, 201429, 201675, 201432, 201678, 135902, 135904, 135906, 135908, 
    136145, 135914, 135916, 135918, 135920, 136147, 135928, 135934, 135936, 
    135938, 135940, 135942, 135946, 135948, 135950, 135952, 135954, 135956, 
    136149, 135958, 135960, 135962, 135964, 135966, 135968, 135972, 135974, 
    135976, 135978, 135980, 135982, 135984, 135986, 135988, 135994, 135996, 
    136004, 136006, 136008, 136010, 136012, 136018, 136020, 136022, 136024, 
    136151, 136030, 136032, 136034, 136036, 136042, 136044, 136046, 136048, 
    136153, 136054, 136056, 136155, 136062, 136064, 136066, 136068, 136157, 
    201432, 201678, 135908, 136145, 135920, 136147, 135928, 136159, 135954, 
    136161, 136163, 136165, 136010, 136012, 136024, 136048, 136153, 136068, 
    136157, 201703, 201706, 201709, 136176, 136178, 136180, 136182, 136184, 
    136186, 136188, 136190, 136192, 136194, 136196, 136198, 136200, 136202, 
    136204, 136206, 136208, 136210, 136212, 136214, 136216, 136218, 136220, 
    136163, 136222, 136224, 136226, 136228, 136176, 136178, 136180, 136182, 
    136184, 136186, 136188, 136190, 136192, 136194, 136196, 136198, 136200, 
    136202, 136204, 136206, 136208, 136210, 136212, 136214, 136216, 136218, 
    136220, 136163, 136222, 136224, 136226, 136228, 136216, 136218, 136220, 
    136163, 136161, 136165, 135970, 135948, 135950, 135952, 136216, 136218, 
    136220, 135970, 135972, 136230, 136230, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 201768, 201771, 201771, 
    201774, 201777, 201780, 201783, 201786, 201789, 201789, 201792, 201795, 
    201798, 201801, 201804, 201807, 201807, 201810, 201813, 201813, 201816, 
    201816, 201819, 201822, 201822, 201825, 201828, 201828, 201831, 201831, 
    201834, 201837, 201837, 201840, 201840, 201843, 201846, 201849, 201852, 
    201852, 201855, 201858, 201861, 201864, 201867, 201867, 201870, 201873, 
    201876, 201879, 201882, 201885, 201885, 201888, 201888, 201891, 201891, 
    201894, 201897, 201900, 201903, 201906, 201909, 201912, -1, -1, 201915, 
    201918, 201921, 201924, 201927, 201930, 201930, 201933, 201936, 201939, 
    201942, 201942, 201945, 201948, 201951, 201954, 201957, 201960, 201963, 
    201966, 201969, 201972, 201975, 201978, 201981, 201984, 201987, 201990, 
    201993, 201996, 201999, 202002, 202005, 202008, 201870, 201876, 202011, 
    202014, 202017, 202020, 202023, 202026, 202023, 202017, 202029, 202032, 
    202035, 202038, 202041, 202026, 201849, 201819, 202044, 202047, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 202050, 202053, 267592, 267596, 267600, 267604, 
    267608, 267612, 267616, 202084, 1185127, 529785, 267649, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 133255, 
    71045, 71046, 71047, 71047, 67758, 67759, 71048, 71049, 71050, 71051, 
    71052, 71053, 71054, 71055, 67990, 67991, 71056, 71057, 71058, 71059, 
    -1, -1, 71060, 71061, 133272, 133272, 133272, 133272, 71047, 71047, 
    71047, 71062, 71063, 67718, -1, 66154, 71064, 71065, 71066, 71045, 
    67758, 67759, 71048, 71049, 71050, 71051, 71067, 71068, 71069, 67755, 
    71070, 71071, 71072, 67757, -1, 71073, 71074, 71075, 71076, -1, -1, 
    -1, -1, 136613, 136615, 136617, -1, 136619, -1, 136621, 136623, 136625, 
    136627, 136629, 136631, 136633, 136635, 136637, 136639, 71105, 131854, 
    131854, 131856, 131856, 131858, 131858, 131860, 131860, 131862, 131862, 
    131862, 131862, 71106, 71106, 71107, 71107, 71107, 71107, 71108, 71108, 
    71109, 71109, 71109, 71109, 71110, 71110, 71110, 71110, 71111, 71111, 
    71111, 71111, 71112, 71112, 71112, 71112, 71113, 71113, 71113, 71113, 
    71114, 71114, 71115, 71115, 71116, 71116, 71117, 71117, 71118, 71118, 
    71118, 71118, 71119, 71119, 71119, 71119, 71120, 71120, 71120, 71120, 
    71121, 71121, 71121, 71121, 71122, 71122, 71122, 71122, 71123, 71123, 
    71123, 71123, 71124, 71124, 71124, 71124, 71125, 71125, 71125, 71125, 
    71126, 71126, 71126, 71126, 71127, 71127, 71127, 71127, 71128, 71128, 
    71128, 71128, 71129, 71129, 71129, 71129, 71130, 71130, 71130, 71130, 
    71131, 71131, 71131, 71131, 71132, 71132, 71132, 71132, 71133, 71133, 
    70328, 70328, 71134, 71134, 71134, 71134, 136671, 136671, 136673, 136673, 
    136675, 136675, 136677, 136677, -1, -1, -1, -1, 71066, 71143, 71067, 
    71074, 71075, 71068, 71144, 67758, 67759, 71069, 67755, 71062, 71070, 
    67718, 71145, 67748, 65549, 65542, 65543, 67749, 67750, 67751, 67752, 
    67753, 67754, 71064, 66154, 71071, 67757, 71072, 71065, 71076, 66481, 
    66483, 67769, 66484, 66485, 67794, 66487, 66488, 66489, 66490, 66491, 
    66492, 66493, 66494, 66495, 66497, 67784, 66498, 68214, 66499, 66500, 
    67850, 66501, 67862, 68215, 67792, 71060, 71073, 71061, 71146, 71047, 
    67693, 65539, 66505, 67891, 66506, 66507, 68216, 66511, 66121, 66528, 
    66123, 66512, 66143, 66513, 67760, 65550, 66518, 68217, 66124, 65892, 
    66519, 66520, 66523, 66128, 66144, 66129, 68218, 71048, 71147, 71049, 
    71148, 71149, 71150, 71151, 71056, 71057, 71063, 71152, 69118, 71153, 
    71154, 71155, 71156, 71157, 71158, 71159, 71160, 71161, 71162, 69072, 
    69073, 69074, 69075, 69076, 69077, 69078, 69079, 69080, 69081, 69082, 
    69083, 69084, 69085, 69086, 69087, 69088, 69089, 69090, 69091, 69092, 
    69093, 69094, 69095, 69096, 69097, 69098, 69099, 69100, 69101, 69102, 
    69103, 69104, 69105, 69106, 69107, 69108, 69109, 69110, 69111, 69112, 
    69113, 69114, 69115, 71163, 71164, 71165, 68627, 68576, 68577, 68578, 
    68579, 68580, 68581, 68582, 68583, 68584, 68585, 68586, 68587, 68588, 
    68589, 68590, 68591, 68592, 68593, 68594, 68595, 68596, 68597, 68598, 
    68599, 68600, 68601, 68602, 68603, 68604, 68605, -1, -1, -1, 68606, 
    68607, 68608, 68609, 68610, 68611, -1, -1, 68612, 68613, 68614, 68615, 
    68616, 68617, -1, -1, 68618, 68619, 68620, 68621, 68622, 68623, -1, 
    -1, 68624, 68625, 68626, -1, -1, -1, 71166, 71167, 71168, 131076, 71169, 
    71170, 71171, -1, 71172, 71173, 71174, 71175, 71176, 71177, 71178, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

/*
 * List of decomposition sequences
 */

static int decompList[] = {
    32, 32, 776, 97, 32, 772, 50, 51, 32, 769, 956, 32, 807, 49, 111, 49, 
    8260, 52, 49, 8260, 50, 51, 8260, 52, 65, 768, 65, 769, 65, 770, 65, 
    771, 65, 776, 65, 778, 67, 807, 69, 768, 69, 769, 69, 770, 69, 776, 
    73, 768, 73, 769, 73, 770, 73, 776, 78, 771, 79, 768, 79, 769, 79, 
    770, 79, 771, 79, 776, 85, 768, 85, 769, 85, 770, 85, 776, 89, 769, 
    97, 768, 97, 769, 97, 770, 97, 771, 97, 776, 97, 778, 99, 807, 101, 
    768, 101, 769, 101, 770, 101, 776, 105, 768, 105, 769, 105, 770, 105, 
    776, 110, 771, 111, 768, 111, 769, 111, 770, 111, 771, 111, 776, 117, 
    768, 117, 769, 117, 770, 117, 776, 121, 769, 121, 776, 65, 772, 97, 
    772, 65, 774, 97, 774, 65, 808, 97, 808, 67, 769, 99, 769, 67, 770, 
    99, 770, 67, 775, 99, 775, 67, 780, 99, 780, 68, 780, 100, 780, 69, 
    772, 101, 772, 69, 774, 101, 774, 69, 775, 101, 775, 69, 808, 101, 
    808, 69, 780, 101, 780, 71, 770, 103, 770, 71, 774, 103, 774, 71, 775, 
    103, 775, 71, 807, 103, 807, 72, 770, 104, 770, 73, 771, 105, 771, 
    73, 772, 105, 772, 73, 774, 105, 774, 73, 808, 105, 808, 73, 775, 73, 
    74, 105, 106, 74, 770, 106, 770, 75, 807, 107, 807, 76, 769, 108, 769, 
    76, 807, 108, 807, 76, 780, 108, 780, 76, 183, 108, 183, 78, 769, 110, 
    769, 78, 807, 110, 807, 78, 780, 110, 780, 700, 110, 79, 772, 111, 
    772, 79, 774, 111, 774, 79, 779, 111, 779, 82, 769, 114, 769, 82, 807, 
    114, 807, 82, 780, 114, 780, 83, 769, 115, 769, 83, 770, 115, 770, 
    83, 807, 115, 807, 83, 780, 115, 780, 84, 807, 116, 807, 84, 780, 116, 
    780, 85, 771, 117, 771, 85, 772, 117, 772, 85, 774, 117, 774, 85, 778, 
    117, 778, 85, 779, 117, 779, 85, 808, 117, 808, 87, 770, 119, 770, 
    89, 770, 121, 770, 89, 776, 90, 769, 122, 769, 90, 775, 122, 775, 90, 
    780, 122, 780, 115, 79, 795, 111, 795, 85, 795, 117, 795, 68, 381, 
    68, 382, 100, 382, 76, 74, 76, 106, 108, 106, 78, 74, 78, 106, 110, 
    106, 65, 780, 97, 780, 73, 780, 105, 780, 79, 780, 111, 780, 85, 780, 
    117, 780, 85, 776, 772, 117, 776, 772, 85, 776, 769, 117, 776, 769, 
    85, 776, 780, 117, 776, 780, 85, 776, 768, 117, 776, 768, 65, 776, 
    772, 97, 776, 772, 65, 775, 772, 97, 775, 772, 198, 772, 230, 772, 
    71, 780, 103, 780, 75, 780, 107, 780, 79, 808, 111, 808, 79, 808, 772, 
    111, 808, 772, 439, 780, 658, 780, 106, 780, 68, 90, 68, 122, 100, 
    122, 71, 769, 103, 769, 78, 768, 110, 768, 65, 778, 769, 97, 778, 769, 
    198, 769, 230, 769, 216, 769, 248, 769, 65, 783, 97, 783, 65, 785, 
    97, 785, 69, 783, 101, 783, 69, 785, 101, 785, 73, 783, 105, 783, 73, 
    785, 105, 785, 79, 783, 111, 783, 79, 785, 111, 785, 82, 783, 114, 
    783, 82, 785, 114, 785, 85, 783, 117, 783, 85, 785, 117, 785, 83, 806, 
    115, 806, 84, 806, 116, 806, 72, 780, 104, 780, 65, 775, 97, 775, 69, 
    807, 101, 807, 79, 776, 772, 111, 776, 772, 79, 771, 772, 111, 771, 
    772, 79, 775, 111, 775, 79, 775, 772, 111, 775, 772, 89, 772, 121, 
    772, 104, 614, 106, 114, 633, 635, 641, 119, 121, 32, 774, 32, 775, 
    32, 778, 32, 808, 32, 771, 32, 779, 611, 108, 120, 661, 768, 769, 787, 
    776, 769, 697, 32, 837, 59, 32, 776, 769, 913, 769, 183, 917, 769, 
    919, 769, 921, 769, 927, 769, 933, 769, 937, 769, 953, 776, 769, 921, 
    776, 933, 776, 945, 769, 949, 769, 951, 769, 953, 769, 965, 776, 769, 
    953, 776, 965, 776, 959, 769, 965, 769, 969, 769, 946, 952, 933, 966, 
    960, 954, 961, 962, 920, 949, 931, 1045, 768, 1045, 776, 1043, 769, 
    1030, 776, 1050, 769, 1048, 768, 1059, 774, 1048, 774, 1080, 774, 1077, 
    768, 1077, 776, 1075, 769, 1110, 776, 1082, 769, 1080, 768, 1091, 774, 
    1140, 783, 1141, 783, 1046, 774, 1078, 774, 1040, 774, 1072, 774, 1040, 
    776, 1072, 776, 1045, 774, 1077, 774, 1240, 776, 1241, 776, 1046, 776, 
    1078, 776, 1047, 776, 1079, 776, 1048, 772, 1080, 772, 1048, 776, 1080, 
    776, 1054, 776, 1086, 776, 1256, 776, 1257, 776, 1069, 776, 1101, 776, 
    1059, 772, 1091, 772, 1059, 776, 1091, 776, 1059, 779, 1091, 779, 1063, 
    776, 1095, 776, 1067, 776, 1099, 776, 1381, 1410, 1575, 1619, 1575, 
    1620, 1608, 1620, 1575, 1621, 1610, 1620, 1575, 1652, 1608, 1652, 1735, 
    1652, 1610, 1652, 1749, 1620, 1729, 1620, 1746, 1620, 2344, 2364, 2352, 
    2364, 2355, 2364, 2325, 2364, 2326, 2364, 2327, 2364, 2332, 2364, 2337, 
    2364, 2338, 2364, 2347, 2364, 2351, 2364, 2503, 2494, 2503, 2519, 2465, 
    2492, 2466, 2492, 2479, 2492, 2610, 2620, 2616, 2620, 2582, 2620, 2583, 
    2620, 2588, 2620, 2603, 2620, 2887, 2902, 2887, 2878, 2887, 2903, 2849, 
    2876, 2850, 2876, 2962, 3031, 3014, 3006, 3015, 3006, 3014, 3031, 3142, 
    3158, 3263, 3285, 3270, 3285, 3270, 3286, 3270, 3266, 3270, 3266, 3285, 
    3398, 3390, 3399, 3390, 3398, 3415, 3545, 3530, 3545, 3535, 3545, 3535, 
    3530, 3545, 3551, 3661, 3634, 3789, 3762, 3755, 3737, 3755, 3745, 3851, 
    3906, 4023, 3916, 4023, 3921, 4023, 3926, 4023, 3931, 4023, 3904, 4021, 
    3953, 3954, 3953, 3956, 4018, 3968, 4018, 3969, 4019, 3968, 4019, 3969, 
    3953, 3968, 3986, 4023, 3996, 4023, 4001, 4023, 4006, 4023, 4011, 4023, 
    3984, 4021, 4133, 4142, 65, 198, 66, 68, 69, 398, 71, 72, 73, 74, 75, 
    76, 77, 78, 79, 546, 80, 82, 84, 85, 87, 592, 593, 7426, 98, 100, 101, 
    601, 603, 604, 103, 107, 109, 331, 596, 7446, 7447, 112, 116, 117, 
    7453, 623, 118, 7461, 947, 948, 967, 105, 65, 805, 97, 805, 66, 775, 
    98, 775, 66, 803, 98, 803, 66, 817, 98, 817, 67, 807, 769, 99, 807, 
    769, 68, 775, 100, 775, 68, 803, 100, 803, 68, 817, 100, 817, 68, 807, 
    100, 807, 68, 813, 100, 813, 69, 772, 768, 101, 772, 768, 69, 772, 
    769, 101, 772, 769, 69, 813, 101, 813, 69, 816, 101, 816, 69, 807, 
    774, 101, 807, 774, 70, 775, 102, 775, 71, 772, 103, 772, 72, 775, 
    104, 775, 72, 803, 104, 803, 72, 776, 104, 776, 72, 807, 104, 807, 
    72, 814, 104, 814, 73, 816, 105, 816, 73, 776, 769, 105, 776, 769, 
    75, 769, 107, 769, 75, 803, 107, 803, 75, 817, 107, 817, 76, 803, 108, 
    803, 76, 803, 772, 108, 803, 772, 76, 817, 108, 817, 76, 813, 108, 
    813, 77, 769, 109, 769, 77, 775, 109, 775, 77, 803, 109, 803, 78, 775, 
    110, 775, 78, 803, 110, 803, 78, 817, 110, 817, 78, 813, 110, 813, 
    79, 771, 769, 111, 771, 769, 79, 771, 776, 111, 771, 776, 79, 772, 
    768, 111, 772, 768, 79, 772, 769, 111, 772, 769, 80, 769, 112, 769, 
    80, 775, 112, 775, 82, 775, 114, 775, 82, 803, 114, 803, 82, 803, 772, 
    114, 803, 772, 82, 817, 114, 817, 83, 775, 115, 775, 83, 803, 115, 
    803, 83, 769, 775, 115, 769, 775, 83, 780, 775, 115, 780, 775, 83, 
    803, 775, 115, 803, 775, 84, 775, 116, 775, 84, 803, 116, 803, 84, 
    817, 116, 817, 84, 813, 116, 813, 85, 804, 117, 804, 85, 816, 117, 
    816, 85, 813, 117, 813, 85, 771, 769, 117, 771, 769, 85, 772, 776, 
    117, 772, 776, 86, 771, 118, 771, 86, 803, 118, 803, 87, 768, 119, 
    768, 87, 769, 119, 769, 87, 776, 119, 776, 87, 775, 119, 775, 87, 803, 
    119, 803, 88, 775, 120, 775, 88, 776, 120, 776, 89, 775, 121, 775, 
    90, 770, 122, 770, 90, 803, 122, 803, 90, 817, 122, 817, 104, 817, 
    116, 776, 119, 778, 121, 778, 97, 702, 65, 803, 97, 803, 65, 777, 97, 
    777, 65, 770, 769, 97, 770, 769, 65, 770, 768, 97, 770, 768, 65, 770, 
    777, 97, 770, 777, 65, 770, 771, 97, 770, 771, 65, 803, 770, 97, 803, 
    770, 65, 774, 769, 97, 774, 769, 65, 774, 768, 97, 774, 768, 65, 774, 
    777, 97, 774, 777, 65, 774, 771, 97, 774, 771, 65, 803, 774, 97, 803, 
    774, 69, 803, 101, 803, 69, 777, 101, 777, 69, 771, 101, 771, 69, 770, 
    769, 101, 770, 769, 69, 770, 768, 101, 770, 768, 69, 770, 777, 101, 
    770, 777, 69, 770, 771, 101, 770, 771, 69, 803, 770, 101, 803, 770, 
    73, 777, 105, 777, 73, 803, 105, 803, 79, 803, 111, 803, 79, 777, 111, 
    777, 79, 770, 769, 111, 770, 769, 79, 770, 768, 111, 770, 768, 79, 
    770, 777, 111, 770, 777, 79, 770, 771, 111, 770, 771, 79, 803, 770, 
    111, 803, 770, 79, 795, 769, 111, 795, 769, 79, 795, 768, 111, 795, 
    768, 79, 795, 777, 111, 795, 777, 79, 795, 771, 111, 795, 771, 79, 
    795, 803, 111, 795, 803, 85, 803, 117, 803, 85, 777, 117, 777, 85, 
    795, 769, 117, 795, 769, 85, 795, 768, 117, 795, 768, 85, 795, 777, 
    117, 795, 777, 85, 795, 771, 117, 795, 771, 85, 795, 803, 117, 795, 
    803, 89, 768, 121, 768, 89, 803, 121, 803, 89, 777, 121, 777, 89, 771, 
    121, 771, 945, 787, 945, 788, 945, 787, 768, 945, 788, 768, 945, 787, 
    769, 945, 788, 769, 945, 787, 834, 945, 788, 834, 913, 787, 913, 788, 
    913, 787, 768, 913, 788, 768, 913, 787, 769, 913, 788, 769, 913, 787, 
    834, 913, 788, 834, 949, 787, 949, 788, 949, 787, 768, 949, 788, 768, 
    949, 787, 769, 949, 788, 769, 917, 787, 917, 788, 917, 787, 768, 917, 
    788, 768, 917, 787, 769, 917, 788, 769, 951, 787, 951, 788, 951, 787, 
    768, 951, 788, 768, 951, 787, 769, 951, 788, 769, 951, 787, 834, 951, 
    788, 834, 919, 787, 919, 788, 919, 787, 768, 919, 788, 768, 919, 787, 
    769, 919, 788, 769, 919, 787, 834, 919, 788, 834, 953, 787, 953, 788, 
    953, 787, 768, 953, 788, 768, 953, 787, 769, 953, 788, 769, 953, 787, 
    834, 953, 788, 834, 921, 787, 921, 788, 921, 787, 768, 921, 788, 768, 
    921, 787, 769, 921, 788, 769, 921, 787, 834, 921, 788, 834, 959, 787, 
    959, 788, 959, 787, 768, 959, 788, 768, 959, 787, 769, 959, 788, 769, 
    927, 787, 927, 788, 927, 787, 768, 927, 788, 768, 927, 787, 769, 927, 
    788, 769, 965, 787, 965, 788, 965, 787, 768, 965, 788, 768, 965, 787, 
    769, 965, 788, 769, 965, 787, 834, 965, 788, 834, 933, 788, 933, 788, 
    768, 933, 788, 769, 933, 788, 834, 969, 787, 969, 788, 969, 787, 768, 
    969, 788, 768, 969, 787, 769, 969, 788, 769, 969, 787, 834, 969, 788, 
    834, 937, 787, 937, 788, 937, 787, 768, 937, 788, 768, 937, 787, 769, 
    937, 788, 769, 937, 787, 834, 937, 788, 834, 945, 768, 949, 768, 951, 
    768, 953, 768, 959, 768, 965, 768, 969, 768, 945, 787, 837, 945, 788, 
    837, 945, 787, 768, 837, 945, 788, 768, 837, 945, 787, 769, 837, 945, 
    788, 769, 837, 945, 787, 834, 837, 945, 788, 834, 837, 913, 787, 837, 
    913, 788, 837, 913, 787, 768, 837, 913, 788, 768, 837, 913, 787, 769, 
    837, 913, 788, 769, 837, 913, 787, 834, 837, 913, 788, 834, 837, 951, 
    787, 837, 951, 788, 837, 951, 787, 768, 837, 951, 788, 768, 837, 951, 
    787, 769, 837, 951, 788, 769, 837, 951, 787, 834, 837, 951, 788, 834, 
    837, 919, 787, 837, 919, 788, 837, 919, 787, 768, 837, 919, 788, 768, 
    837, 919, 787, 769, 837, 919, 788, 769, 837, 919, 787, 834, 837, 919, 
    788, 834, 837, 969, 787, 837, 969, 788, 837, 969, 787, 768, 837, 969, 
    788, 768, 837, 969, 787, 769, 837, 969, 788, 769, 837, 969, 787, 834, 
    837, 969, 788, 834, 837, 937, 787, 837, 937, 788, 837, 937, 787, 768, 
    837, 937, 788, 768, 837, 937, 787, 769, 837, 937, 788, 769, 837, 937, 
    787, 834, 837, 937, 788, 834, 837, 945, 774, 945, 772, 945, 768, 837, 
    945, 837, 945, 769, 837, 945, 834, 945, 834, 837, 913, 774, 913, 772, 
    913, 768, 913, 837, 32, 787, 953, 32, 834, 32, 776, 834, 951, 768, 
    837, 951, 837, 951, 769, 837, 951, 834, 951, 834, 837, 917, 768, 919, 
    768, 919, 837, 32, 787, 768, 32, 787, 769, 32, 787, 834, 953, 774, 
    953, 772, 953, 776, 768, 953, 834, 953, 776, 834, 921, 774, 921, 772, 
    921, 768, 32, 788, 768, 32, 788, 769, 32, 788, 834, 965, 774, 965, 
    772, 965, 776, 768, 961, 787, 961, 788, 965, 834, 965, 776, 834, 933, 
    774, 933, 772, 933, 768, 929, 788, 32, 776, 768, 96, 969, 768, 837, 
    969, 837, 969, 769, 837, 969, 834, 969, 834, 837, 927, 768, 937, 768, 
    937, 837, 32, 788, 8208, 32, 819, 46, 46, 46, 46, 46, 46, 8242, 8242, 
    8242, 8242, 8242, 8245, 8245, 8245, 8245, 8245, 33, 33, 32, 773, 63, 
    63, 63, 33, 33, 63, 8242, 8242, 8242, 8242, 48, 52, 53, 54, 55, 56, 
    57, 43, 8722, 61, 40, 41, 110, 82, 115, 97, 47, 99, 97, 47, 115, 67, 
    176, 67, 99, 47, 111, 99, 47, 117, 400, 176, 70, 295, 78, 111, 81, 
    83, 77, 84, 69, 76, 84, 77, 90, 937, 70, 1488, 1489, 1490, 1491, 70, 
    65, 88, 915, 928, 8721, 49, 8260, 51, 50, 8260, 51, 49, 8260, 53, 50, 
    8260, 53, 51, 8260, 53, 52, 8260, 53, 49, 8260, 54, 53, 8260, 54, 49, 
    8260, 56, 51, 8260, 56, 53, 8260, 56, 55, 8260, 56, 49, 8260, 73, 73, 
    73, 73, 73, 73, 86, 86, 86, 73, 86, 73, 73, 86, 73, 73, 73, 73, 88, 
    88, 88, 73, 88, 73, 73, 105, 105, 105, 105, 105, 105, 118, 118, 105, 
    118, 105, 105, 118, 105, 105, 105, 105, 120, 120, 105, 120, 105, 105, 
    99, 8592, 824, 8594, 824, 8596, 824, 8656, 824, 8660, 824, 8658, 824, 
    8707, 824, 8712, 824, 8715, 824, 8739, 824, 8741, 824, 8747, 8747, 
    8747, 8747, 8747, 8750, 8750, 8750, 8750, 8750, 8764, 824, 8771, 824, 
    8773, 824, 8776, 824, 61, 824, 8801, 824, 8781, 824, 60, 824, 62, 824, 
    8804, 824, 8805, 824, 8818, 824, 8819, 824, 8822, 824, 8823, 824, 8826, 
    824, 8827, 824, 8834, 824, 8835, 824, 8838, 824, 8839, 824, 8866, 824, 
    8872, 824, 8873, 824, 8875, 824, 8828, 824, 8829, 824, 8849, 824, 8850, 
    824, 8882, 824, 8883, 824, 8884, 824, 8885, 824, 12296, 12297, 49, 
    48, 49, 49, 49, 50, 49, 51, 49, 52, 49, 53, 49, 54, 49, 55, 49, 56, 
    49, 57, 50, 48, 40, 49, 41, 40, 50, 41, 40, 51, 41, 40, 52, 41, 40, 
    53, 41, 40, 54, 41, 40, 55, 41, 40, 56, 41, 40, 57, 41, 40, 49, 48, 
    41, 40, 49, 49, 41, 40, 49, 50, 41, 40, 49, 51, 41, 40, 49, 52, 41, 
    40, 49, 53, 41, 40, 49, 54, 41, 40, 49, 55, 41, 40, 49, 56, 41, 40, 
    49, 57, 41, 40, 50, 48, 41, 49, 46, 50, 46, 51, 46, 52, 46, 53, 46, 
    54, 46, 55, 46, 56, 46, 57, 46, 49, 48, 46, 49, 49, 46, 49, 50, 46, 
    49, 51, 46, 49, 52, 46, 49, 53, 46, 49, 54, 46, 49, 55, 46, 49, 56, 
    46, 49, 57, 46, 50, 48, 46, 40, 97, 41, 40, 98, 41, 40, 99, 41, 40, 
    100, 41, 40, 101, 41, 40, 102, 41, 40, 103, 41, 40, 104, 41, 40, 105, 
    41, 40, 106, 41, 40, 107, 41, 40, 108, 41, 40, 109, 41, 40, 110, 41, 
    40, 111, 41, 40, 112, 41, 40, 113, 41, 40, 114, 41, 40, 115, 41, 40, 
    116, 41, 40, 117, 41, 40, 118, 41, 40, 119, 41, 40, 120, 41, 40, 121, 
    41, 40, 122, 41, 83, 89, 102, 113, 122, 8747, 8747, 8747, 8747, 58, 
    58, 61, 61, 61, 61, 61, 61, 10973, 824, 27597, 40863, 19968, 20008, 
    20022, 20031, 20057, 20101, 20108, 20128, 20154, 20799, 20837, 20843, 
    20866, 20886, 20907, 20960, 20981, 20992, 21147, 21241, 21269, 21274, 
    21304, 21313, 21340, 21353, 21378, 21430, 21448, 21475, 22231, 22303, 
    22763, 22786, 22794, 22805, 22823, 22899, 23376, 23424, 23544, 23567, 
    23586, 23608, 23662, 23665, 24027, 24037, 24049, 24062, 24178, 24186, 
    24191, 24308, 24318, 24331, 24339, 24400, 24417, 24435, 24515, 25096, 
    25142, 25163, 25903, 25908, 25991, 26007, 26020, 26041, 26080, 26085, 
    26352, 26376, 26408, 27424, 27490, 27513, 27571, 27595, 27604, 27611, 
    27663, 27668, 27700, 28779, 29226, 29238, 29243, 29247, 29255, 29273, 
    29275, 29356, 29572, 29577, 29916, 29926, 29976, 29983, 29992, 30000, 
    30091, 30098, 30326, 30333, 30382, 30399, 30446, 30683, 30690, 30707, 
    31034, 31160, 31166, 31348, 31435, 31481, 31859, 31992, 32566, 32593, 
    32650, 32701, 32769, 32780, 32786, 32819, 32895, 32905, 33251, 33258, 
    33267, 33276, 33292, 33307, 33311, 33390, 33394, 33400, 34381, 34411, 
    34880, 34892, 34915, 35198, 35211, 35282, 35328, 35895, 35910, 35925, 
    35960, 35997, 36196, 36208, 36275, 36523, 36554, 36763, 36784, 36789, 
    37009, 37193, 37318, 37324, 37329, 38263, 38272, 38428, 38582, 38585, 
    38632, 38737, 38750, 38754, 38761, 38859, 38893, 38899, 38913, 39080, 
    39131, 39135, 39318, 39321, 39340, 39592, 39640, 39647, 39717, 39727, 
    39730, 39740, 39770, 40165, 40565, 40575, 40613, 40635, 40643, 40653, 
    40657, 40697, 40701, 40718, 40723, 40736, 40763, 40778, 40786, 40845, 
    40860, 40864, 12306, 21316, 21317, 12363, 12441, 12365, 12441, 12367, 
    12441, 12369, 12441, 12371, 12441, 12373, 12441, 12375, 12441, 12377, 
    12441, 12379, 12441, 12381, 12441, 12383, 12441, 12385, 12441, 12388, 
    12441, 12390, 12441, 12392, 12441, 12399, 12441, 12399, 12442, 12402, 
    12441, 12402, 12442, 12405, 12441, 12405, 12442, 12408, 12441, 12408, 
    12442, 12411, 12441, 12411, 12442, 12358, 12441, 32, 12441, 32, 12442, 
    12445, 12441, 12424, 12426, 12459, 12441, 12461, 12441, 12463, 12441, 
    12465, 12441, 12467, 12441, 12469, 12441, 12471, 12441, 12473, 12441, 
    12475, 12441, 12477, 12441, 12479, 12441, 12481, 12441, 12484, 12441, 
    12486, 12441, 12488, 12441, 12495, 12441, 12495, 12442, 12498, 12441, 
    12498, 12442, 12501, 12441, 12501, 12442, 12504, 12441, 12504, 12442, 
    12507, 12441, 12507, 12442, 12454, 12441, 12527, 12441, 12528, 12441, 
    12529, 12441, 12530, 12441, 12541, 12441, 12467, 12488, 4352, 4353, 
    4522, 4354, 4524, 4525, 4355, 4356, 4357, 4528, 4529, 4530, 4531, 4532, 
    4533, 4378, 4358, 4359, 4360, 4385, 4361, 4362, 4363, 4364, 4365, 4366, 
    4367, 4368, 4369, 4370, 4449, 4450, 4451, 4452, 4453, 4454, 4455, 4456, 
    4457, 4458, 4459, 4460, 4461, 4462, 4463, 4464, 4465, 4466, 4467, 4468, 
    4469, 4448, 4372, 4373, 4551, 4552, 4556, 4558, 4563, 4567, 4569, 4380, 
    4573, 4575, 4381, 4382, 4384, 4386, 4387, 4391, 4393, 4395, 4396, 4397, 
    4398, 4399, 4402, 4406, 4416, 4423, 4428, 4593, 4594, 4439, 4440, 4441, 
    4484, 4485, 4488, 4497, 4498, 4500, 4510, 4513, 19977, 22235, 19978, 
    20013, 19979, 30002, 19993, 19969, 22825, 22320, 40, 4352, 41, 40, 
    4354, 41, 40, 4355, 41, 40, 4357, 41, 40, 4358, 41, 40, 4359, 41, 40, 
    4361, 41, 40, 4363, 41, 40, 4364, 41, 40, 4366, 41, 40, 4367, 41, 40, 
    4368, 41, 40, 4369, 41, 40, 4370, 41, 40, 4352, 4449, 41, 40, 4354, 
    4449, 41, 40, 4355, 4449, 41, 40, 4357, 4449, 41, 40, 4358, 4449, 41, 
    40, 4359, 4449, 41, 40, 4361, 4449, 41, 40, 4363, 4449, 41, 40, 4364, 
    4449, 41, 40, 4366, 4449, 41, 40, 4367, 4449, 41, 40, 4368, 4449, 41, 
    40, 4369, 4449, 41, 40, 4370, 4449, 41, 40, 4364, 4462, 41, 40, 4363, 
    4457, 4364, 4453, 4523, 41, 40, 4363, 4457, 4370, 4462, 41, 40, 19968, 
    41, 40, 20108, 41, 40, 19977, 41, 40, 22235, 41, 40, 20116, 41, 40, 
    20845, 41, 40, 19971, 41, 40, 20843, 41, 40, 20061, 41, 40, 21313, 
    41, 40, 26376, 41, 40, 28779, 41, 40, 27700, 41, 40, 26408, 41, 40, 
    37329, 41, 40, 22303, 41, 40, 26085, 41, 40, 26666, 41, 40, 26377, 
    41, 40, 31038, 41, 40, 21517, 41, 40, 29305, 41, 40, 36001, 41, 40, 
    31069, 41, 40, 21172, 41, 40, 20195, 41, 40, 21628, 41, 40, 23398, 
    41, 40, 30435, 41, 40, 20225, 41, 40, 36039, 41, 40, 21332, 41, 40, 
    31085, 41, 40, 20241, 41, 40, 33258, 41, 40, 33267, 41, 80, 84, 69, 
    50, 49, 50, 50, 50, 51, 50, 52, 50, 53, 50, 54, 50, 55, 50, 56, 50, 
    57, 51, 48, 51, 49, 51, 50, 51, 51, 51, 52, 51, 53, 4352, 4449, 4354, 
    4449, 4355, 4449, 4357, 4449, 4358, 4449, 4359, 4449, 4361, 4449, 4363, 
    4449, 4364, 4449, 4366, 4449, 4367, 4449, 4368, 4449, 4369, 4449, 4370, 
    4449, 4366, 4449, 4535, 4352, 4457, 4364, 4462, 4363, 4468, 20116, 
    20845, 19971, 20061, 26666, 26377, 31038, 21517, 29305, 36001, 31069, 
    21172, 31192, 30007, 36969, 20778, 21360, 27880, 38917, 20241, 20889, 
    27491, 24038, 21491, 21307, 23447, 23398, 30435, 20225, 36039, 21332, 
    22812, 51, 54, 51, 55, 51, 56, 51, 57, 52, 48, 52, 49, 52, 50, 52, 
    51, 52, 52, 52, 53, 52, 54, 52, 55, 52, 56, 52, 57, 53, 48, 49, 26376, 
    50, 26376, 51, 26376, 52, 26376, 53, 26376, 54, 26376, 55, 26376, 56, 
    26376, 57, 26376, 49, 48, 26376, 49, 49, 26376, 49, 50, 26376, 72, 
    103, 101, 114, 103, 101, 86, 76, 84, 68, 12450, 12452, 12454, 12456, 
    12458, 12459, 12461, 12463, 12465, 12467, 12469, 12471, 12473, 12475, 
    12477, 12479, 12481, 12484, 12486, 12488, 12490, 12491, 12492, 12493, 
    12494, 12495, 12498, 12501, 12504, 12507, 12510, 12511, 12512, 12513, 
    12514, 12516, 12518, 12520, 12521, 12522, 12523, 12524, 12525, 12527, 
    12528, 12529, 12530, 12450, 12497, 12540, 12488, 12450, 12523, 12501, 
    12449, 12450, 12531, 12506, 12450, 12450, 12540, 12523, 12452, 12491, 
    12531, 12464, 12452, 12531, 12481, 12454, 12457, 12531, 12456, 12473, 
    12463, 12540, 12489, 12456, 12540, 12459, 12540, 12458, 12531, 12473, 
    12458, 12540, 12512, 12459, 12452, 12522, 12459, 12521, 12483, 12488, 
    12459, 12525, 12522, 12540, 12459, 12441, 12525, 12531, 12459, 12441, 
    12531, 12510, 12461, 12441, 12460, 12461, 12441, 12491, 12540, 12461, 
    12517, 12522, 12540, 12461, 12441, 12523, 12480, 12540, 12461, 12525, 
    12461, 12525, 12464, 12521, 12512, 12461, 12525, 12513, 12540, 12488, 
    12523, 12461, 12525, 12527, 12483, 12488, 12463, 12441, 12521, 12512, 
    12463, 12441, 12521, 12512, 12488, 12531, 12463, 12523, 12476, 12452, 
    12525, 12463, 12525, 12540, 12493, 12465, 12540, 12473, 12467, 12523, 
    12490, 12467, 12540, 12509, 12469, 12452, 12463, 12523, 12469, 12531, 
    12481, 12540, 12512, 12471, 12522, 12531, 12464, 12475, 12531, 12481, 
    12475, 12531, 12488, 12479, 12441, 12540, 12473, 12486, 12441, 12471, 
    12488, 12441, 12523, 12488, 12531, 12490, 12494, 12494, 12483, 12488, 
    12495, 12452, 12484, 12495, 12442, 12540, 12475, 12531, 12488, 12495, 
    12442, 12540, 12484, 12495, 12441, 12540, 12524, 12523, 12498, 12442, 
    12450, 12473, 12488, 12523, 12498, 12442, 12463, 12523, 12498, 12442, 
    12467, 12498, 12441, 12523, 12501, 12449, 12521, 12483, 12489, 12501, 
    12451, 12540, 12488, 12501, 12441, 12483, 12471, 12455, 12523, 12501, 
    12521, 12531, 12504, 12463, 12479, 12540, 12523, 12504, 12442, 12477, 
    12504, 12442, 12491, 12498, 12504, 12523, 12484, 12504, 12442, 12531, 
    12473, 12504, 12442, 12540, 12472, 12504, 12441, 12540, 12479, 12507, 
    12442, 12452, 12531, 12488, 12507, 12441, 12523, 12488, 12507, 12531, 
    12507, 12442, 12531, 12489, 12507, 12540, 12523, 12507, 12540, 12531, 
    12510, 12452, 12463, 12525, 12510, 12452, 12523, 12510, 12483, 12495, 
    12510, 12523, 12463, 12510, 12531, 12471, 12519, 12531, 12511, 12463, 
    12525, 12531, 12511, 12522, 12511, 12522, 12496, 12540, 12523, 12513, 
    12460, 12513, 12460, 12488, 12531, 12513, 12540, 12488, 12523, 12516, 
    12540, 12489, 12516, 12540, 12523, 12518, 12450, 12531, 12522, 12483, 
    12488, 12523, 12522, 12521, 12523, 12500, 12540, 12523, 12540, 12502, 
    12523, 12524, 12512, 12524, 12531, 12488, 12466, 12531, 12527, 12483, 
    12488, 48, 28857, 49, 28857, 50, 28857, 51, 28857, 52, 28857, 53, 28857, 
    54, 28857, 55, 28857, 56, 28857, 57, 28857, 49, 48, 28857, 49, 49, 
    28857, 49, 50, 28857, 49, 51, 28857, 49, 52, 28857, 49, 53, 28857, 
    49, 54, 28857, 49, 55, 28857, 49, 56, 28857, 49, 57, 28857, 50, 48, 
    28857, 50, 49, 28857, 50, 50, 28857, 50, 51, 28857, 50, 52, 28857, 
    104, 80, 97, 100, 97, 65, 85, 98, 97, 114, 111, 86, 112, 99, 100, 109, 
    100, 109, 178, 100, 109, 179, 73, 85, 24179, 25104, 26157, 21644, 22823, 
    27491, 26126, 27835, 26666, 24335, 20250, 31038, 112, 65, 110, 65, 
    956, 65, 109, 65, 107, 65, 75, 66, 77, 66, 71, 66, 99, 97, 108, 107, 
    99, 97, 108, 112, 70, 110, 70, 956, 70, 956, 103, 109, 103, 107, 103, 
    72, 122, 107, 72, 122, 77, 72, 122, 71, 72, 122, 84, 72, 122, 956, 
    8467, 109, 8467, 100, 8467, 107, 8467, 102, 109, 110, 109, 956, 109, 
    109, 109, 99, 109, 107, 109, 109, 109, 178, 99, 109, 178, 109, 178, 
    107, 109, 178, 109, 109, 179, 99, 109, 179, 109, 179, 107, 109, 179, 
    109, 8725, 115, 109, 8725, 115, 178, 80, 97, 107, 80, 97, 77, 80, 97, 
    71, 80, 97, 114, 97, 100, 114, 97, 100, 8725, 115, 114, 97, 100, 8725, 
    115, 178, 112, 115, 110, 115, 956, 115, 109, 115, 112, 86, 110, 86, 
    956, 86, 109, 86, 107, 86, 77, 86, 112, 87, 110, 87, 956, 87, 109, 
    87, 107, 87, 77, 87, 107, 937, 77, 937, 97, 46, 109, 46, 66, 113, 99, 
    99, 99, 100, 67, 8725, 107, 103, 67, 111, 46, 100, 66, 71, 121, 104, 
    97, 72, 80, 105, 110, 75, 75, 75, 77, 107, 116, 108, 109, 108, 110, 
    108, 111, 103, 108, 120, 109, 98, 109, 105, 108, 109, 111, 108, 80, 
    72, 112, 46, 109, 46, 80, 80, 77, 80, 82, 115, 114, 83, 118, 87, 98, 
    86, 8725, 109, 65, 8725, 109, 49, 26085, 50, 26085, 51, 26085, 52, 
    26085, 53, 26085, 54, 26085, 55, 26085, 56, 26085, 57, 26085, 49, 48, 
    26085, 49, 49, 26085, 49, 50, 26085, 49, 51, 26085, 49, 52, 26085, 
    49, 53, 26085, 49, 54, 26085, 49, 55, 26085, 49, 56, 26085, 49, 57, 
    26085, 50, 48, 26085, 50, 49, 26085, 50, 50, 26085, 50, 51, 26085, 
    50, 52, 26085, 50, 53, 26085, 50, 54, 26085, 50, 55, 26085, 50, 56, 
    26085, 50, 57, 26085, 51, 48, 26085, 51, 49, 26085, 103, 97, 108, 35912, 
    26356, 36040, 28369, 20018, 21477, 22865, 21895, 22856, 25078, 30313, 
    32645, 34367, 34746, 35064, 37007, 27138, 27931, 28889, 29662, 33853, 
    37226, 39409, 20098, 21365, 27396, 29211, 34349, 40478, 23888, 28651, 
    34253, 35172, 25289, 33240, 34847, 24266, 26391, 28010, 29436, 37070, 
    20358, 20919, 21214, 25796, 27347, 29200, 30439, 34310, 34396, 36335, 
    38706, 39791, 40442, 30860, 31103, 32160, 33737, 37636, 35542, 22751, 
    24324, 31840, 32894, 29282, 30922, 36034, 38647, 22744, 23650, 27155, 
    28122, 28431, 32047, 32311, 38475, 21202, 32907, 20956, 20940, 31260, 
    32190, 33777, 38517, 35712, 25295, 35582, 20025, 23527, 24594, 29575, 
    30064, 21271, 30971, 20415, 24489, 19981, 27852, 25976, 32034, 21443, 
    22622, 30465, 33865, 35498, 27578, 27784, 25342, 33509, 25504, 30053, 
    20142, 20841, 20937, 26753, 31975, 33391, 35538, 37327, 21237, 21570, 
    24300, 26053, 28670, 31018, 38317, 39530, 40599, 40654, 26310, 27511, 
    36706, 24180, 24976, 25088, 25754, 28451, 29001, 29833, 31178, 32244, 
    32879, 36646, 34030, 36899, 37706, 21015, 21155, 21693, 28872, 35010, 
    24265, 24565, 25467, 27566, 31806, 29557, 20196, 22265, 23994, 24604, 
    29618, 29801, 32666, 32838, 37428, 38646, 38728, 38936, 20363, 31150, 
    37300, 38584, 24801, 20102, 20698, 23534, 23615, 26009, 29134, 30274, 
    34044, 36988, 26248, 38446, 21129, 26491, 26611, 27969, 28316, 29705, 
    30041, 30827, 32016, 39006, 25134, 38520, 20523, 23833, 28138, 36650, 
    24459, 24900, 26647, 38534, 21033, 21519, 23653, 26131, 26446, 26792, 
    27877, 29702, 30178, 32633, 35023, 35041, 38626, 21311, 28346, 21533, 
    29136, 29848, 34298, 38563, 40023, 40607, 26519, 28107, 33256, 31520, 
    31890, 29376, 28825, 35672, 20160, 33590, 21050, 20999, 24230, 25299, 
    31958, 23429, 27934, 26292, 36667, 38477, 24275, 20800, 21952, 22618, 
    26228, 20958, 29482, 30410, 31036, 31070, 31077, 31119, 38742, 31934, 
    34322, 35576, 36920, 37117, 39151, 39164, 39208, 40372, 20398, 20711, 
    20813, 21193, 21220, 21329, 21917, 22022, 22120, 22592, 22696, 23652, 
    24724, 24936, 24974, 25074, 25935, 26082, 26257, 26757, 28023, 28186, 
    28450, 29038, 29227, 29730, 30865, 31049, 31048, 31056, 31062, 31117, 
    31118, 31296, 31361, 31680, 32265, 32321, 32626, 32773, 33261, 33401, 
    33879, 35088, 35222, 35585, 35641, 36051, 36104, 36790, 38627, 38911, 
    38971, 102, 102, 102, 105, 102, 108, 102, 102, 105, 102, 102, 108, 
    115, 116, 1396, 1398, 1396, 1381, 1396, 1387, 1406, 1398, 1396, 1389, 
    1497, 1460, 1522, 1463, 1506, 1492, 1499, 1500, 1501, 1512, 1514, 1513, 
    1473, 1513, 1474, 1513, 1468, 1473, 1513, 1468, 1474, 1488, 1463, 1488, 
    1464, 1488, 1468, 1489, 1468, 1490, 1468, 1491, 1468, 1492, 1468, 1493, 
    1468, 1494, 1468, 1496, 1468, 1497, 1468, 1498, 1468, 1499, 1468, 1500, 
    1468, 1502, 1468, 1504, 1468, 1505, 1468, 1507, 1468, 1508, 1468, 1510, 
    1468, 1511, 1468, 1512, 1468, 1513, 1468, 1514, 1468, 1493, 1465, 1489, 
    1471, 1499, 1471, 1508, 1471, 1488, 1500, 1649, 1659, 1662, 1664, 1658, 
    1663, 1657, 1700, 1702, 1668, 1667, 1670, 1671, 1677, 1676, 1678, 1672, 
    1688, 1681, 1705, 1711, 1715, 1713, 1722, 1723, 1729, 1726, 1746, 1709, 
    1735, 1734, 1736, 1739, 1733, 1737, 1744, 1609, 1610, 1620, 1575, 1610, 
    1620, 1749, 1610, 1620, 1608, 1610, 1620, 1735, 1610, 1620, 1734, 1610, 
    1620, 1736, 1610, 1620, 1744, 1610, 1620, 1609, 1740, 1610, 1620, 1580, 
    1610, 1620, 1581, 1610, 1620, 1605, 1610, 1620, 1610, 1576, 1580, 1576, 
    1581, 1576, 1582, 1576, 1605, 1576, 1609, 1576, 1610, 1578, 1580, 1578, 
    1581, 1578, 1582, 1578, 1605, 1578, 1609, 1578, 1610, 1579, 1580, 1579, 
    1605, 1579, 1609, 1579, 1610, 1580, 1581, 1580, 1605, 1581, 1580, 1581, 
    1605, 1582, 1580, 1582, 1581, 1582, 1605, 1587, 1580, 1587, 1581, 1587, 
    1582, 1587, 1605, 1589, 1581, 1589, 1605, 1590, 1580, 1590, 1581, 1590, 
    1582, 1590, 1605, 1591, 1581, 1591, 1605, 1592, 1605, 1593, 1580, 1593, 
    1605, 1594, 1580, 1594, 1605, 1601, 1580, 1601, 1581, 1601, 1582, 1601, 
    1605, 1601, 1609, 1601, 1610, 1602, 1581, 1602, 1605, 1602, 1609, 1602, 
    1610, 1603, 1575, 1603, 1580, 1603, 1581, 1603, 1582, 1603, 1604, 1603, 
    1605, 1603, 1609, 1603, 1610, 1604, 1580, 1604, 1581, 1604, 1582, 1604, 
    1605, 1604, 1609, 1604, 1610, 1605, 1580, 1605, 1581, 1605, 1582, 1605, 
    1605, 1605, 1609, 1605, 1610, 1606, 1580, 1606, 1581, 1606, 1582, 1606, 
    1605, 1606, 1609, 1606, 1610, 1607, 1580, 1607, 1605, 1607, 1609, 1607, 
    1610, 1610, 1580, 1610, 1581, 1610, 1582, 1610, 1605, 1610, 1609, 1610, 
    1610, 1584, 1648, 1585, 1648, 1609, 1648, 32, 1612, 1617, 32, 1613, 
    1617, 32, 1614, 1617, 32, 1615, 1617, 32, 1616, 1617, 32, 1617, 1648, 
    1610, 1620, 1585, 1610, 1620, 1586, 1610, 1620, 1606, 1576, 1585, 1576, 
    1586, 1576, 1606, 1578, 1585, 1578, 1586, 1578, 1606, 1579, 1585, 1579, 
    1586, 1579, 1606, 1605, 1575, 1606, 1585, 1606, 1586, 1606, 1606, 1610, 
    1585, 1610, 1586, 1610, 1606, 1610, 1620, 1582, 1610, 1620, 1607, 1576, 
    1607, 1578, 1607, 1589, 1582, 1604, 1607, 1606, 1607, 1607, 1648, 1610, 
    1607, 1579, 1607, 1587, 1607, 1588, 1605, 1588, 1607, 1600, 1614, 1617, 
    1600, 1615, 1617, 1600, 1616, 1617, 1591, 1609, 1591, 1610, 1593, 1609, 
    1593, 1610, 1594, 1609, 1594, 1610, 1587, 1609, 1587, 1610, 1588, 1609, 
    1588, 1610, 1581, 1609, 1581, 1610, 1580, 1609, 1580, 1610, 1582, 1609, 
    1582, 1610, 1589, 1609, 1589, 1610, 1590, 1609, 1590, 1610, 1588, 1580, 
    1588, 1581, 1588, 1582, 1588, 1585, 1587, 1585, 1589, 1585, 1590, 1585, 
    1575, 1611, 1578, 1580, 1605, 1578, 1581, 1580, 1578, 1581, 1605, 1578, 
    1582, 1605, 1578, 1605, 1580, 1578, 1605, 1581, 1578, 1605, 1582, 1580, 
    1605, 1581, 1581, 1605, 1610, 1581, 1605, 1609, 1587, 1581, 1580, 1587, 
    1580, 1581, 1587, 1580, 1609, 1587, 1605, 1581, 1587, 1605, 1580, 1587, 
    1605, 1605, 1589, 1581, 1581, 1589, 1605, 1605, 1588, 1581, 1605, 1588, 
    1580, 1610, 1588, 1605, 1582, 1588, 1605, 1605, 1590, 1581, 1609, 1590, 
    1582, 1605, 1591, 1605, 1581, 1591, 1605, 1605, 1591, 1605, 1610, 1593, 
    1580, 1605, 1593, 1605, 1605, 1593, 1605, 1609, 1594, 1605, 1605, 1594, 
    1605, 1610, 1594, 1605, 1609, 1601, 1582, 1605, 1602, 1605, 1581, 1602, 
    1605, 1605, 1604, 1581, 1605, 1604, 1581, 1610, 1604, 1581, 1609, 1604, 
    1580, 1580, 1604, 1582, 1605, 1604, 1605, 1581, 1605, 1581, 1580, 1605, 
    1581, 1605, 1605, 1581, 1610, 1605, 1580, 1581, 1605, 1580, 1605, 1605, 
    1582, 1580, 1605, 1582, 1605, 1605, 1580, 1582, 1607, 1605, 1580, 1607, 
    1605, 1605, 1606, 1581, 1605, 1606, 1581, 1609, 1606, 1580, 1605, 1606, 
    1580, 1609, 1606, 1605, 1610, 1606, 1605, 1609, 1610, 1605, 1605, 1576, 
    1582, 1610, 1578, 1580, 1610, 1578, 1580, 1609, 1578, 1582, 1610, 1578, 
    1582, 1609, 1578, 1605, 1610, 1578, 1605, 1609, 1580, 1605, 1610, 1580, 
    1581, 1609, 1580, 1605, 1609, 1587, 1582, 1609, 1589, 1581, 1610, 1588, 
    1581, 1610, 1590, 1581, 1610, 1604, 1580, 1610, 1604, 1605, 1610, 1610, 
    1581, 1610, 1610, 1580, 1610, 1610, 1605, 1610, 1605, 1605, 1610, 1602, 
    1605, 1610, 1606, 1581, 1610, 1593, 1605, 1610, 1603, 1605, 1610, 1606, 
    1580, 1581, 1605, 1582, 1610, 1604, 1580, 1605, 1603, 1605, 1605, 1580, 
    1581, 1610, 1581, 1580, 1610, 1605, 1580, 1610, 1601, 1605, 1610, 1576, 
    1581, 1610, 1587, 1582, 1610, 1606, 1580, 1610, 1589, 1604, 1746, 1602, 
    1604, 1746, 1575, 1604, 1604, 1607, 1575, 1603, 1576, 1585, 1605, 1581, 
    1605, 1583, 1589, 1604, 1593, 1605, 1585, 1587, 1608, 1604, 1593, 1604, 
    1610, 1607, 1608, 1587, 1604, 1605, 1589, 1604, 1609, 1589, 1604, 1609, 
    32, 1575, 1604, 1604, 1607, 32, 1593, 1604, 1610, 1607, 32, 1608, 1587, 
    1604, 1605, 1580, 1604, 32, 1580, 1604, 1575, 1604, 1607, 1585, 1740, 
    1575, 1604, 8212, 8211, 95, 123, 125, 12308, 12309, 12304, 12305, 12298, 
    12299, 12300, 12301, 12302, 12303, 91, 93, 44, 12289, 58, 63, 33, 35, 
    38, 42, 45, 60, 62, 92, 36, 37, 64, 32, 1611, 1600, 1611, 32, 1612, 
    32, 1613, 32, 1614, 1600, 1614, 32, 1615, 1600, 1615, 32, 1616, 1600, 
    1616, 32, 1617, 1600, 1617, 32, 1618, 1600, 1618, 1569, 1575, 1576, 
    1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 
    1589, 1590, 1591, 1592, 1593, 1594, 1601, 1602, 1603, 1604, 1605, 1606, 
    1607, 1608, 1610, 1604, 1570, 1604, 1571, 1604, 1573, 1604, 1575, 34, 
    39, 47, 94, 124, 126, 10629, 10630, 12290, 12539, 12449, 12451, 12453, 
    12455, 12457, 12515, 12517, 12519, 12483, 12540, 12531, 12441, 12442, 
    162, 163, 172, 166, 165, 8361, 9474, 8592, 8593, 8594, 8595, 9632, 
    9675
};


/*
 * This macro extracts the information about a character from the
 * Unicode character tables.
 */

#define GetUniCharDecompInfo(ch) (decompGroupMap[(decompPageMap[(((int)(ch)) & 0xffff) >> DECOMP_OFFSET_BITS] << DECOMP_OFFSET_BITS) | ((ch) & ((1 << DECOMP_OFFSET_BITS)-1))])

#define GetDecompShift(info) ((info) & 0xffff)
#define GetDecompLen(info) ((info) >> 16)


#define COMP_OFFSET_BITS 5

/*
 * The pageMap is indexed by page number and returns an alternate page number
 * that identifies a unique page of characters.  Many Unicode characters map
 * to the same alternate page number.
 */

static unsigned char compPageMap[] = {
    0, 1, 2, 3, 0, 4, 5, 6, 7, 0, 8, 9, 0, 10, 0, 11, 0, 12, 0, 0, 13, 
    0, 0, 0, 14, 15, 16, 0, 17, 18, 19, 0, 20, 21, 22, 23, 0, 0, 24, 25, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 27, 0, 0, 0, 28, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 0, 0, 30, 31, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 32, 33, 0, 34, 35, 36, 0, 0, 0, 37, 0, 0, 38, 39, 0, 
    0, 40, 41, 0, 0, 0, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 44, 45, 46, 0, 47, 48, 0, 49, 50, 51, 52, 0, 53, 54, 55, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 0, 57, 0, 58, 59, 60, 61, 62, 63, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65, 66, 67, 68, 69, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    
};

/*
 * The groupMap is indexed by combining the alternate page number with
 * the page offset and returns a group number that identifies a unique
 * set of character attributes.
 */

static int compGroupMap[] = {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 65564, 65640, 65738, -1, -1, 30, 
    91, 141, 65, 121, 65701, 38, 94, 1, 65604, 124, 44, 100, 12, 76, 77, 
    -1, 48, 105, 17, 84, 136, 54, 113, 23, 24, -1, -1, -1, -1, -1, -1, 
    140, 64, 120, 71, 123, 65573, 99, 10, 75, 129, 47, 104, 16, 15, 83, 
    135, -1, 110, 22, 86, 137, 59, 117, 118, 28, 89, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 102, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    6, -1, 65713, 65575, 101, 65550, -1, -1, 42, -1, -1, -1, -1, 65576, 
    -1, -1, -1, -1, 130, 50, 65678, -1, 65628, -1, -1, -1, 115, -1, -1, 
    -1, -1, -1, 32, -1, 65742, 65600, 67, 65704, -1, -1, 5, -1, -1, -1, 
    -1, 65549, -1, -1, -1, -1, 107, 20, 65626, -1, 65587, -1, -1, -1, 87, 
    -1, -1, -1, -1, -1, 142, 66, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 106, 18, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 37, 93, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65624, 65722, -1, -1, -1, -1, 
    65632, 65730, -1, -1, -1, -1, -1, -1, 65597, 65699, 65567, 65649, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 65728, 81, 131, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 119, 33, -1, -1, -1, -1, -1, -1, 65546, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65593, 65696, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 65675, 65554, 65625, 65724, -1, -1, -1, 
    -1, 65731, 65590, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 65729, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 1, 2, 3, 5, 7, -1, 8, 10, 11, 12, 26, 30, 13, -1, -1, 14, -1, 
    15, -1, 4, 6, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, 
    16, 32, 29, 25, 20, 17, -1, -1, -1, -1, 22, 21, -1, 18, 23, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 19, -1, -1, 
    0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 34, -1, -1, -1, 122, -1, 96, 
    -1, 8, -1, -1, -1, -1, -1, 80, -1, 65586, -1, -1, -1, 85, -1, -1, -1, 
    26, -1, -1, 65539, -1, 65707, -1, -1, 2, -1, -1, -1, 95, -1, 7, -1, 
    125, -1, -1, -1, -1, -1, 51, -1, 111, -1, -1, -1, 56, -1, -1, -1, 0, 
    138, 62, -1, -1, 65664, -1, -1, -1, 39, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65736, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 97, -1, -1, 65714, -1, 103, 14, 65622, 132, 
    -1, 65581, -1, -1, -1, 65727, -1, -1, -1, -1, 139, -1, -1, -1, 65566, 
    -1, -1, -1, 65706, -1, 65663, -1, -1, 72, -1, -1, 65670, -1, 79, 133, 
    65582, 52, -1, 65556, -1, -1, -1, 65687, -1, -1, -1, -1, 63, -1, -1, 
    -1, 65744, -1, -1, -1, 65659, -1, 65595, -1, -1, -1, -1, -1, -1, -1, 
    -1, 65658, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65661, 
    65545, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 65651, 65542, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 65682, 65559, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    143, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65733, 
    -1, 65657, -1, -1, -1, -1, -1, -1, -1, -1, 65546, 36, 65547, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 65618, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65612, -1, -1, 65611, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65734, 
    -1, -1, -1, -1, -1, -1, -1, 65656, -1, -1, 65655, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 65539, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65540, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 65541, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 65542, 65543, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 65577, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, 
    -1, -1, -1, -1, -1, -1, 98, 65584, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 34, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 65578, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65716, -1, -1, 65544, 
    -1, -1, -1, 127, -1, -1, -1, 65630, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 35, 65545, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 24, -1, -1, -1, -1, -1, -1, 
    -1, 19, 65695, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 65538, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 9, -1, -1, -1, -1, 65536, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 3, -1, -1, 65538, -1, -1, 65537, -1, -1, -1, -1, -1, 65616, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65679, 65557, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    65685, 65561, -1, -1, -1, -1, -1, -1, 65743, 65601, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 114, 25, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65673, 65553, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 65540, 65605, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 82, 134, 65591, 65692, 65693, 65565, 65641, 65739, 
    58, 116, 65568, 65652, 65543, 65609, 65610, 65710, 36, 92, -1, -1, 
    -1, -1, -1, -1, 9, 73, -1, -1, -1, -1, -1, -1, 53, 108, 65690, 65563, 
    65639, 65737, 65598, 65700, 27, 88, 65541, 65606, 65607, 65709, 65572, 
    65667, 11, 69, -1, -1, -1, -1, -1, -1, 126, 45, -1, -1, -1, -1, -1, 
    -1, 13, 78, -1, -1, -1, -1, -1, -1, 55, 112, -1, -1, -1, -1, -1, -1, 
    29, 90, -1, -1, -1, -1, -1, -1, -1, 70, -1, -1, -1, -1, -1, -1, 128, 
    46, 65683, 65560, 65635, 65732, 65592, 65694, 109, 21, 65642, 65740, 
    65599, 65702, 65569, 65653, 65544, -1, -1, -1, 65574, -1, -1, -1, -1, 
    -1, -1, -1, 65552, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65537, -1, -1, 
    -1, -1, -1, -1, -1, -1, 40, -1, -1, -1, -1, -1, -1, 65680, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65570, -1, -1, -1, -1, 
    -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 65705, -1, 65660, -1, 65614, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 65698, -1, 65644, -1, 65741, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 65711, -1, -1, -1, -1, 65619, -1, -1, 
    65676, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 65668, -1, 65548, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    65648, -1, -1, -1, -1, -1, -1, 65547, -1, 65715, -1, -1, 65551, -1, 
    -1, -1, -1, 65681, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 65596, -1, -1, 65647, 65536, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 65721, 65583, -1, -1, 65558, 65631, 
    -1, -1, 65688, 65562, 65637, 65735, -1, -1, -1, -1, 65646, 65745, -1, 
    -1, 65571, 65662, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65580, 65579, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65602, 
    -1, -1, -1, -1, -1, 65613, 65712, -1, 65669, -1, -1, -1, -1, -1, -1, 
    65555, 65629, 65725, 65588, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 65718, -1, -1, -1, -1, 65708, -1, 65703, -1, 
    65697, -1, 65686, -1, 65684, -1, 65677, -1, 65671, -1, 65665, -1, 65650, 
    -1, 65645, -1, 65638, -1, 65633, -1, -1, 65623, -1, 65620, -1, 65615, 
    -1, -1, -1, -1, -1, -1, 60, -1, -1, 74, -1, -1, 68, -1, -1, 61, -1, 
    -1, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 27, 28, -1, 
    -1, 65717, -1, -1, -1, -1, -1, -1, -1, -1, 65691, -1, -1, -1, -1, 65674, 
    -1, 65672, -1, 65666, -1, 65654, -1, 65643, -1, 65636, -1, 65634, -1, 
    65627, -1, 65621, -1, 65617, -1, 65608, -1, 65603, -1, -1, 65594, -1, 
    65589, -1, 65585, -1, -1, -1, -1, -1, -1, 41, -1, -1, 31, -1, -1, 49, 
    -1, -1, 43, -1, -1, 35, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 65726, 65723, 65720, 65719, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 65689, -1, -1
};

/*
 * Lists of compositions for characters that appears only in one composition
 */

static int compFirstList[][2] = {
    {824, 8817}, {837, 8119}, {3530, 3549}, {837, 8116}, {770, 7896}, 
    {837, 8090}, {776, 1243}, {837, 8076}, {837, 8114}, {783, 1143}, 
    {780, 494}, {824, 8772}, {824, 8742}, {769, 7727}, {769, 7688}, 
    {824, 8777}, {837, 8178}, {770, 7879}, {772, 481}, {824, 8938}, 
    {769, 1116}, {772, 7737}, {824, 8824}, {776, 1259}, {837, 8099}, 
    {772, 7773}, {824, 8833}, {837, 8083}, {824, 8814}, {837, 8069}, 
    {776, 1268}, {776, 7802}, {837, 8074}, {837, 8110}, {837, 8183}, 
    {824, 8840}, {837, 8094}, {775, 7711}, {837, 8130}, {769, 506}, 
    {769, 7726}, {3031, 2964}, {3158, 3144}, {824, 8931}, {824, 8930}, 
    {769, 1036}, {776, 1247}, {824, 8821}, {3006, 3019}, {12441, 12489}, 
    {788, 8172}, {769, 511}, {824, 8941}, {12441, 12487}, {772, 561}, 
    {837, 8066}, {837, 8102}, {772, 492}, {12441, 12485}, {776, 1261}, 
    {824, 8802}, {769, 7800}, {837, 8086}, {837, 8108}, {769, 507}, 
    {775, 7785}, {824, 8876}, {12441, 12482}, {770, 308}, {770, 7897}, 
    {837, 8091}, {837, 8092}, {12441, 12480}, {837, 8077}, {837, 8078}, 
    {1620, 1728}, {1620, 1747}, {824, 8877}, {824, 8622}, {12441, 12393}, 
    {4142, 4134}, {12441, 12478}, {1620, 1730}, {824, 8713}, 
    {12441, 12391}, {12441, 12476}, {776, 1246}, {12441, 12389}, 
    {775, 7780}, {774, 7708}, {772, 555}, {12441, 12474}, {769, 510}, 
    {824, 8939}, {3285, 3275}, {824, 8825}, {775, 7782}, {12441, 12386}, 
    {12441, 12472}, {837, 8100}, {12441, 12470}, {824, 8928}, 
    {12441, 12384}, {837, 8084}, {824, 8800}, {837, 8070}, {837, 8106}, 
    {12441, 12468}, {824, 8655}, {12441, 12382}, {824, 8836}, 
    {824, 8816}, {824, 8769}, {776, 7803}, {12441, 12380}, {776, 1242}, 
    {837, 8075}, {837, 8111}, {12441, 12466}, {2364, 2356}, {2364, 2353}, 
    {1620, 1574}, {776, 1111}, {776, 1273}, {824, 8603}, {783, 1142}, 
    {824, 8841}, {776, 1260}, {837, 8180}, {12441, 12378}, {12441, 12464}, 
    {837, 8095}, {824, 8740}, {824, 8879}, {769, 1107}, {12441, 12376}, 
    {12441, 12462}, {770, 7878}, {12441, 12460}, {772, 480}, 
    {824, 8716}, {12441, 12374}, {772, 554}, {772, 7736}, {837, 8135}, 
    {824, 8813}, {776, 1258}, {837, 8098}, {12441, 12372}, {772, 7772}, 
    {12441, 12370}, {776, 1255}, {824, 8832}, {12441, 12542}, 
    {837, 8082}, {12441, 12532}, {837, 8067}, {837, 8068}, {837, 8103}, 
    {3390, 3403}, {772, 493}, {12441, 12368}, {824, 8653}, {769, 7801}, 
    {837, 8087}, {775, 7710}, {837, 8109}, {12441, 12366}, {769, 7689}, 
    {824, 8602}, {776, 1272}, {837, 8132}, {12441, 12364}, {837, 8093}, 
    {837, 8079}, {824, 8708}, {824, 8878}, {772, 478}, {769, 1027}, 
    {824, 8775}, {3285, 3264}, {12441, 12446}, {12441, 12436}, 
    {12441, 12538}, {12441, 12537}, {824, 8820}, {775, 7781}, 
    {12441, 12536}, {774, 7709}, {824, 8940}, {12441, 12535}, 
    {776, 1254}, {775, 7835}, {780, 495}, {775, 7783}, {772, 560}, 
    {837, 8101}, {1620, 1572}, {2364, 2345}, {824, 8929}, {776, 1031}, 
    {837, 8085}, {824, 8815}, {837, 8071}, {837, 8107}, {824, 8654}, 
    {772, 479}, {775, 7784}, {776, 1269}, {824, 8837}
};

static int compSecondList[][2] = {
    {3545, 3548}, {3545, 3550}, {3398, 3404}, {2503, 2507}, {2503, 2508}, 
    {2887, 2891}, {2887, 2888}, {2887, 2892}, {3270, 3274}, {3270, 3272}, 
    {1575, 1570}, {1575, 1573}
};

/*
 * Compositions matrix
 */

static int compBothList[144][37] = {
    {
        8179, 8060, 974, 0, 8032, 0, 8033, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 8182, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 204, 205, 206, 0, 296, 0, 298, 300, 0, 304, 207, 7880, 463, 
        520, 522, 7882, 302, 7724, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0
    },
    {
        8115, 8048, 940, 0, 7936, 0, 7937, 8113, 8112, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 8118, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 3546, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8157, 8158, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        8159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7873, 7871, 0, 0, 7877, 0, 0, 0, 0, 0, 0, 7875, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7846, 7844, 0, 0, 7850, 0, 0, 0, 0, 0, 0, 7848, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8131, 8052, 942, 0, 7968, 0, 7969, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 8134, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8154, 906, 0, 7992, 0, 7993, 8153, 8152, 0, 0, 938, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0
    },
    {
        0, 7962, 7964, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 293, 0, 0, 0, 0, 0, 0, 7715, 7719, 0, 543, 0, 0, 7717, 
        0, 0, 0, 7721, 7723, 0, 7830, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0
    },
    {
        0, 7986, 7988, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        7990, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 504, 323, 0, 0, 209, 0, 0, 0, 0, 7748, 0, 0, 327, 0, 0, 7750, 
        0, 0, 0, 325, 0, 7754, 7752, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0
    },
    {
        0, 8002, 8004, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 1217, 0, 0, 1244, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 505, 324, 0, 0, 241, 0, 0, 0, 0, 7749, 0, 0, 328, 0, 0, 7751, 
        0, 0, 0, 326, 0, 7755, 7753, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0
    },
    {
        0, 0, 7743, 0, 0, 0, 0, 0, 0, 0, 7745, 0, 0, 0, 0, 0, 7747, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7786, 0, 0, 356, 0, 0, 7788, 0, 0, 
        0, 354, 0, 7792, 7790, 0, 538, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7701, 7703, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 3402, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 7757, 0, 0, 0, 0, 557, 0, 0, 0, 7759, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8105, 8043, 8045, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 8047, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 347, 349, 0, 0, 0, 0, 0, 0, 7777, 0, 0, 353, 0, 0, 7779, 
        0, 0, 0, 351, 0, 0, 0, 0, 537, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7922, 221, 374, 0, 7928, 0, 562, 0, 0, 7822, 376, 7926, 0, 0, 
        0, 7924, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0
    },
    {
        0, 0, 377, 7824, 0, 0, 0, 0, 0, 0, 379, 0, 0, 381, 0, 0, 7826, 
        0, 0, 0, 0, 0, 0, 7828, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 7853, 0, 0, 0, 0, 7863, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8188, 8186, 911, 0, 8040, 0, 8041, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8088, 7978, 7980, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 7982, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7923, 253, 375, 0, 7929, 0, 563, 0, 0, 7823, 255, 7927, 0, 0, 
        0, 7925, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7833, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0
    },
    {
        0, 8018, 8020, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        8022, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 192, 193, 194, 0, 195, 0, 256, 258, 0, 550, 196, 7842, 461, 
        512, 514, 7840, 260, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 7680, 0, 
        0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 12499, 12500, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7847, 7845, 0, 0, 7851, 0, 0, 0, 0, 0, 0, 7849, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7915, 7913, 0, 0, 7919, 0, 0, 0, 0, 0, 0, 7917, 0, 0, 0, 7921, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8124, 8122, 902, 0, 7944, 0, 7945, 8121, 8120, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 12508, 12509, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7954, 7956, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7760, 7762, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 500, 284, 0, 0, 0, 7712, 286, 0, 288, 0, 0, 486, 0, 0, 0, 
        0, 0, 0, 290, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 979, 0, 0, 0, 0, 0, 0, 0, 0, 980, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8141, 8142, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        8143, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 12496, 12497, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7872, 7870, 0, 0, 7876, 0, 0, 0, 0, 0, 0, 7874, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 12505, 12506, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 313, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 317, 0, 0, 7734, 0, 0, 
        0, 315, 0, 7740, 7738, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7995, 7997, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        7999, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8097, 8035, 8037, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 8039, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 7729, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 489, 0, 0, 7731, 0, 0, 
        0, 311, 0, 0, 7733, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 340, 0, 0, 0, 0, 0, 0, 0, 7768, 0, 0, 344, 528, 530, 7770, 
        0, 0, 0, 342, 0, 0, 7774, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 12502, 12503, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 7756, 0, 0, 0, 0, 556, 0, 0, 0, 7758, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8056, 972, 0, 8000, 0, 8001, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 1117, 0, 0, 0, 0, 0, 1251, 1081, 0, 0, 1253, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8080, 7970, 7972, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 7974, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7808, 7810, 372, 0, 0, 0, 0, 0, 0, 7814, 7812, 0, 0, 0, 0, 7816, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8010, 8012, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8058, 973, 0, 8016, 0, 8017, 8161, 8160, 0, 0, 971, 0, 0, 0, 
        0, 0, 0, 0, 8166, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 12412, 12413, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8072, 7946, 7948, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 7950, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 7805, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7807, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 12400, 12401, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 12409, 12410, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8162, 944, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8167, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 1263, 1118, 0, 0, 1265, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1267, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7683, 0, 0, 0, 0, 0, 7685, 0, 0, 
        0, 0, 0, 0, 7687, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7690, 0, 0, 270, 0, 0, 7692, 0, 0, 
        0, 7696, 0, 7698, 7694, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7857, 7855, 0, 0, 7861, 0, 0, 0, 0, 0, 0, 7859, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 509, 0, 0, 0, 0, 483, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 12406, 12407, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7987, 7989, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        7991, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8027, 8029, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        8031, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7691, 0, 0, 271, 0, 0, 7693, 0, 0, 
        0, 7697, 0, 7699, 7695, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 1233, 0, 0, 1235, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7963, 7965, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 12403, 12404, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 236, 237, 238, 0, 297, 0, 299, 301, 0, 0, 239, 7881, 464, 521, 
        523, 7883, 303, 7725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0
    },
    {
        0, 210, 211, 212, 0, 213, 0, 332, 334, 0, 558, 214, 7886, 465, 
        524, 526, 7884, 490, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 336, 416, 
        0, 0, 0, 0, 0
    },
    {
        0, 0, 7764, 0, 0, 0, 0, 0, 0, 0, 7766, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8003, 8005, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 1104, 0, 0, 0, 0, 0, 0, 1239, 0, 0, 1105, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8184, 908, 0, 8008, 0, 8009, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7900, 7898, 0, 0, 7904, 0, 0, 0, 0, 0, 0, 7902, 0, 0, 0, 7906, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8064, 7938, 7940, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 7942, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 242, 243, 244, 0, 245, 0, 333, 335, 0, 559, 246, 7887, 466, 
        525, 527, 7885, 491, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 337, 417, 
        0, 0, 0, 0, 0
    },
    {
        0, 217, 218, 219, 0, 360, 0, 362, 364, 0, 0, 220, 7910, 467, 532, 
        534, 7908, 370, 7796, 0, 0, 0, 7798, 0, 0, 0, 366, 0, 0, 0, 368, 
        431, 7794, 0, 0, 0, 0
    },
    {
        0, 8170, 910, 0, 0, 0, 8025, 8169, 8168, 0, 0, 939, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7787, 7831, 0, 357, 0, 0, 7789, 0, 
        0, 0, 355, 0, 7793, 7791, 0, 539, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0
    },
    {
        0, 476, 472, 0, 0, 0, 0, 470, 0, 0, 0, 0, 0, 474, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8089, 7979, 7981, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 7983, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 378, 7825, 0, 0, 0, 0, 0, 0, 380, 0, 0, 382, 0, 0, 7827, 
        0, 0, 0, 0, 0, 0, 7829, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8019, 8021, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        8023, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7682, 0, 0, 0, 0, 0, 7684, 0, 0, 
        0, 0, 0, 0, 7686, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7955, 7957, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7761, 7763, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 292, 0, 0, 0, 0, 0, 0, 7714, 7718, 0, 542, 0, 0, 7716, 
        0, 0, 0, 7720, 7722, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0
    },
    {
        0, 8050, 941, 0, 7952, 0, 7953, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8140, 8138, 905, 0, 7976, 0, 7977, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 1232, 0, 0, 1234, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3018, 3020, 0, 0
    },
    {
        0, 0, 501, 285, 0, 0, 0, 7713, 287, 0, 289, 0, 0, 487, 0, 0, 0, 
        0, 0, 0, 291, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 7742, 0, 0, 0, 0, 0, 0, 0, 7744, 0, 0, 0, 0, 0, 7746, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 508, 0, 0, 0, 0, 482, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8173, 901, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8129, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 1024, 0, 0, 0, 0, 0, 0, 1238, 0, 0, 1025, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 314, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 318, 0, 0, 7735, 0, 0, 
        0, 316, 0, 7741, 7739, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 346, 348, 0, 0, 0, 0, 0, 0, 7776, 0, 0, 352, 0, 0, 7778, 
        0, 0, 0, 350, 0, 0, 0, 0, 536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7700, 7702, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7891, 7889, 0, 0, 7895, 0, 0, 0, 0, 0, 0, 7893, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8081, 7971, 7973, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 7975, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8104, 8042, 8044, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 8046, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 341, 0, 0, 0, 0, 0, 0, 0, 7769, 0, 0, 345, 529, 531, 7771, 
        0, 0, 0, 343, 0, 0, 7775, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        
    },
    {
        0, 0, 0, 0, 8164, 0, 8165, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8011, 8013, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7818, 7820, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 7852, 0, 0, 0, 0, 7862, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 475, 471, 0, 0, 0, 0, 469, 0, 0, 0, 0, 0, 473, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8073, 7947, 7949, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 7951, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7809, 7811, 373, 0, 0, 0, 0, 0, 0, 7815, 7813, 0, 0, 0, 0, 7817, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 7832, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7819, 7821, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7914, 7912, 0, 0, 7918, 0, 0, 0, 0, 0, 0, 7916, 0, 0, 0, 7920, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 263, 265, 0, 0, 0, 0, 0, 0, 267, 0, 0, 269, 0, 0, 0, 0, 0, 
        0, 231, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 200, 201, 202, 0, 7868, 0, 274, 276, 0, 278, 203, 7866, 282, 
        516, 518, 7864, 280, 7706, 0, 552, 0, 7704, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8136, 904, 0, 7960, 0, 7961, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 232, 233, 234, 0, 7869, 0, 275, 277, 0, 279, 235, 7867, 283, 
        517, 519, 7865, 281, 7707, 0, 553, 0, 7705, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 7728, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 488, 0, 0, 7730, 0, 0, 
        0, 310, 0, 0, 7732, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 8054, 943, 0, 7984, 0, 7985, 8145, 8144, 0, 0, 970, 0, 0, 0, 
        0, 0, 0, 0, 8150, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0
    },
    {
        0, 7994, 7996, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        7998, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3271, 0
    },
    {
        8096, 8034, 8036, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 8038, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 309, 0, 0, 0, 0, 0, 0, 0, 0, 0, 496, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7890, 7888, 0, 0, 7894, 0, 0, 0, 0, 0, 0, 7892, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7901, 7899, 0, 0, 7905, 0, 0, 0, 0, 0, 0, 7903, 0, 0, 0, 7907, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 1037, 0, 0, 0, 0, 0, 1250, 1049, 0, 0, 1252, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 1218, 0, 0, 1245, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        8065, 7939, 7941, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 7943, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 7765, 0, 0, 0, 0, 0, 0, 0, 7767, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 7804, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7806, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 249, 250, 251, 0, 361, 0, 363, 365, 0, 0, 252, 7911, 468, 533, 
        535, 7909, 371, 7797, 0, 0, 0, 7799, 0, 0, 0, 367, 0, 0, 0, 369, 
        432, 7795, 0, 0, 0, 0
    },
    {
        0, 8146, 912, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8151, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 1262, 1038, 0, 0, 1264, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1266, 0, 0, 0, 0, 0, 0
    },
    {
        0, 224, 225, 226, 0, 227, 0, 257, 259, 0, 551, 228, 7843, 462, 
        513, 515, 7841, 261, 0, 0, 0, 0, 0, 0, 0, 0, 229, 0, 0, 7681, 0, 
        0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 262, 264, 0, 0, 0, 0, 0, 0, 266, 0, 0, 268, 0, 0, 0, 0, 0, 
        0, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 7856, 7854, 0, 0, 7860, 0, 0, 0, 0, 0, 0, 7858, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    },
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1571
    },
};


#define GetUniCharCompInfo(ch) (compGroupMap[(compPageMap[(((int)(ch)) & 0xffff) >> COMP_OFFSET_BITS] << COMP_OFFSET_BITS) | ((ch) & ((1 << COMP_OFFSET_BITS)-1))])

#define CompSingleMask (1 << 16)
#define CompMask ((1 << 16) - 1)

