/*
 
    Ejecter - Safely, easily remove external peripherals
    Copyright 2008-2009, Federico Pelloni <federico.pelloni@gmail.com>
 
    
    This file is part of Ejecter.
 
    Ejecter is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Ejecter is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Ejecter.  If not, see <http://www.gnu.org/licenses/>.
   
*/ 


using GLib;


namespace Ejecter {

public class About: Gtk.AboutDialog {

    private const string[] author_list = {"Federico Pelloni <federico.pelloni@gmail.com>", null};

    construct {
    
        Gtk.AboutDialogActivateLinkFunc show_url = (dialog, link) => 
                        { 
                            try { 
                                Gtk.show_uri(Gdk.Screen.get_default(), link, Gdk.CURRENT_TIME);
                            } catch (GLib.Error error) {
                                debug("Error: " + error.message);
                            }
                        };
        this.set_url_hook(show_url);
        this.set_email_hook(show_url);
    
        this.program_name = "Ejecter";
        this.version = Config.VERSION;
        this.copyright = "Copyright © 2008-2009 Federico Pelloni";

        this.comments = _("Easily and safely remove external media without losing data.\n\nClick on the eject button next to the device you want to remove to unmount it: when it has become greyed out you can safely plug it out from your computer.");

        this.license = _("Ejecter is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\nEjecter is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with Ejecter. If not, see <http://www.gnu.org/licenses/>.");
        this.wrap_license = true;

        this.website = "http://launchpad.net/ejecter";
        
        this.authors = this.author_list;
        
        this.translator_credits = _("translator-credits");
        
        this.logo = new Gdk.Pixbuf.from_file(Config.PIXMAPS_DIR + "/logo.png");
        
        this.response += (w, response) => { w.hide(); };
        
    
    }
    
    
}

}

