/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.model.impl;

import com.sun.xml.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.bind.v2.model.annotation.Locatable;
import com.sun.xml.bind.v2.model.core.ErrorHandler;
import com.sun.xml.bind.v2.model.core.NonElement;
import com.sun.xml.bind.v2.model.core.PropertyInfo;
import com.sun.xml.bind.v2.model.core.PropertyKind;
import com.sun.xml.bind.v2.model.core.Ref;
import com.sun.xml.bind.v2.model.core.RegistryInfo;
import com.sun.xml.bind.v2.model.core.TypeInfo;
import com.sun.xml.bind.v2.model.core.TypeInfoSet;
import com.sun.xml.bind.v2.model.impl.ArrayInfoImpl;
import com.sun.xml.bind.v2.model.impl.BuiltinLeafInfoImpl;
import com.sun.xml.bind.v2.model.impl.ClassInfoImpl;
import com.sun.xml.bind.v2.model.impl.ElementInfoImpl;
import com.sun.xml.bind.v2.model.impl.EnumLeafInfoImpl;
import com.sun.xml.bind.v2.model.impl.Messages;
import com.sun.xml.bind.v2.model.impl.RegistryInfoImpl;
import com.sun.xml.bind.v2.model.impl.TypeInfoSetImpl;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.bind.v2.runtime.IllegalAnnotationException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBuilder<T, C, F, M> {
    final TypeInfoSetImpl<T, C, F, M> typeInfoSet;
    public final AnnotationReader<T, C, F, M> reader;
    public final Navigator<T, C, F, M> nav;
    private final Map<QName, TypeInfo> typeNames = new HashMap<QName, TypeInfo>();
    public final String defaultNsUri;
    final Map<String, RegistryInfoImpl> registries = new HashMap<String, RegistryInfoImpl>();
    private ErrorHandler errorHandler;
    private boolean hadError;
    private final ErrorHandler proxyErrorHandler = new ErrorHandler(){

        public void error(IllegalAnnotationException e) {
            ModelBuilder.this.reportError(e);
        }
    };
    private boolean linked;

    public ModelBuilder(AnnotationReader<T, C, F, M> reader, Navigator<T, C, F, M> navigator, String defaultNamespaceRemap) {
        this.reader = reader;
        this.nav = navigator;
        if (defaultNamespaceRemap == null) {
            defaultNamespaceRemap = "";
        }
        this.defaultNsUri = defaultNamespaceRemap;
        reader.setErrorHandler(this.proxyErrorHandler);
        this.typeInfoSet = this.createTypeInfoSet();
    }

    protected TypeInfoSetImpl<T, C, F, M> createTypeInfoSet() {
        return new TypeInfoSetImpl<T, C, F, M>(this.nav, this.reader, BuiltinLeafInfoImpl.createLeaves(this.nav));
    }

    public NonElement<T, C> getClassInfo(C clazz, Locatable upstream) {
        assert (clazz != null);
        NonElement<T, C> r = this.typeInfoSet.getClassInfo(clazz);
        if (r != null) {
            return r;
        }
        if (this.nav.isEnum(clazz)) {
            EnumLeafInfoImpl<T, C, F, M> li = this.createEnumLeafInfo(clazz, upstream);
            this.typeInfoSet.add(li);
            r = li;
        } else {
            ClassInfoImpl<T, C, F, M> ci = this.createClassInfo(clazz, upstream);
            this.typeInfoSet.add(ci);
            for (PropertyInfo<T, C> p : ci.getProperties()) {
                C c;
                String pkg;
                if (p.kind() == PropertyKind.REFERENCE && !this.registries.containsKey(pkg = this.nav.getPackageName(ci.getClazz())) && (c = this.nav.findClass(pkg + ".ObjectFactory", ci.getClazz())) != null) {
                    this.addRegistry(c, (Locatable)((Object)p));
                }
                for (TypeInfo<T, C> t : p.ref()) {
                }
            }
            ci.getBaseClass();
            r = ci;
        }
        this.addTypeName(r);
        return r;
    }

    private void addTypeName(NonElement<T, C> r) {
        QName t = r.getTypeName();
        if (t == null) {
            return;
        }
        TypeInfo old = this.typeNames.put(t, r);
        if (old != null) {
            this.reportError(new IllegalAnnotationException(Messages.CONFLICTING_XML_TYPE_MAPPING.format(r.getTypeName()), old, r));
        }
    }

    public NonElement<T, C> getTypeInfo(T t, Locatable upstream) {
        NonElement<T, C> r = this.typeInfoSet.getTypeInfo(t);
        if (r != null) {
            return r;
        }
        if (this.nav.isArray(t)) {
            ArrayInfoImpl<T, C, F, M> ai = this.createArrayInfo(upstream, t);
            this.addTypeName(ai);
            this.typeInfoSet.add(ai);
            return ai;
        }
        C c = this.nav.asDecl(t);
        assert (c != null) : t.toString() + " must be a leaf, but we failed to recognize it.";
        return this.getClassInfo(c, upstream);
    }

    public NonElement<T, C> getTypeInfo(Ref<T, C> ref) {
        assert (!ref.valueList);
        C c = this.nav.asDecl(ref.type);
        if (c != null && this.reader.getClassAnnotation(XmlRegistry.class, c, null) != null) {
            if (!this.registries.containsKey(this.nav.getPackageName(c))) {
                this.addRegistry(c, null);
            }
            return null;
        }
        return this.getTypeInfo(ref.type, null);
    }

    protected EnumLeafInfoImpl<T, C, F, M> createEnumLeafInfo(C clazz, Locatable upstream) {
        return new EnumLeafInfoImpl(this, upstream, clazz, this.nav.use(clazz));
    }

    protected ClassInfoImpl<T, C, F, M> createClassInfo(C clazz, Locatable upstream) {
        return new ClassInfoImpl(this, upstream, clazz);
    }

    protected ElementInfoImpl<T, C, F, M> createElementInfo(RegistryInfoImpl<T, C, F, M> registryInfo, M m) throws IllegalAnnotationException {
        return new ElementInfoImpl<T, C, F, M>(this, registryInfo, m);
    }

    protected ArrayInfoImpl<T, C, F, M> createArrayInfo(Locatable upstream, T arrayType) {
        return new ArrayInfoImpl(this, upstream, arrayType);
    }

    public RegistryInfo<T, C> addRegistry(C registryClass, Locatable upstream) {
        RegistryInfoImpl r = new RegistryInfoImpl(this, upstream, registryClass);
        return r;
    }

    public RegistryInfo<T, C> getRegistry(String packageName) {
        return this.registries.get(packageName);
    }

    public TypeInfoSet<T, C, F, M> link() {
        assert (!this.linked);
        this.linked = true;
        for (ElementInfoImpl<T, C, F, M> elementInfoImpl : this.typeInfoSet.getAllElements()) {
            elementInfoImpl.link();
        }
        for (ClassInfoImpl classInfoImpl : this.typeInfoSet.beans().values()) {
            classInfoImpl.link();
        }
        for (EnumLeafInfoImpl enumLeafInfoImpl : this.typeInfoSet.enums().values()) {
            enumLeafInfoImpl.link();
        }
        if (this.hadError) {
            return null;
        }
        return this.typeInfoSet;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public final void reportError(IllegalAnnotationException e) {
        this.hadError = true;
        if (this.errorHandler != null) {
            this.errorHandler.error(e);
        }
    }
}

