/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.elasticloadbalancing.processors.service;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.MapConfig;
import amazon.fws.clicommando.config.MapKeyConfig;
import amazon.fws.clicommando.config.MapTransConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.ServiceErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.service.AwsScaffoldCallProcessor;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import amazon.fws.clicommando.processors.service.ServiceCaller;
import amazon.fws.clicommando.processors.service.ServiceScaffold;
import amazon.fws.clicommando.processors.service.aws.AwsQueryCaller;
import amazon.fws.clicommando.processors.service.aws.AwsServiceCaller;
import amazon.fws.clicommando.security.SecurityKeys;
import amazon.fws.clicommando.util.AwsConventionsHelper;
import amazon.fws.clicommando.util.StringUtils;
import amazon.fws.clicommando.util.XmlUtils;
import com.amazon.webservices.dns.v20110505.ChangeAction;
import com.amazon.webservices.dns.v20110505.RRType;
import com.amazonaws.elasticloadbalancing.processors.service.ServiceCallConfigUtil;
import com.amazonaws.elasticloadbalancing.processors.service.route53.Route53ServiceCaller;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Route53ScaffoldCallProcessor
extends AwsScaffoldCallProcessor
implements ServiceScaffold {
    private static final String LOAD_BALANCER_NAME_PARAM = "LoadBalancerName";
    private static final String LOAD_BALANCER_NAMES_PARAM = "LoadBalancerNames";
    private static final String WEIGHT_PARAM = "Weight";
    private static final String RESOURCE_RECORD_TYPE_PARAM = "ResourceRecordType";

    public void processParameterMap(Command command) {
        String userAgent;
        CommandConfig commandConfig = command.getCurrentCommandConfig();
        this.awsCallConfig.setServiceUrl(this.setupUrl(this.awsCallConfig.getServiceUrl(), commandConfig));
        String sslEncryptFlag = command.getCurrentCommandConfig().getParameter("SSLEncryptionOnly").getValue();
        if (StringUtils.notEmpty((String)sslEncryptFlag)) {
            this.awsCallConfig.setSslEncryptionOnly(Boolean.parseBoolean(sslEncryptFlag));
        } else {
            this.awsCallConfig.setSslEncryptionOnly(false);
        }
        int timeoutSec = Integer.parseInt(commandConfig.getParameter("ConnectionTimeout").getValue());
        this.awsCallConfig.setTimeout(timeoutSec);
        if (command.getVersion() == null) {
            userAgent = "Amazon CLI";
        } else {
            int loc;
            String version = command.getVersion().toString();
            if (version.charAt(0) == 'A' && (loc = (version = version.trim()).indexOf("Amazon")) == 0) {
                version = version.substring("Amazon".length()).trim();
            }
            userAgent = "Amazon CLI/" + version;
        }
        this.awsCallConfig.setUserAgent(userAgent);
        this.awsCallConfig.setParameters(this.buildParamMap(command));
        this.validateInput(command);
        Document responseDoc = this.callDescribeLoadBalancers(command);
        String dnsName = this.getTextContent(responseDoc, "DNSName");
        String hostedZoneNameId = this.getTextContent(responseDoc, "CanonicalHostedZoneNameID");
        this.makeRoute53ServiceCall(command, dnsName, hostedZoneNameId);
    }

    private Document callDescribeLoadBalancers(Command command) {
        ServiceCallConfig elbDescribeCallConfig = this.createElbDescribeCallConfig(this.awsCallConfig);
        AwsServiceCaller elbDescribeCaller = this.createAwsServiceCaller(command, elbDescribeCallConfig);
        super.callService((ServiceCaller)elbDescribeCaller, command);
        String responseString = command.getCurrentCommandConfig().getResponse();
        Document responseDoc = XmlUtils.getResultDom((String)responseString);
        return responseDoc;
    }

    private String getTextContent(Document responseDoc, String tagName) {
        Node node = responseDoc.getElementsByTagName(tagName).item(0);
        if (node == null) {
            throw new ServiceErrorException("N/A", new String[]{tagName + " is not found in DescribeLoadBalancers' response", "N/A"});
        }
        return node.getTextContent();
    }

    private AwsServiceCaller createAwsServiceCaller(Command command, ServiceCallConfig awsCallConfig) {
        if (!command.getCurrentCommandConfig().isCredentialsConfigured()) {
            throw new BadInputException(ErrorMessages.ErrorCode.NO_CREDENTIALS_PROVIDED, new String[0]);
        }
        if (((SecurityKeys)command.getCurrentCommandConfig().getSecurityKeys().get(0)).getKeyType() == SecurityKeys.KeyType.CERT_PRIVATE_KEY) {
            throw new BadInputException(ErrorMessages.ErrorCode.UNSUPPORTED_AUTHENTICATION, new String[]{"X.509/RSA-PrivateKey", "AWS credentials"});
        }
        return new AwsQueryCaller(awsCallConfig);
    }

    private ServiceCallConfig createElbDescribeCallConfig(ServiceCallConfig callConfig) {
        ServiceCallConfig result = ServiceCallConfigUtil.shallowCopy(callConfig);
        String lbName = (String)callConfig.getParameters().get(LOAD_BALANCER_NAME_PARAM);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("LoadBalancerNames.member.1", lbName);
        result.setParameters(params);
        return result;
    }

    private void validateInput(Command command) {
        String rrTypeInput = command.getCurrentCommandConfig().getParameter(RESOURCE_RECORD_TYPE_PARAM).getValue();
        String weightInput = command.getCurrentCommandConfig().getParameter(WEIGHT_PARAM).getValue();
        if (rrTypeInput != null && !rrTypeInput.equals("")) {
            try {
                RRType.valueOf(rrTypeInput.toUpperCase());
            }
            catch (Exception e) {
                throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_ARGUMENT_VALUE, new String[]{RESOURCE_RECORD_TYPE_PARAM, rrTypeInput});
            }
        }
        try {
            Long.parseLong(weightInput);
        }
        catch (Exception ex) {
            throw new BadInputException(ErrorMessages.ErrorCode.NOT_NUMBER, new String[]{weightInput});
        }
    }

    private void makeRoute53ServiceCall(Command command, String elbDomainName, String elbHostedZoneId) {
        ChangeAction action = this.getChangeAction();
        Route53ServiceCaller route53Caller = new Route53ServiceCaller(elbDomainName, elbHostedZoneId, action);
        super.callService((ServiceCaller)route53Caller, command);
    }

    protected abstract ChangeAction getChangeAction();

    private Map<String, String> buildParamMap(Command command) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (ParamConfig param : command.getCurrentCommandConfig().getNonDirectiveParameters()) {
            if (StringUtils.notEmpty((String)param.getValue())) {
                ret.put(param.getName(), param.getValue());
                continue;
            }
            if (!param.getValues().isEmpty()) {
                int ordinal = 1;
                for (String value : param.getValues()) {
                    String key = param.getMapConfig().getMapTrans(MapTransConfig.MapType.KEY) == null ? param.getName() + ".member." + ordinal : this.mapTrans(param, MapTransConfig.MapType.KEY, ordinal, null, null);
                    ret.put(key, value);
                    ++ordinal;
                }
                continue;
            }
            if (param.getType().equals((Object)ParamConfig.Type.MULTIPLE) && param.isSpecified().booleanValue() && param.getValues().isEmpty()) {
                ret.put(param.getName(), "");
                continue;
            }
            if (param.getValuesMap().isEmpty()) continue;
            int count = 0;
            int mapCount = 0;
            int mapOrdinalStart = param.getMapConfig().getOrdinalStart();
            List valuesMaps = param.getValuesMap();
            for (Map valuesMap : valuesMaps) {
                count = 0;
                for (Map.Entry entry : valuesMap.entrySet()) {
                    String inputKey = this.tranKey(param.getMapConfig(), (String)entry.getKey());
                    int mapNum = mapOrdinalStart + mapCount;
                    String key = this.mapTrans(param, MapTransConfig.MapType.KEY, mapNum, count, inputKey, (String)entry.getValue());
                    String value = this.mapTrans(param, MapTransConfig.MapType.VALUE, mapNum, count, inputKey, (String)entry.getValue());
                    MapTransConfig mtc = param.getMapConfig().getMapTrans(MapTransConfig.MapType.KEY_VALUE);
                    if (mtc != null) {
                        key = key == null ? inputKey : key;
                        value = value == null ? (String)entry.getValue() : value;
                        String keyValue = this.mapTrans(param, MapTransConfig.MapType.KEY_VALUE, mapNum, count, key, value);
                        ret.put(keyValue, value);
                    } else {
                        ret.put(key, inputKey);
                        ret.put(value, (String)entry.getValue());
                    }
                    ++count;
                }
                ++mapCount;
            }
        }
        return ret;
    }

    private String tranKey(MapConfig mapConfig, String key) {
        MapKeyConfig mapKey = mapConfig.getKey(key);
        return mapKey == null ? key : mapKey.getTranslation();
    }

    private String mapTrans(ParamConfig param, MapTransConfig.MapType type, Integer mapId, Integer index, String key, String value) {
        if (param.getMapConfig().getMapTrans(type) == null) {
            return null;
        }
        String ret = "";
        MapTransConfig mtc = param.getMapConfig().getMapTrans(type);
        Integer position = index + mtc.getOrdinalStart();
        ret = mtc.getTranslation();
        ret = ret.replaceAll("\\{paramname\\}", param.getName());
        ret = ret.replaceAll("\\{ordinal\\}", position.toString());
        ret = ret.replaceAll("\\{key\\}", key);
        ret = ret.replaceAll("\\{value\\}", value);
        ret = ret.replaceAll("\\{map-ordinal\\}", mapId.toString());
        return ret;
    }

    private String mapTrans(ParamConfig param, MapTransConfig.MapType type, Integer index, String key, String value) {
        return this.mapTrans(param, type, 0, index, key, value);
    }

    private String setupUrl(String url, CommandConfig commandConfig) {
        String newUrl = url;
        if (newUrl != null) {
            String region = null;
            if (commandConfig.doesParameterExist("Region")) {
                region = commandConfig.getParameter("Region").getValue();
            }
            newUrl = AwsConventionsHelper.setUrlRegion((String)newUrl, region);
        }
        return newUrl;
    }
}

