/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content.x509;

import java.security.cert.X509Certificate;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509DataContent;
import org.apache.xml.security.utils.RFC2253Parser;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509SubjectName
extends SignatureElementProxy
implements XMLX509DataContent {
    public XMLX509SubjectName(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public XMLX509SubjectName(Document document, String string) {
        super(document);
        this.addText(string);
    }

    public XMLX509SubjectName(Document document, X509Certificate x509Certificate) {
        this(document, RFC2253Parser.normalize(x509Certificate.getSubjectDN().getName()));
    }

    public String getSubjectName() {
        return RFC2253Parser.normalize(this.getTextFromTextChild());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().getName().equals(object.getClass().getName())) {
            return false;
        }
        XMLX509SubjectName xMLX509SubjectName = (XMLX509SubjectName)object;
        String string = xMLX509SubjectName.getSubjectName();
        String string2 = this.getSubjectName();
        return string2.equals(string);
    }

    public int hashCode() {
        return 52;
    }

    public String getBaseLocalName() {
        return "X509SubjectName";
    }
}

