#!/bin/sh
# $Id: all_dvi.sh,v 2.4 2002/05/08 15:00:56 waite Exp $
# Copyright 1991, The Regents of the University of Colorado

# This file is part of the Eli translator construction system.

# Eli is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.

# Eli is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

# You should have received a copy of the GNU General Public License along
# with Eli; see the file COPYING.  If not, write to the Free Software
# Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

# EXEC (all_dvi.sh) (.)
#     (:level_0_specs :extract=:tnf :map=:index_entries :ls)
#   NEEDS
#     (:level_0_specs :extract=:tnf :map=:index_entries)
#   => (:index_dvi);

PKG=$1;shift; ODIN_e186=$1;shift;

# Build the index.fns file from the individual sets of index_entries
# This might die with 'command line too long' if we have too many docs

touch tmp
if [ -s "$ODIN_e186" ]
then
	cat `cat "$ODIN_e186"` > tmp
fi
$ODINCACHE/PKGS/info/texinfo/texindex.exe tmp
mv tmps index.fns

# Create the index.tnf file from which the index will be made

echo "\input $ODINCACHE/PKGS/info/texinfo   @c -*-texinfo-*-" > index.tnf
cat <<END >> index.tnf 
@comment Copyright, 1989, The Regents of the University of Colorado
@comment %**start of header
@setfilename gindex
@settitle Global Index
@setchapternewpage odd
@comment %**end of header

@unnumbered Global Index
@printindex fn
@bye
END

# Create the formatted index

tex index.tnf > tex.out
if test ! -f index.dvi; then
  if test ! -f index.tnf.dvi; then
    #error during tex
    mv tex.out ERRORS
  else
    cat index.tnf.dvi > index_dvi
  fi
else
  cat index.dvi > index_dvi
fi
