/* $Id: VoidChk.c,v 1.6 1997/07/18 11:09:24 uwe Exp $ */
/* Copyright, 1994, AG-Kastens, University Of Paderborn */

#include "VoidChk.h"
#include "envmod.h"
#include "err.h"
#include "Consts.h"
#include "csm.h"

#include "LIGA.h"
#include "LIGAMacros.h"
#include "lookup_idl.h"
#include "liga_func.h"
#include "ligaconsts.h"
#include "args.h"
#include "msgtxt.h"
#include "Syntax.h"

static POSITION pos;

int *MapDidToIsVoid; /* array allocated dynamically */

void InitMapDidToIsVoid (maxdid) int maxdid;
{
MapDidToIsVoid = (int*) malloc ((maxdid+1) * sizeof (int));
if (!MapDidToIsVoid) {
	pos.line = 1;
	pos.col = 1;
	message (DEADLY,MSGTXT( "InitMapDidToIsVoid: no space",
                                (help)system), 0, &pos);
}
}/* InitMapDidToIsVoid */

#define	NoExprAddr	((Expr*)0)
#define ExprAddr(l)	(&((l)->value))

static
void PostProcessHEAD (rulekey) DefTableKey rulekey;
/* post process HEAD in rules with empty rhs */
{ SEQExpr exprs; Expr expr;

    /* consider each kept HEAD.chaindid: */
    foreachinSEQExpr
      (GetemptyHEADs (rulekey, nullSEQExpr()), exprs, expr)
    { Chainacc chn = ExprToChainacc (expr);
      int chaindid = chainidOfChainacc (chn);
      int newattrdid = symbnoOfChainacc (chn);
      int line = rowOfChainacc (chn);
      int col = colOfChainacc (chn);
      SEQAttrrule ars; Attrrule ar; int foundchnst = 0;

      /* search for a kept CHAINSTART: */
      foreachinSEQAttrrule
        (GetChainStarts (rulekey, nullSEQAttrrule()), ars, ar)
      { ChainStart cst = AttrruleToChainStart (ar);
	if (chainidOfChainStart (cst) == chaindid)
	   { foundchnst = 1; break; }
      }
      if (!foundchnst)
      { Expr lhs, rhs; Call ca; Attrrule comp;
        SEQAttrrule atrules;
        /* create computation
	    Chainacc(0, chaindid) = Attracc(0, new attr)
	*/
	lhs = ChainaccToExpr (MkChainacc (0, chaindid, line, col));
	rhs = AttraccToExpr (MkAttracc (0, newattrdid, line, col));
	ca = MkCall
	       (ASSIGNFCT,
	        AppFrontSEQExpr (lhs, creatSEQExpr (rhs)),
                line, col);
        comp = CallToAttrrule (ca);

        atrules = GetAttrib (rulekey, nullSEQAttrrule());
	atrules = AppFrontSEQAttrrule (comp, atrules);
        ResetAttrib (rulekey, atrules);
      }
    }
}/* PostProcessHEAD */

static DefTableKey globalrulekey; /* the current rule */

static
Expr TAILSubstitution (tailexpr) Expr tailexpr;
/* return an expression that substitutes TAIL.chndid
   in the context of the rule globalrulekey
   which has an empty rhs
*/
{ SEQExpr exprs; Expr expr;
  Chainacc tailacc = ExprToChainacc (tailexpr);
  int chaindid = chainidOfChainacc (tailacc);

/* search for a kept HEAD.chaindid: */
  foreachinSEQExpr
    (GetemptyHEADs (globalrulekey, nullSEQExpr()), exprs, expr)
  { Chainacc chn = ExprToChainacc (expr);
    if (chaindid == chainidOfChainacc (chn))
    { int newattrdid = symbnoOfChainacc (chn);
      /* replace TAIL by access to generated attribute: */
      return 
        AttraccToExpr
	  (MkAttracc
	     (0, newattrdid,
	      rowOfChainacc (tailacc), colOfChainacc (tailacc)));
    }
  }
  /* there is no HEAD computation;
     substitute TAIL by lhs.chaindid: */
  symbnoOfChainacc (tailacc) = 0;
  return tailexpr;
}/* TAILSubstitution */

static
void ChkConstit (ex, voidcontext, expraddr)
	Expr ex; /* Constit or call of WITHFCT or SHIELDFCT */
	bool voidcontext;
	Expr *expraddr;	/* address where to insert a call of VOIDFCT
			   if remote attr is in voidcontext */
{ bool haswith = false;
  char *zerofct;
  Constit con;
  Symbattr cattr; 
  
  if (typeof(ex) == KCall)
  {  Call ca = ExprToCall (ex);
     if (strcmp (WITHFCT, nameOfCall (ca)) == 0)
     { Expr zeroName;
       haswith = true;
       ithinSEQExpr (paramsOfCall (ca), 1, ex);
       ithinSEQExpr (paramsOfCall (ca), 5, zeroName);
       zerofct = nOfName (ExprToName (zeroName));
     }
  }
	
  if (typeof(ex) == KCall)
  {  Call ca = ExprToCall (ex);
     if (strcmp (SHIELDFCT, nameOfCall (ca)) == 0)
        ithinSEQExpr (paramsOfCall (ca), 1, ex);
  }

  /* now ex must be a Constit: */
  if (typeof(ex) != KConstit)
      message (DEADLY, 
	       MSGTXT("system error wrong CONSTITUENT(S) structure",
	       (lidoref)CONSTITUENT(S)), 
               0, 0);

  con = ExprToConstit (ex);
  if (voidcontext)
  {
    if (emptySEQSymbattr (constattrsOfConstit (con)))
    /* replace the whole structure by an irrelevant expression: */
      *expraddr =
         ValToExpr
	   (MkVal (0, rowOfConstit (con), colOfConstit (con)));
    else
    /* embed the whole structure in a VOIDFCT call: */
      *expraddr =
         CallToExpr
	   (MkCall
	      (VOIDFCT,
	       creatSEQExpr (*expraddr),
	       rowOfConstit (con),
	       colOfConstit (con)));

    if (haswith && ! singleOfConstit (con))
    { pos.line = rowOfConstit (con);
      pos.col = colOfConstit (con);
      message (WARNING,MSGTXT( "WITH clause not needed",
				(lidoref)CONSTITUENT(S)),
	       0, &pos);
    }
    return;
  }

  /* non-void context: */
  if (!haswith && !singleOfConstit (con))
  {   pos.line = rowOfConstit (con);
      pos.col = colOfConstit (con);
      message (ERROR, MSGTXT("WITH clause needed",
			     (lidoref)CONSTITUENT(S)),
	       0, &pos);
  }

  if (emptySEQSymbattr (constattrsOfConstit (con)))
  { if (singleOfConstit (con))
    { pos.line = rowOfConstit (con);
      pos.col = colOfConstit (con);
      message (ERROR, MSGTXT("CONSTITUENT yields empty remote list",
			     (lidoref)CONSTITUENT(S)),
	       0, &pos);
      return;
    }
    /* replace the whole structure by a zero funct call: */
    *expraddr =
       CallToExpr
         (MkCall
	    (zerofct,
	     (SEQExpr)0,
	     rowOfConstit (con),
	     colOfConstit (con)));
  }
  else
  { retrievefirstSEQSymbattr (constattrsOfConstit (con), cattr);
    if (IsVoidDid (attrdefOfSymbattr (cattr)))
    { pos.line = rowOfConstit (con);
      pos.col = colOfConstit (con);
      message (ERROR, MSGTXT( "VOID attribute not allowed here",
			      (lidoref)Types and Classes of Attributes),
	       0, &pos);
    }
  }
}/* ChkConstit */

static void ChkCall ();

static void ChkExpr (ex, voidcontext, expraddr)
	Expr ex; bool voidcontext;
	Expr *expraddr;	/* address where to insert a call of VOIDFCT
			   if remote attr is in voidcontext */
{
  switch (typeof(ex))
  {
    case KName:
    { Name na;
      na = ExprToName (ex);
      if (strcmp ("RULENAME", nOfName (na)) == 0)
      /* substitute by particular rule name: */
      { Literal lit; Expr ex;
        lit = MkLiteral (StringTable (GetIdent (globalrulekey, 0)));
	ex = LiteralToExpr (lit);
        *expraddr = 
	   CallToExpr
	       (MkCall
                (STRINGFCT,
		 creatSEQExpr (ex),
		 rowOfName (na), colOfName (na)));
      }
    }
    break;

    case KCall:
    { Call ca;
      ca = ExprToCall (ex);
      ChkCall (ca, voidcontext, expraddr);
    }
    break;

    case KAttracc:
    { Attracc	attr;
      if (voidcontext) return;
      attr = ExprToAttracc (ex);
      if (IsVoidDid (attridOfAttracc (attr)))
      { pos.line = rowOfAttracc (attr);
	pos.col = colOfAttracc (attr);
	message (ERROR,MSGTXT ("VOID attribute not allowed here",
			       (lidoref)Types and Classes of Attributes),
		 0, &pos);
      }
    }
    break;

    case KChainacc:
    { Chainacc chn;
      chn = ExprToChainacc (ex);

      if (symbnoOfChainacc (chn) == TAILCode)
      /* TAIL access of symbol computation is to be substituted: */
         *expraddr = TAILSubstitution (ex);

      if (voidcontext) return;
      if (IsVoidDid (chainidOfChainacc (chn)))
      { pos.line = rowOfChainacc (chn);
	pos.col = colOfChainacc (chn);
	message (ERROR, MSGTXT ("VOID attribute not allowed here",
				(lidoref)Types and Classes of Attributes),
		 0, &pos);
      }
    }
    break;

    case KConstit:
      ChkConstit (ex, voidcontext, expraddr);
      break;

    case KIncluding:
    { Symbattr cattr; Including incl;
      incl = ExprToIncluding (ex);
      if (voidcontext)
      {
	*expraddr =
	   CallToExpr
	     (MkCall
	         (VOIDFCT,
		  creatSEQExpr (ex),
		  rowOfIncluding (incl),
		  colOfIncluding (incl)));
	return;
      }

      if (! emptySEQSymbattr (inclattrsOfIncluding (incl)))
      {
	retrievefirstSEQSymbattr
	  (inclattrsOfIncluding (incl), cattr);
	if (IsVoidDid (attrdefOfSymbattr (cattr)))
	{ pos.line = rowOfIncluding (incl);
	  pos.col = colOfIncluding (incl);
	  message (ERROR, MSGTXT ("VOID attribute not allowed here",
				  (lidoref)Types and Classes of Attributes),
				  0, &pos);
	}
      }
    }
    break;

  default:;
  }/* switch */
}/* ChkExpr */

static void ChkCall (ca, voidcontext, expraddr) 
	Call ca; int voidcontext;
	Expr *expraddr;	/* address where to insert a call of VOIDFCT
			   if remote attr is in voidcontext */
{	SEQExpr	params;
params = paramsOfCall (ca);
if (strcmp (ASSIGNFCT, nameOfCall (ca)) == 0) {
	Expr	lex, rex, mark; SEQExpr marks;
	Attracc	attr;

	if (emptySEQExpr (params)) return;
	retrievefirstSEQExpr (params, lex);
	params = tailSEQExpr (params);
	if (emptySEQExpr (params)) return;
	retrievefirstSEQExpr (params, rex);
	
	marks = tailSEQExpr (params);
	while (! emptySEQExpr (marks))
	{ retrievefirstSEQExpr (marks, mark);
	  if (typeof (mark) == KName &&
	      strcmp (MULTMARK, nOfName(ExprToName(mark))) == 0)
	     return;
	  marks = tailSEQExpr (marks);
	}

	if (typeof (lex) == KAttracc) {
		attr = ExprToAttracc (lex);
		ChkExpr (rex, IsVoidDid (attridOfAttracc (attr)), 
			 ExprAddr(params));
	} else if (typeof (lex) == KChainacc) {
        	Chainacc chn; 
	        chn = ExprToChainacc (lex);
                ChkExpr (rex, IsVoidDid (chainidOfChainacc (chn)),
                         ExprAddr(params));
        }
} else
if (strcmp (DEPFCT, nameOfCall (ca)) == 0) {
	Expr	param;
	if (emptySEQExpr (params)) return;
	retrievefirstSEQExpr (params, param);
	ChkExpr (param, voidcontext, ExprAddr(params));
	params = tailSEQExpr (params);
	while (! emptySEQExpr (params)) {
		retrievefirstSEQExpr (params, param);
		ChkExpr (param, true, ExprAddr(params));
		params = tailSEQExpr (params);
	}
} else
if (strcmp (ORDERFCT, nameOfCall (ca)) == 0) {
	Expr	param;
	if (emptySEQExpr (params)) return;
	while (! emptySEQExpr (tailSEQExpr (params))) {
		retrievefirstSEQExpr (params, param);
		ChkExpr (param, true, ExprAddr(params));
		params = tailSEQExpr (params);
	}
	retrievefirstSEQExpr (params, param);
	ChkExpr (param, voidcontext, ExprAddr(params));
} else
if (strcmp (IFFCT, nameOfCall (ca)) == 0) {
	Expr	param;
	if (emptySEQExpr (params) || emptySEQExpr (tailSEQExpr (params))) {
		pos.line = rowOfCall (ca);
		pos.col = colOfCall (ca);
		message (ERROR,MSGTXT( "Less than 2 arguments for IF",
				      (lidoref)Predefined Entities), 0, &pos);
		return;
	}
	retrievefirstSEQExpr (params, param);
	ChkExpr (param, false, ExprAddr(params));
	params = tailSEQExpr (params);
	retrievefirstSEQExpr (params, param);
	ChkExpr (param, voidcontext, ExprAddr(params));
	params = tailSEQExpr (params);
	if (emptySEQExpr (params)) {
		if (!voidcontext) {
			pos.line = rowOfCall (ca);
			pos.col = colOfCall (ca);
			message (ERROR, 
			MSGTXT(	"Else part of IF required in value context",
			       (lidoref)Predefined Entities),
				0, &pos);
		}
		return;
	}
	retrievefirstSEQExpr (params, param);
	ChkExpr (param, voidcontext, ExprAddr(params));
	params = tailSEQExpr (params);
	if (!emptySEQExpr (params)) {
		pos.line = rowOfCall (ca);
		pos.col = colOfCall (ca);
		message (ERROR,MSGTXT( "More than 3 arguments for IF",
				      (lidoref)Predefined Entities), 0, &pos);
	}
} else
if (strcmp (VOIDFCT, nameOfCall (ca)) == 0) {
	Expr	param;
	if (emptySEQExpr (params)) return;
	retrievefirstSEQExpr (params, param);
	ChkExpr (param, true, ExprAddr(params));
} else
if (strcmp (IDFCT, nameOfCall (ca)) == 0) {
	Expr	param;
	if (emptySEQExpr (params)) return;
	retrievefirstSEQExpr (params, param);	
	ChkExpr (param, voidcontext, ExprAddr(params));
} else
if (strcmp (WITHFCT, nameOfCall (ca)) == 0) {
	if (emptySEQExpr (params)) return;
	ChkConstit (CallToExpr (ca), voidcontext, expraddr);
} else
if (strcmp (SHIELDFCT, nameOfCall (ca)) == 0) {
	if (emptySEQExpr (params)) return;
	ChkConstit (CallToExpr (ca), voidcontext, expraddr);
} else
if (strcmp (STRINGFCT, nameOfCall (ca)) == 0) {
} else
if (strcmp (LOOPFCT, nameOfCall (ca)) == 0) {
	Expr	param;
	if (!voidcontext)  {
		pos.line = rowOfCall (ca);
		pos.col = colOfCall (ca);
		message (ERROR,MSGTXT( "Iteration does not yield a value",
				      (lidoref)Iterations), 0, &pos);
	}
	if (emptySEQExpr (params)) return;
	retrievefirstSEQExpr (params, param);	
	ChkExpr (param, false, ExprAddr(params));
	params = tailSEQExpr (params);
	if (emptySEQExpr (params)) return;
	retrievefirstSEQExpr (params, param);	
	if (typeof (param) == KAttracc) {
		Attracc	attr;
		attr = ExprToAttracc (param);
		params = tailSEQExpr (params);
		if (emptySEQExpr (params)) return;
		retrievefirstSEQExpr (params, param);
		ChkExpr (param, IsVoidDid (attridOfAttracc (attr)), 
			 ExprAddr(params));
	}
} else
if (strcmp (INITCYCLEFCT, nameOfCall (ca)) == 0) {
	Expr	param;
	if (emptySEQExpr (params)) return;
	retrievefirstSEQExpr (params, param);	
	ChkExpr (param, voidcontext, ExprAddr(params));
} else
if (strcmp (CHARFCT, nameOfCall (ca)) == 0) {
} else
if (strcmp (FLOATFCT, nameOfCall (ca)) == 0) {
} else
if (strcmp ("$$", nameOfCall (ca)) == 0) {
   /* represents a list of arguments created by RHS that should
      have been linked into the enclosing argument list;
      but there is no such enclosing list. That error is reported
      in ChkPragma.
      The arguments can't be anything else than attributes.
      Hence, nothing is to be checked here.
   */
} else
if (strcmp (BOTTOMUPFCT, nameOfCall (ca)) == 0) {
	Expr	param;
	if (emptySEQExpr (params)) return;
	retrievefirstSEQExpr (params, param);	
	ChkExpr (param, voidcontext, ExprAddr(params));
}
else { /* call of any other function: */
	Expr	param;
	while (!emptySEQExpr (params)) {
		retrievefirstSEQExpr (params, param);	
		ChkExpr (param, false, ExprAddr(params));
		params = tailSEQExpr (params);
	}
}
}/* ChkCall */

static
void MakeProdAttrAssigns (rulekey) DefTableKey rulekey;
/* Precondition: 
 * All rule attributes are defined and associated to the
 * lefthand side symbol of rulekey. 
 * Postcondition: 
 * A dummy Attrrule is added to the
 * attribution of rulekey for each rule attribute of its lhs
 * which does not belong to this rule, 
 * i.e. marked by prodid of this rule 
*/
{
   TList ruleprod; ProdElem lhselem;
   SEQAttrrule rulecomps;
   DefTableKey symkey;
   int prodid;
   Environment env; Scope attrs;

   rulecomps = GetAttrib (rulekey, nullSEQAttrrule());
   prodid = GetDid (rulekey, DIDNON);

   ruleprod = GetRuleProd (rulekey, NullList);
   lhselem = (ProdElem) HeadList (ruleprod);
   symkey = lhselem->Key;
   env = GetAttrScope (symkey, NoEnv);
   attrs = DefinitionsOf (env);
   while (attrs != NoScope)
   {  DefTableKey atkey = KeyOf(attrs);
      int attrprod = GetAttrProdDid (atkey, DIDNON);
      if ((attrprod != DIDNON) && (attrprod != prodid))
      {  Expr ex1, ex2, ex3;
         Attrrule ar;
         int did = GetDid (atkey, DIDNON);

	 ex1 = AttraccToExpr (MkAttracc (0, did, 0, 0));
	 ex2 = ValToExpr (MkVal (0, 0, 0));
	 ex3 = NameToExpr (MkName (TNVOID, 0, 0));
	 ar = CallToAttrrule
                (MkCall
                  (ASSIGNFCT,
                   AppFrontSEQExpr
                     (ex1, AppFrontSEQExpr(ex2, creatSEQExpr(ex3))),
                 0, 0));
         rulecomps = AppFrontSEQAttrrule (ar, rulecomps);
      }
      attrs = NextDefinition(attrs);
   }
   ResetAttrib(rulekey, rulecomps);
}/* MakeProdAttrAssigns */

void PostProcComps (rulekey) DefTableKey rulekey;
/* Performs postprocessing of the computations of rulekey.
   Called by MakeAttributions immediately before output.

   Computations are checked for consistent use of VOID attributes.
   TAIL.c in rules with empty rhs are substituted.
   A computation is added for HEAD.c in rules with empty rhs.
   Dummy computations are created for rule attributes.
*/
{ SEQAttrrule cmps; Attrrule cmp;

  /* Computations are checked for consistent use of VOID attributes: */
  globalrulekey = rulekey; /* used in TAILSubstitution */
  foreachinSEQAttrrule 
    (GetAttrib (rulekey, nullSEQAttrrule()), cmps, cmp)
  if (typeof (cmp) == KCall)
  { Call ca = AttrruleToCall (cmp);
    ChkCall (ca, true, NoExprAddr);
  }

  PostProcessHEAD (rulekey);
  MakeProdAttrAssigns (rulekey);
}/* PostProcComps */
