
#ifndef _ProdElemLIST_H
#define _ProdElemLIST_H

/* include header file defining ProdElem if Syntax is set: */
#define EMPTYSyntaxHDR
#ifndef EMPTYHDR
#include "Syntax.h"
#endif
#undef EMPTYSyntaxHDR

#include "ProdElemFunctionTypes.h"

typedef struct _ProdElemLE *ProdElemList;
typedef ProdElemList    *ProdElemListPtr;

struct _ProdElemLE {
ProdElem                head;
ProdElemList    tail;
};

#define NULLProdElemList                ((ProdElemList)0)
#define NullProdElemList()      ((ProdElemList)0)
#define SingleProdElemList(e)   (ConsProdElemList((e),NULLProdElemList))

#if defined(__STDC__) || defined(__cplusplus)

extern void FinlProdElemList(void);
   /* Deallocates all ProdElemLists. */
   /* Dynamic storage is allocated on first need */

extern ProdElemList ConsProdElemList (ProdElem e, ProdElemList l);
   /* Constructs a ProdElemList of an element e and a given tail l.
    * e is the first element of the list. */

extern ProdElem HeadProdElemList (ProdElemList l);
   /* Returns the first element of the list l.
    * The list l must not be empty. */

extern ProdElemList TailProdElemList (ProdElemList l);
   /* Returns the tail of the list l.
    * If l is empty, an empty list is returned. */

extern int LengthProdElemList (ProdElemList l);
   /* Returns the number of elements in the list l. */

extern ProdElem IthElemProdElemList (ProdElemList l, int i);
   /* Returns the i-th element of the List l. The head of l
    * is referred to as 1. If the value of
    * i is greater than the length of the list, an error
    * is reported and the program exits.
    */

extern ProdElemList CopyProdElemList (ProdElemList l, ProdElemMapFct cp);
   /* Copies the list l. Elements are copied by calls of cp. */

extern ProdElemList AppProdElemList (ProdElemList l1, ProdElemList l2);
   /* Concatenates two lists l1 and l2. The resulting list contains l2 at
    * the end of a copy of list l1. */

extern ProdElemList AppElProdElemList (ProdElemList l, ProdElem e);
   /* Appends an element e to the list l.
    * The list l is not copied, it is modified as a side-effect
    * of this function. */

extern void InsertAfterProdElemList (ProdElemList l, ProdElem e);
   /* This function requires a non-empty list l. The element e is inserted
    * just after the first element of l. 
    * The list l is modified as a side-effect of this function. */

extern ProdElemList OrderedInsertProdElemList (ProdElemList l, ProdElem e, ProdElemCmpFctType fcmp);
   /* Inserts the element e into the list l maintaining l in
    * ascending order with respect to the compare fcmp. 
    * The list l is modified as a side-effect of this function. */

extern ProdElemListPtr RefEndConsProdElemList (ProdElemListPtr addr, ProdElem e);
   /* Appends an element e to the end of a list given by its address addr.
    * The address where the next element may be appended is returned.
    * The list is modified as a side-effect of this function. */

extern ProdElemListPtr RefEndAppProdElemList (ProdElemListPtr addr, ProdElemList l);
   /* Appends a list l to the end of a list given by its address addr.
    * The address where the next element may be appended is returned.
    * The list is modified as a side-effect of this function. */

extern int ElemInProdElemList (ProdElem e, ProdElemList l, ProdElemCmpFctType cmpfct);
   /* This function returns true (1) iff the element e is in the List l.
    * List elements are compared by the function cmpfct. */

extern ProdElemList AddToSetProdElemList (ProdElem e, ProdElemList l, ProdElemCmpFctType cmpfct);
   /* A list is returned that has e as an element.
    * l is checked whether it already contains e using the compare
    * function cmpfct. */

extern ProdElemList AddToOrderedSetProdElemList 
       (ProdElem e, ProdElemList l, ProdElemCmpFctType cmpfct);
   /* A list is returned that has e as an element.
    * l is checked whether it already contains e using the compare
    * function cmpfct. l is assumed to be ordered increasingly in the sense of
    * cmpfct. */

extern ProdElemList MapProdElemList (ProdElemList l, ProdElemMapFct f);
   /* Returns a new ProdElemList obtained by applying f to each element of l. */

extern int CompProdElemList (ProdElemList l1, ProdElemList l2, ProdElemCmpFctType f);
   /* Compares the lists l1 and l2 lexicographically by applying f
    * to the corresponding elements. */

extern ProdElem SumProdElemList (ProdElemList l, ProdElemSumFct f, ProdElem a);
   /* Applies the binary function f to the elements of the List:
    *   f( f(... f(a, e1), e2, ...), en)
    * If l is empty a is returned. */

#else

extern void FinlProdElemList ();
extern ProdElemList ConsProdElemList ();
extern ProdElem HeadProdElemList ();
extern ProdElemList TailProdElemList ();
extern int LengthProdElemList ();
extern ProdElem IthElemProdElemList ();
extern ProdElemList CopyProdElemList ();
extern ProdElemList AppProdElemList ();
extern ProdElemList AppElProdElemList ();
extern void InsertAfterProdElemList ();
extern ProdElemList OrderedInsertProdElemList ();
extern ProdElemListPtr RefEndConsProdElemList ();
extern ProdElemListPtr RefEndAppProdElemList ();
extern int ElemInProdElemList ();
extern ProdElemList AddToSetProdElemList ();
extern ProdElemList MapProdElemList ();
extern int CompProdElemList ();
extern ProdElem SumProdElemList ();

#endif

#ifdef MONITOR
#define DAPTO_RESULTProdElemList(l) DAPTO_RESULT_PTR(l)
#define DAPTO_ARGProdElemList(l)    DAPTO_ARG_PTR (l, ProdElemList)
#endif

#endif
