# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Authors: Guillaume Emont <guillaume@fluendo.com>

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-dvd',
    version='0.0.1', 
    description='DVD plugin',
    license='GPL3', 
    author='Guillaume Emont',
    author_email='guillaume@fluendo.com',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.mo', '*.po', '*.conf'],
                  'elisa.plugins.dvd.i18n': ['*/LC_MESSAGES/*.po', '*.pot'],
                 },
    cmdclass=cmdclass,
    controller_mappings=[('/poblesec/video/dvd',
                          'elisa.plugins.dvd.dvdcontroller:DvdController'),
                         ('/poblesec/dvd_player',
                          'elisa.plugins.dvd.dvdcontroller:DvdPlayerController')],
    decorator_mappings=[('/poblesec/video_menu',
                         'elisa.plugins.dvd.dvdcontroller:section_decorator')]
    )
