# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'

from elisa.core.components.action import Action
from elisa.core.epm import egg_registry

from twisted.internet import defer

class ElisaUpgradeAction(Action):

    def __init__(self):
        Action.__init__(self)
        self._registry = egg_registry.EggRegistry()
            
    def __call__(self, controller, origin):
        dfr = self._registry.upgrade(update_states=['important'])
        return dfr
