# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.graph.text import Text
from elisa.plugins.pigment.graph.image import Image

from elisa.plugins.poblesec.widgets.loadable_mixin import LoadableMixin
from elisa.plugins.poblesec.widgets.button import IconButton

import pgm
import gobject


# we must inherit from LoadableMixin first because of
# http://bugzilla.gnome.org/show_bug.cgi?id=554443
class MenuItemWidget(LoadableMixin, Widget):

    loading_attribute = 'icon'

    def __init__(self):
        super(MenuItemWidget, self).__init__()
        self._create_widgets()
        self.update_style_properties(self.style.get_items())

    def _create_widgets(self):
        self.label = Text()
        self.add(self.label)

        self.icon = Image()
        self.add(self.icon)

        # background drawable taking the full size of the widget; used to
        # catch mouse events
        self.background = Image()
        self.add(self.background)

        self.label.visible = True
        self.icon.visible = True
        self.background.visible = True

    def clean(self):
        self.label.clean()
        self.label = None
        self.icon.clean()
        self.icon = None
        self.background.clean()
        self.background = None

        return super(MenuItemWidget, self).clean()
        

class MenuItemWidgetWithAction(MenuItemWidget):

    __gsignals__ = {
        'action': (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,)),
        }

    def _create_widgets(self):
        super(MenuItemWidgetWithAction, self)._create_widgets()

        self.action_button = IconButton()
        self.action_button.text.weight = pgm.TEXT_WEIGHT_BOLD
        self.action_button.connect('clicked', self._action_clicked)
        self.add(self.action_button, forward_signals=False)
        self.action_button.visible = True

    def _action_clicked(self, *args):
        self.emit('action', None)
        return True

    def clean(self):
        self.action_button.clean()
        self.action_button = None

        return super(MenuItemWidgetWithAction, self).clean()


class DoubleLineMenuItemWidget(MenuItemWidget):

    def _create_widgets(self):
        super(DoubleLineMenuItemWidget, self)._create_widgets()
        sublabel = Text()
        self.sublabel = sublabel
        self.add(sublabel)
        sublabel.weight = pgm.TEXT_WEIGHT_NORMAL
        sublabel.ellipsize = pgm.TEXT_ELLIPSIZE_MIDDLE
        sublabel.bg_a = 0
        sublabel.fg_color = (195, 194, 194, 255)
        sublabel.visible = True

    def clean(self):
        self.sublabel.clean()
        self.sublabel = None

        return super(DoubleLineMenuItemWidget, self).clean()
