# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2007-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

from elisa.core import media_uri
from elisa.plugins.themoviedb.constants import *

def get_movie_lookup_url(search_term):
    """
    A little helper giving the API url call to use to search for a movie
    on themoviedb.org.

    @returns: the search URL that can be used in a get() call of the
              resource_provider.
    @rtype:   L{elisa.core.media_uri.MediaUri}
    """
    quoted_term = media_uri.quote(search_term)
    url = "http://%s/2.0/Movie.search?title=%s&api_key=%s" % (API_SERVER,
                                                              quoted_term,
                                                              API_KEY)
    return media_uri.MediaUri(url)

