# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, build_po


packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)


setup(name='elisa-plugin-flickr',
    version='0.1',
    description='Flickr photo sharing',
    long_description='Browse and view your pictures on Flickr.',
    license='GPLv3',
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    install_requires=['elisa-plugin-poblesec'],
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.conf', 'icons/*'],
                  'elisa.plugins.flickr.i18n': ['*/LC_MESSAGES/*.po', '*.pot'],
                  },
    entry_points="""\
    [elisa.core.components.resource_provider]
    FlickrResourceProvider = elisa.plugins.flickr.resource_provider:FlickrResourceProvider

    [elisa.core.plugin_registry]
    use = elisa.plugins.flickr.controller:use_me_hook
    """,
    controller_mappings=[('/poblesec/settings/flickr/username',
                          'elisa.plugins.poblesec.login_settings_controller:UsernameSettingsController'),
                         ('/poblesec/settings/flickr/password',
                          'elisa.plugins.poblesec.login_settings_controller:PasswordSettingsController'),
                         ('/poblesec/settings/flickr/login_result',
                          'elisa.plugins.poblesec.login_settings_controller:LoginResultController'),

                         ('/poblesec/flickr/account',
                          'elisa.plugins.flickr.controller:FlickrAccountListSwitcherController'),
                         ('/poblesec/flickr/home',
                          'elisa.plugins.flickr.controller:FlickrListSwitcherPreviewController'),
                         ('/poblesec/flickr/folder',
                          'elisa.plugins.flickr.controller:FlickrListSwitcherPreviewController'),
                         ('/poblesec/flickr',
                          'elisa.plugins.flickr.controller:FlickrListSwitcherController')
                         ],
    decorator_mappings=[('/poblesec/settings/login',
                         'elisa.plugins.flickr.settings:flickr_settings_decorator'),
                        ('/poblesec/pictures/internet',
                         'elisa.plugins.flickr.controller:flickr_decorator')],
    cmdclass=cmdclass)
