# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.core.component import Component

class CannotCreateModel(Exception):
    pass

class Activity(Component):
    """
    DOCME
    """

    def get_model(self):
        """
        Return a model filled with the data generated by the activity.

        @rtype L{elisa.base_components.model.Model}

        @raise CannotCreateModel: if the model cannot be created
        """
        raise CannotCreateModel
