# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
Playlist management
"""

__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'


from elisa.base_components.activity import Activity

#
# Review by Benjamin Kampmann ( 24/08/2007 ):
# how does loadmore work? how should it work? what should it exaclty do?
# even looking in elisa/plugins/base/playlist/default_playlist.py didn't help
# me...

class Playlist(Activity):
    """ Playlist

    DOCME
    """

    def __init__(self):
        """ Initialize the Component's instance variables
        """
        Activity.__init__(self)
        self._history = []
        self._current_uri = None
        self.media_types = []
        self.loading = False
        
    def loadmore(self, model, start=0, end=None):
        """
        Request new items to be loaded in the playlist.

        @param model: DOCME
        @type model:  L{elisa.base_components.model.Model}
        @param start: starting index
        @type start:  int
        @param end:   ending index, None means end of list
        @type end:    int or None
        @rtype:       L{twisted.internet.defer.Deferred}
        """
        return None


    def empty(self):
        """ Empty the playlist of all its URIs.
        """

    def add_uri(self, uri, position=-1):
        """ Add an URI to the playlist.

        @param uri:      the uri to add. if uri is a list, it will be directly
                         added to the list model.
        @type uri:       L{elisa.core.media_uri.MediaUri} or list
        @param position: position of the list to update, -1 means appending
                         to the end
        @type position:  int
        """
