# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo, S.A. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
This module declares the different kinds of Messages travelling on the bus
"""

# FIXME: Messages cannot be declared in one place specially not in the core:
# they need to become Components so that any plugin can declare messages
# and use theirs and those of others.


__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'


from elisa.extern import enum


class Message(object):
    """
    Message base class. Each Message type should inherit from this.
    """

class ComponentsLoaded(Message):
    """
    Sent when all components have been instantiated
    """

class MediaLocation(Message):
    """
    Sent when a new device has been found

    @cvar action:           One of L{MediaLocation.ActionType} enum values
    @cvar name:             Name of the device
    @type name:             string
    @cvar fstype:           Filesystem type
    @type fstype:           string
    @cvar mount_point:      Mount point
    @type mount_point:      string
    @cvar media_types:      list of media_types stored on the device
    @type media_types:      list
    """

    ActionType = enum.Enum('NO_ACTION', 'LOCATION_ADDED', 'LOCATION_REMOVED',
                           'EJECT')

    action = ActionType.NO_ACTION
    name = ''
    fstype = ''
    mount_point = ''
    media_types = ['audio', 'video', 'image']

    def __init__(self, action, name, fstype, mount_point, media_types=None):
        self.action = action
        self.name = name
        self.fstype = fstype
        self.mount_point = mount_point
        if media_types is not None:
            self.media_types = media_types

    def __repr__(self):
        return "<MediaLocation %s %s %s>" % (self.action, self.name,
                                            self.mount_point)

class DeviceAction(MediaLocation):
    """
    DOCME
    """
    #ActionType = enum.Enum('NO_ACTION', 'DEVICE_ADDED', 'DEVICE_REMOVED')

class ForeignApplication(MediaLocation):
    """
    DOCME
    """

class LocalNetworkLocation(MediaLocation):
    """
    DOCME
    """

class InternetLocation(MediaLocation):
    """
    DOCME
    """
    
class HttpResource(Message):
    """
    Sent by components which need to register new HTTP Resources to the server
    """

    def __init__(self, path, resource):
        self.path = path
        self.resource = resource

class PBReferenceable(Message):
    """
    DOCME
    """

    def __init__(self, name, reference):
        self.name = name
        self.reference = reference

class PlayerModel(Message):
    """
    DOCME
    """

    def __init__(self, player_model):
        self.player_model = player_model


class CoherencePlugin(Message):
    """
    DOCME
    """

    def __init__(self, name, args):
        self.name = name
        self.args = args

class CoherenceDevice(Message):
    """
    DOCME
    """

    def __init__(self, name, callback, typ):
        self.name = name
        self.callback = callback
        self.typ = typ
