# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.extern.translation import Translator

from elisa.core import log, common, application
from elisa.core import config, plugin_registry
from elisa.core.bus import bus
from elisa.extern.log import log as extern_log

from twisted.trial import unittest
import os, inspect

class BoilerPlateApp:

    def __init__(self, config_file):
        self.config = config.Config(config_file)

        manager = plugin_registry.PluginRegistry(self.config)
        self.plugin_registry = manager
        self.bus = bus.Bus()
        self.translator = Translator()

    def handle_traceback(self):
        pass

class ElisaTestCase(unittest.TestCase, extern_log.Loggable):
    
    def __init__(self, methodName='runTest'):
        
        test_file_path = inspect.getsourcefile(self.__class__)
        if test_file_path is not None:
            fname = os.path.basename(test_file_path)

            fname, _ = os.path.splitext(fname)
            self.logCategory = fname
            self.directory = os.path.dirname(test_file_path)
        
        #extern_log.init('ELISA_TESTS')
        unittest.TestCase.__init__(self, methodName=methodName)

    debug = extern_log.Loggable.debug
    info = extern_log.Loggable.info
    
    def setUp(self):
        common.boot()

        if 'ELISA_DEBUG' not in os.environ:
            log.setDebug('*:0')

        app = BoilerPlateApp('empty.conf')
        default_config = application.DEFAULT_CONFIG % {'version': 'test',
                                                       'install_date': 'none'}
        app.config = config.Config('empty.conf', default_config)
        common.set_application(app)
        self.debug("Set common.application to %r", app)
        
    def check_called(self, callback):
        self.failUnless(hasattr(callback, 'called'))
        self.assertEquals(callback.called, True)
