#-*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest
from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core import common, player_engine_registry, plugin

from elisa.core.player import STATES

from elisa.base_components import player_engine

import gst

class StupidPipe(object):
    state = None

class FooEngine(player_engine.PlayerEngine):
    uri_schemes = {'foo' : 150, 'test' : 100, 'test2' : 50 }

    pipeline = None
    _volume = 0

    _videosink = None
    _audiosink = None

    def __init__(self):
        player_engine.PlayerEngine.__init__(self)
        self._pipeline = StupidPipe()
        self.pipeline = self._pipeline
        self._state = None

    def state__get(self):
        return self._state

    def state__set(self, state):
        self._state = state

    def _pipeline_set_state(self, state):
        self.pipeline.state = state

    def volume__set(self, volume):
        self._volume = volume

    def volume__get(self):
        return self._volume

    def audio_sink__set(self, sink):
        self._audiosink = sink

    def audio_sink__get(self):
        return self._audiosink

    def video_sink__set(self, sink):
        self._videosink = sink

    def video_sink__get(self):
        return self._videosink

class BarEngine(FooEngine):
    uri_schemes = {'bar' : 20}

class TestPlayerEngine(ElisaTestCase):

    def setUp(self):
        ElisaTestCase.setUp(self)
        self._engine = FooEngine()
   
    def test_engine(self):

        engine = self._engine

        engine.state = STATES.STOPPED
        engine.play()
        self.assertEquals(engine.state, STATES.LOADING)
        self.assertEquals(engine.pipeline.state, gst.STATE_PLAYING)

        engine.state = STATES.PLAYING
        engine.pause()
        self.assertEquals(engine.pipeline.state, gst.STATE_PAUSED)
       
        engine.state = STATES.PAUSED
        engine.play()
        self.assertEquals(engine.state, STATES.PLAYING)
        self.assertEquals(engine.pipeline.state, gst.STATE_PLAYING)

        engine.state = STATES.PLAYING
        engine.stop()
        self.assertEquals(engine.pipeline.state, gst.STATE_READY)


        engine.state = STATES.STOPPED
        self.assertEquals(engine.position, -1)
        self.assertEquals(engine.duration, -1)

        engine.state = STATES.PLAYING
        self.assertEquals(engine.position, -1) 
        self.assertEquals(engine.duration, -1)
        self.assertEquals(engine.speed, 1.0)

        # FIXME: not working.
#        engine.speed = 8.0
#        self.assertEquals(engine.speed, 8.0)
