# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase, BoilerPlateApp
from elisa.core import plugin
from elisa.core import log, common
from elisa.core import media_manager, metadata_manager, media_uri
from twisted.internet import defer
from elisa.plugins.base.media_providers.local_media import LocalMedia
from elisa.core.thumbnailer import Thumbnailer

import os
import sys
import tempfile, shutil

class FooPlugin(plugin.Plugin):
    name = 'foo'
    components = {'local_media': {'path': LocalMedia}}

class TestThumbnailer(ElisaTestCase):

    def setUp(self):
        ElisaTestCase.setUp(self)

        from elisa.core.common import application

        application.plugin_registry.register_plugin(FooPlugin)

        m_manager = metadata_manager.MetadataManager()
        application.media_manager = media_manager.MediaManager(m_manager)

        c = application.plugin_registry.create_component
        application.media_manager.register_component(c('foo:local_media'))
        application.media_manager.start()

        self._thumb_dir = tempfile.mkdtemp()
        self._thumbnailer = Thumbnailer(self._thumb_dir)

    def tearDown(self):
        from elisa.core.common import application

        application.media_manager.stop()
        shutil.rmtree(self._thumb_dir)
        ElisaTestCase.tearDown(self)
        
    def test_thumbnail_image(self):

        def got_picture(t):
            self.failUnless(os.path.exists(t[0]))
            got_picture.called = True

        got_picture.called = False

        uri = media_uri.MediaUri(u'file://./../elisa/core/tests/data/micro_cat.png')
        dfr = self._thumbnailer.get_thumbnail(uri, 256, "image")
        dfr.addCallback(got_picture)
        dfr.addCallback(lambda r: self.check_called(got_picture))
        return dfr

    def test_thumbnail_video(self):

        def got_video(t):
            self.failUnless(os.path.exists(t[0]))
            got_video.called = True

        got_video.called = False

        def video_error(msg):
            print msg.getTraceback()

        uri = media_uri.MediaUri(u'file://./../elisa/core/tests/data/test.ogm')
        dfr = self._thumbnailer.get_thumbnail(uri, 256, "video")
        dfr.addCallback(got_video)
        dfr.addErrback(video_error)
        dfr.addCallback(lambda r: self.check_called(got_video))
        return dfr
