# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.base_components.controller import Controller
from elisa.base_components.view import View
from elisa.base_components.view import ControllerNotSupported


class FooController(Controller):

    supported_models = ("none:foo_model",)

    def __init__(self):
        Controller.__init__(self)
        self.parameter_test = "test"
        self.path = "none:foo_controller"


class NonFooController(Controller):

    supported_models = ("none:foo_model",)

    def __init__(self):
        Controller.__init__(self)
        self.path = "none:nonfoo_controller"


class FooView(View):

    supported_controllers = ("none:foo_controller",)

    def __init__(self):
        View.__init__(self)
        self.changed = False

    def controller_changed(self):
        self.changed = True



class TestView(ElisaTestCase):

    def setUp(self):
        ElisaTestCase.setUp(self)
        self._foo = FooView()

    def test_controller_changed(self):
        controller = FooController()

        self._foo.controller = controller
        self.failUnless(self._foo.changed)

        self._foo.changed = False

        self._foo.controller = controller
        self.failUnlessEqual(self._foo.changed, False)

        self._foo.changed = False

        controller = FooController()
        self._foo.controller = controller
        self.failUnless(self._foo.changed)

    def test_supported_controllers(self):
        self.assertEquals(type(self._foo.supported_controllers), tuple)
        for s in self._foo.supported_controllers:
            self.assertEquals(type(s), str)

        controller = FooController()

        controller = NonFooController()
        self.failUnlessRaises(ControllerNotSupported, self._foo.controller__set, controller)
