# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.base_components.view import View

import pgm
from pypgmtools.graph.group import Group
from pypgmtools.graph.image import Image
from pypgmtools.timing import implicit

import os


class ElisaView(View):

    supported_controllers = ('base:elisa_controller')
    default_associations = (
    ('base:tree_controller','classic:node_view'),
    ('base:player_controller','poblenou:player_view'),
    ('base:slideshow_controller','poblenou:slideshow_view'),
    )

    def __init__(self):
        View.__init__(self)
        self.context_path = 'pigment:pigment_context'
        self.menu = None
        self.player = None
        self.context_handle = None

    def frontend_changed(self, previous_frontend, new_frontend):
        canvas = new_frontend.context.viewport_handle.get_canvas()
        group = Group(canvas, pgm.DRAWABLE_MIDDLE)
        group.visible = True
        group.opacity = 255

        self.context_handle = group

    def controller_changed(self):
        self._create_background()
        self._create_menu()
        self._create_player()

        self.menu.controller.focus()
        self.menu.controller.selected = True

    def _create_player(self):
        self.player = self.create_child_view(self.controller.player)
        self.context_handle.add(self.player.context_handle)
        self.menu.context_handle.opacity = 0
        self.player.context_handle.visible = True

        self._animated_player = implicit.AnimatedObject(self.player.context_handle)
        self._animated_player.mode = implicit.REPLACE

    def _create_menu(self):
        self.menu = self.create_child_view(self.controller.menu)
        self.context_handle.add(self.menu.context_handle)
        self.menu.context_handle.opacity = 0
        self.menu.context_handle.visible = True

        self._animated_menu = implicit.AnimatedObject(self.menu.context_handle)
        self._animated_menu.mode = implicit.REPLACE

    def _create_background(self):
        background_path = self.frontend.theme.get_media("background",
                                "classic:theme/background.png")
        fd = os.open(background_path, os.O_RDONLY)

        img = Image()
        img.bg_a = 0
        img.size = (4.0, 3.0)
        img.set_from_fd(fd)
        img.set_name('background')

        canvas = self.frontend.context.viewport_handle.get_canvas()
        canvas.add(pgm.DRAWABLE_FAR, img)

        img.visible = True


    def attribute_set(self, key, old_value, new_value):
        if key == 'focused':
            if self.menu.controller.focused:
                self._animated_player.opacity = 0
                self._animated_menu.opacity = 255
            elif self.player.controller.focused:
                self._animated_menu.opacity = 0
                self._animated_player.opacity = 255
