# -*- Mode: Python -*-
# vi:si:et:sw=4:sts=4:ts=4
import pygtk
pygtk.require('2.0')

import gobject
gobject.threads_init()

import pygst
pygst.require('0.10')

import gst
import gst.interfaces
from elisa.core.utils import classinit, signal
from elisa.core.media_uri import MediaUri

from fluendo_dvd.PipePlayer import *

DVD_ACTION_BUTTON_ACTIVATE = "Return"
DVD_ACTION_BUTTON_LEFT = "Left";
DVD_ACTION_BUTTON_RIGHT = "Right" 
DVD_ACTION_BUTTON_UP = "Up"
DVD_ACTION_BUTTON_DOWN = "Down"
DVD_ACTION_MENU_TITLE = "t"
DVD_ACTION_MENU_ANGLE = "a"
DVD_ACTION_MENU_PTT = "p"
DVD_ACTION_MENU_ROOT_OR_RESUME = "m"
DVD_ACTION_SEARCH_PREV_PG = "comma"
DVD_ACTION_SEARCH_NEXT_PG = "period"
DVD_ACTION_BUTTON_ANGLE_NEXT = "plus"
DVD_ACTION_BUTTON_ANGLE_PREV = "minus"
DVD_R = "r"


# A class with a sink pad for connecting an incoming audio stream.
class ElisaDVDPlayer:
    
    # Allows property fget/fset/fdel/doc overriding
    __metaclass__ = classinit.ClassInitMeta
    __classinit__ = classinit.build_properties
    
    in_menu = signal.Signal('in_menu', bool)
    
    def __init__(self, gpl=0):
        # 
        self._dvd_player = DVDPlayer(gpl=gpl)
        self._imagesink = None
        self.timeout  = 250 * gst.MSECOND
        self._is_menu = False
        bus = self._dvd_player.pipeline.get_bus()
        bus.connect('message', self.on_message)
    
    def is_menu__get(self):
        return self._is_menu
        
    def fire_action(self, action):
        state = self.get_state()
        #FIXME have read error if I'm asking menu where state is READY !!
        if state[1] == gst.STATE_READY and action == DVD_ACTION_MENU_ROOT_OR_RESUME:
            return
        
        if self._imagesink:
            if self._imagesink:
                s = gst.structure_from_string( "application/x-gst-navigation,event=key-release,key=%s" % action )
                event = gst.event_new_navigation(s)
                self._imagesink.send_event(event)
                
    def video_sink__get(self):
        """ Video sink access

        If we're using playbin, return the value of the 'video-sink'
        property. Either find the element in the pipeline named
        'video-sink'

        @rtype: L{gst.BaseSink}
        """
        
        return self._dvd_player.vsink

    def video_sink__set(self, sink):
        """ Video sink setter

        @type sink: L{gst.BaseSink}
        """
        self._dvd_player.vdecoder.unlink(self._dvd_player.vsink)
        self._dvd_player.pipeline.remove(self._dvd_player.vsink)
            
        self._imagesink = sink.get_by_name('pgm_sink')
        self._dvd_player.vsink = sink
        self._dvd_player.pipeline.add(sink)
        self._dvd_player.vdecoder.link(sink)


    def get_volume_element(self):
        vlm = self._dvd_player.pipeline.get_by_name('vlm')
        return vlm

    def volume__get(self):
        """The volume of the audio stream"""
        volume = 0
        vlm = self.get_volume_element()
        if vlm:
            volume = vlm.get_property('volume')
        return volume

    def volume__set(self, volume):
        vlm = self.get_volume_element()
        if vlm:
            vlm.set_property('volume', volume)
 
    def on_message(self, bus, message):
        if message.structure is None:
            return
        """
        if message.structure.get_name() == 'prepare-xwindow-id':
            message.src.set_property('force-aspect-ratio', True)
        """
        if message.type == gst.MESSAGE_ELEMENT and message.structure.get_name() == 'application/x-gst-dvd':
            self._is_menu = message.structure['in-menu']
            self.in_menu.emit(self._is_menu)

    def load_uri(self, uri):
        freezefile = None
        
        if isinstance(uri, MediaUri) and uri.scheme != 'dvd':
            path = uri.path
        else:
            path = None

        self._dvd_player.reader.set_location (path, freezefile)

    
    def gst_duration__get(self):
        """
        Returns the duration of the currently playing context

        @rtype: gst.FORMAT_TIME
        """
        if self._dvd_player.pipeline.get_state(self.timeout)[1] not in (gst.STATE_PLAYING, gst.STATE_PAUSED):
            return gst.CLOCK_TIME_NONE

        try:
            duration, format = self._dvd_player.pipeline.query_duration(gst.FORMAT_TIME)
        except:
            # FIXME: is this enough ?
            duration = gst.CLOCK_TIME_NONE

        return duration

    def duration__get(self):
        """
        Returns the duration of the currently playing context

        @rtype: long in nanoseconds,
        """
        duration = self.gst_duration
        if duration == gst.CLOCK_TIME_NONE:
            duration = 0

        return duration

    def gst_position__get(self):
        """
        Returns the position of the currently playing context

        @rtype: gst.FORMAT_TIME
        """

        if self._dvd_player.pipeline.get_state(self.timeout)[1] not in (gst.STATE_PLAYING, gst.STATE_PAUSED):
            return gst.CLOCK_TIME_NONE

        try:
            position, format = self._dvd_player.pipeline.query_position(gst.FORMAT_TIME)
        except:
            # FIXME: is this enough ?
            position = gst.CLOCK_TIME_NONE

        return position


    def position__get(self):
        """
        Returns the position of the currently playing context

        @rtype: long in nanoseconds,
        """
        position = self.gst_position
        if position == gst.CLOCK_TIME_NONE:
            position = 0

        return position

    def seek_to_location(self, location):
        """
        @param location: time to seek to, in nanoseconds
        """
        res = self._dvd_player.seek(location)

    def pause(self):
        self._dvd_player.pause()

    def play(self):
        self._dvd_player.play()
        
    def stop(self):
        self._dvd_player.stop()

    def get_state(self, timeout=1):
        return self._dvd_player.pipeline.get_state(timeout=timeout)

    def is_playing(self):
        return self._dvd_player
