# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'

from elisa.core.input_event import *
from elisa.core import common
from elisa.core import player
from elisa.core import plugin_registry
PlayerControllerClass = plugin_registry.get_component_class('base:player_controller')
from elisa.core.bus.bus_message import DeviceAction



class DvdPlayerController(PlayerControllerClass):
    
    supported_models = ('dvd:dvd_player_model')
    last_navigation_action = None
    #default_config = {}
    in_menu = False
    
    def __init__(self):
        PlayerControllerClass.__init__(self)
        common.application.bus.register(self._got_bus_message, DeviceAction)
        
    def _got_bus_message(self, message, sender):
        if message.action == message.ActionType.LOCATION_ADDED and \
               message.fstype == 'dvd':
            #self.model.state = player.STATES.PLAYING
            #FIXME : Can't do it because I revieve a signal when the dvd is in the reader at elisa starting
            self.info("start to play dvd automaticly")
        if message.action == message.ActionType.EJECT and \
               message.fstype == 'dvd':
            self.model.state = player.STATES.STOPPED
    
    
    def attribute_set(self, key, old_value, new_value):
        PlayerControllerClass.attribute_set(self, key, old_value, new_value)
        if key == 'last_navigation_action':
            self.last_navigation_action = new_value
        elif key == 'menu_requested':
            if new_value:
                self.model.last_navigation_action = EventAction.DVD_MENU
        elif key == 'in_menu':
            self.in_menu = new_value
    
    def focus_changed(self, value):
        if value == True and self.model.state != player.STATES.PLAYING:
            self.model.state = player.STATES.PLAYING
                
    def handle_input(self, input_event):
        if input_event.action == EventAction.PLAY:
            self.stopped = False
            self.model.state = player.STATES.PLAYING
        
        elif input_event.action == EventAction.PAUSE:
            self.stopped = False
            self.model.state = player.STATES.PAUSED
        
        elif input_event.action == EventAction.STOP:
            self.stopped = True
            self.model.state = player.STATES.STOPPED
        elif input_event.action == EventAction.VOL_UP:
            if self.model.volume < 10:
                self.model.volume += self._volume_increment_step
            
        elif input_event.action == EventAction.VOL_DOWN:
            if self.model.volume > 0:
                self.model.volume -= self._volume_decrement_step

        if input_event.action in (EventAction.GO_LEFT, EventAction.GO_RIGHT):
            self.model.last_navigation_action = input_event.action
        elif not self.in_menu:
            PlayerControllerClass.handle_input(self, input_event)
        elif input_event.action in (EventAction.GO_UP, EventAction.GO_DOWN,
                                    EventAction.OK, EventAction.DVD_MENU):
            #FIXME : temporary code
            self.model.last_navigation_action = input_event.action

        return False
    
    def state_changed(self, state):
        if self.model.state == player.STATES.PLAYING and not self.focused:
            self.focus()
        elif self.focused and state == player.STATES.STOPPED:
            # FIXME : ugly. need a window like system ?
            self.parent.show_menu()
