# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.base_components.view import View

import pygtk
pygtk.require('2.0')
import gtk


class GtkStartupView(View):
    """
    This class implements gtk list view support
    """

    supported_controllers = ('base:elisa_controller', 'poblenou:elisa_controller')
    default_associations = (
    ('base:elisa_controller','gtk:gtk_startup_view'),
    ('base:tree_controller','gtk:gtk_tree_view'),
    ('base:player_controller','gtk:gtk_player_view'),
    ('poblenou:elisa_controller','gtk:gtk_startup_view'),
    ('poblenou:tree_controller','gtk:gtk_tree_view'),
    )

    def __init__(self):
        View.__init__(self)
        self.context_path = 'gtk:gtk_context'
        self.menu = None
        self.player = None
        self.box = gtk.VBox()
        self.context_handle = self.box

    def controller_changed(self):
        self.menu = self.create_child_view(self.controller.menu)
        scrolled_treeview = gtk.ScrolledWindow()
        scrolled_treeview.add(self.menu.treeview)
        self.box.pack_start_defaults(scrolled_treeview)
        self.player = self.create_child_view(self.controller.player)
        self.box.pack_end(self.player.vbox, False, False, 0)


    def save_config(self, app_config):
        View.save_config(self, app_config)
        self.menu.save_config(app_config)
        self.player.save_config(app_config)
