
from elisa.core.tests import component_test_case
from elisa.core.media_uri import MediaUri
import os
from twisted.internet import defer

class TestIpodMedia(component_test_case.ComponentTestCase):

    component_class = 'elisa.plugins.bad.media_bad.ipod_media:IpodMedia'

    def setUp(self):
        component_test_case.ComponentTestCase.setUp(self)
        itunesdb = "../elisa/plugins/bad/media_bad/tests/data/iTunesDB"
        self._ipod = MediaUri("ipod://%s" % itunesdb)
        
    def test_directory(self):
        uri = self._ipod
        dfr = self.component.is_directory(uri)
        dfr.addCallback(lambda validated: self.assertEquals(validated, True))

        uri = MediaUri(u'%s?artist=Rammstein' % self._ipod)
        dfr1 = self.component.is_directory(uri)
        dfr1.addCallback(lambda validated: self.assertEquals(validated, True))

        uri = MediaUri(u'%s?id=1234' % self._ipod)
        dfr2 = self.component.is_directory(uri)
        dfr2.addCallback(lambda validated: self.assertEquals(validated, False))
        return defer.DeferredList([dfr, dfr1, dfr2])
