# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'

from elisa.base_components.action import Action
from elisa.core.bus.bus_message import DeviceAction
from elisa.core import common, player

class EjectAction(Action):
    """
    DOCME
    """
    
    player_model = None
    
    def __call__(self, controller, origin=None):
        """
        """
        self.player_model.state = player.STATES.STOPPED
        
        msg = DeviceAction(DeviceAction.ActionType.EJECT, '', self.uri.scheme,
                           '', [])
        common.application.bus.send_message(msg)
