# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'
__maintainer2__ = 'Philippe Normand <philippe@fluendo.com>'


from media_menu_activity import MediaMenuActivity
from elisa.core import common

from elisa.extern.translation import gettexter, N_

T_ = gettexter('elisa-base')


class ImageActivity(MediaMenuActivity):

    config_doc = {'locations': 'the image media locations',
                  }

    default_config = {'locations': ['file://./sample_data/pictures/',
                                   ],
                      }

    menu_name = T_(N_("Pictures"))
    menu_icon_name = "image"
    media_types = ["image",]
    xdg_var_name = 'XDG_PICTURES_DIR'
    
    def set_directory_actions(self, menu_model, uri):
        registry = common.application.plugin_registry
        action = registry.create_component('base:slideshow_action')
        action.uri = uri
        action.slideshow_model = self.slideshow_model
        
        action_model = self._create_menu_model(T_(N_('Slideshow')), 'slideshow')
        action_model.uri = uri
        action_model.activate_action = action
        menu_model.insert(0, action_model)
        
        self.files_index_start = 1

    def set_activate_action(self, menu_model, uri, file_type):
        registry = common.application.plugin_registry
        action = registry.create_component('base:view_image_action')
        action.uri = uri
        action.parent_uri = menu_model.parent.uri
        action.slideshow_model = self.slideshow_model
        menu_model.activate_action = action

    def set_hover_action(self, menu_model, uri, file_type='directory'):
        if file_type != 'directory':
            registry = common.application.plugin_registry
            action = registry.create_component('base:preview_image_action')
            action.uri = uri
            action.parent_uri = menu_model.parent.uri
            action.slideshow_model = self.slideshow_model
            menu_model.hover_action = action
