# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'


from media_menu_activity import MediaMenuActivity
from elisa.core import common, media_uri
from elisa.core.bus import bus_message
from elisa.core.plugin_registry import PluginNotFound, ComponentNotFound

from elisa.extern.translation import gettexter, N_

T_ = gettexter('elisa-base')

class VideoActivity(MediaMenuActivity):

    config_doc = {'locations': 'the video media locations',
                  }

    default_config = {'locations': ['file://./sample_data/movies/',
                                   ],
                      }

    menu_name = T_(N_("Video"))
    menu_icon_name = "video"
    media_types = ["video",]
    xdg_var_name = 'XDG_VIDEOS_DIR'

    _dvd_model = None

    def _got_bus_message(self, message, sender):

        if isinstance(message, bus_message.DeviceAction) and \
               message.fstype == 'dvd':
            ActionType = bus_message.MediaLocation.ActionType
            if message.action == ActionType.LOCATION_ADDED:
                self._load_dvd_activity()
            else:
                self._unload_dvd_activity()
        else:
            MediaMenuActivity._got_bus_message(self, message, sender)
            
    def _load_dvd_activity(self):
        dvd_activity = self._create_activity('dvd:dvd_activity')
        self._dvd_model = dvd_activity.get_model()
        self.root_menu.insert(0, self._dvd_model)

    def _unload_dvd_activity(self):
        self.root_menu.remove(self._dvd_model)
        self._dvd_model = None

