# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'
__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.base_components.model import Model


class SlideshowModel(Model):
    """
    Modelizes a picture slideshow data structure, that is to say an ordered
    list of URIs pointing to pictures along with a position in that list and
    some configuration parameters: duration between pictures, visualization
    mode.

    @ivar current_index: index of the currently displayed picture
    @type current_index: int
    @ivar playing:       whether or not the slideshow is currently playing
    @type playing:       boolean
    @ivar playlist:      list of pictures to be displayed
    @type playlist:      L{elisa.plugins.base.list_model.ListModel}
    @ivar preview_mode:  whether or not the player is previewing the pictures
    @type preview_mode:  boolean
    @ivar duration:      delay between two pictures (in seconds)
    @type duration:      float
    """

    current_index = 0
    playing = False
    playlist = None
    preview_mode = False
    duration = 5.0
