
from elisa.core.tests import component_test_case
from elisa.plugins.base.views.list_view import ListView
from elisa.base_components.view import View
from elisa.core.frontend import Frontend

class TestListView(component_test_case.ComponentTestCase):

    component_class = ListView

    def test_parent(self):

        root_view = ListView()
        child_list_view = ListView()
        child_view = View()
        child_view2 = View()

        self.assertEquals(root_view.parent, None)
        self.assertEquals(child_list_view.parent, None)
        self.assertEquals(child_view.parent, None)

        root_view.append(child_view)
        self.assertEquals(root_view.parent, None)
        self.assertEquals(child_list_view.parent, None)
        self.assertEquals(child_view.parent, root_view)

        root_view.append(child_list_view)
        self.assertEquals(root_view.parent, None)
        self.assertEquals(child_list_view.parent, root_view)
        self.assertEquals(child_view.parent, root_view)

        root_view.remove(child_list_view)
        self.assertEquals(root_view.parent, None)
        self.assertEquals(child_list_view.parent, None)
        self.assertEquals(child_view.parent, root_view)

        root_view.remove(child_view)
        self.assertEquals(root_view.parent, None)
        self.assertEquals(child_list_view.parent, None)
        self.assertEquals(child_view.parent, None)


        root_view.append(child_list_view)
        self.assertEquals(child_list_view.parent, root_view)
        root_view.extend([child_view, child_view2])
        self.assertEquals(child_view.parent, root_view)
        self.assertEquals(child_view2.parent, root_view)

        root_view.pop()
        self.assertEquals(child_list_view.parent, root_view)
        self.assertEquals(child_view.parent, root_view)
        self.assertEquals(child_view2.parent, None)

        root_view.insert(0, child_view2)
        self.assertEquals(child_list_view.parent, root_view)
        self.assertEquals(child_view.parent, root_view)
        self.assertEquals(child_view2.parent, root_view)

        del root_view[0]
        self.assertEquals(child_list_view.parent, root_view)
        self.assertEquals(child_view.parent, root_view)
        self.assertEquals(child_view2.parent, None)
        child_list_view = ListView()

        root_view[1] = child_view2
        self.assertEquals(child_list_view.parent, None)
        self.assertEquals(child_view.parent, None)
        self.assertEquals(child_view2.parent, root_view)

        root_view.insert(0, child_list_view)
        root_view.insert(1, child_view)
        self.assertEquals(child_list_view.parent, root_view)
        self.assertEquals(child_view.parent, root_view)
        self.assertEquals(child_view2.parent, root_view)

        del root_view[0:2]
        self.assertEquals(child_list_view.parent, None)
        self.assertEquals(child_view.parent, None)
        self.assertEquals(child_view2.parent, root_view)
        child_list_view = ListView()
        child_view = View()

        root_view=ListView()
        root_view.append(child_list_view)
        root_view.append(child_view)
        root_view.append(child_view2)
        child_view3 = View()
        child_view4 = View()

        self.assertEquals(child_list_view.parent, root_view)
        self.assertEquals(child_view.parent, root_view)
        self.assertEquals(child_view2.parent, root_view)
        self.assertEquals(child_view3.parent, None)
        self.assertEquals(child_view4.parent, None)

        root_view[1:2] = [child_view3, child_view4]
        self.assertEquals(child_list_view.parent, root_view)
        self.assertEquals(child_view.parent, None)
        self.assertEquals(child_view2.parent, root_view)
        self.assertEquals(child_view3.parent, root_view)
        self.assertEquals(child_view4.parent, root_view)


    def test_parent2(self):
        root_view = ListView()
        child_list_view = ListView()
        child_view = View()

        child_list_view.append(child_view)
        root_view.append(child_list_view)

        self.assertEquals(root_view.parent, None)
        self.assertEquals(child_list_view.parent, root_view)
        self.assertEquals(child_view.parent, child_list_view)


    def test_frontend(self):
        root_view = ListView()
        frontend = Frontend(root_view, None, None)
        root_view.frontend = frontend

        child_list_view = ListView()
        child_view = View()

        child_list_view.append(child_view)
        root_view.append(child_list_view)

        self.assertEquals(root_view.frontend, frontend)
        self.assertEquals(child_list_view.frontend, frontend)
        self.assertEquals(child_view.frontend, frontend)
