# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from list_view import ListView

class NodeView(ListView):

    supported_controllers = ('base:node_controller')
    
    default_associations = (
        ('base:node_controller', 'base:node_view'),
    )
    
    def __init__(self):
        ListView.__init__(self)
        self._root = self
        
    
    def root__set(self, root):
        self._root = root
        for c in self:
            c.root = self.root


    def root__get(self):
        return self._root
    
    def controller_changed(self):
        if isinstance(self.parent, NodeView) and self.parent.root != None:
            self.root = self.parent.root
        ListView.controller_changed(self)

    def child_view_creating(self, view, controller, position):
        if self.root != None:
            view.root = self.root
        ListView.child_view_creating(self, view, controller, position)
    