# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
UPnP MediaRenderer
"""

__maintainer__ = "Philippe Normand <philippe@fluendo.com>"

from elisa.base_components import service_provider
from elisa.core import common, component
from elisa.core.bus.bus_message import PlayerModel, ComponentsLoaded, \
     PBReferenceable, CoherencePlugin
from elisa.core import player, media_uri

from twisted.spread import pb

class UPnPMediaRenderer(pb.Referenceable, service_provider.ServiceProvider):
    """
    DOCME
    """

    def initialize(self):
        common.application.bus.register(self._bus_message_received,
                                        PlayerModel, ComponentsLoaded)

    def _bus_message_received(self, msg, sender):
        if isinstance(msg, PlayerModel):
            self.player_model = msg.player_model
        else:
            # register myself to the PB service
            msg = PBReferenceable('get_player', self)
            common.application.bus.send_message(msg)

            args = {}#'host':'internal'}
            msg = CoherencePlugin('ElisaPlayer', args)
            common.application.bus.send_message(msg)


    def remote_set_uri(self, uri):
        if uri:
            uri = media_uri.MediaUri(uri)
            self.debug("Playing %r", uri)
            self.player_model.uri = uri
        else:
            self.warning("Not usable URI: %r", uri)

    def remote_get_readable_state(self):
        state = 'STOPPED'
        if self.player_model.state:
            state = str(self.player_model.state)

        return state

    def remote_get_volume(self):
        volume = self.player_model.volume
        volume = (volume * 100) / 10.
        return int(volume)


    def remote_set_volume(self, volume):

        if int(volume) in range(101):
            volume = int(volume)
            self.info("Setting volume to %s" % volume)
            volume = (volume * 10) / 100.
            if volume < 0.:
                volume = 0.
            elif volume > 10.:
                volume = 10.
            self.player_model.volume = volume

    def remote_get_status(self):
        position = self.player_model.position
        duration = self.player_model.duration
        return (position, duration)

    def remote_get_mute(self):
        return self.player_model.muted

    def remote_mute(self):
        self.player_model.muted = True

    def remote_un_mute(self):
        self.player_model.muted = False

    def remote_play(self):
        self.player_model.state = player.STATES.PLAYING
        return True

    def remote_pause(self):
        self.player_model.state = player.STATES.PAUSED
        return True

    def remote_stop(self):
        self.player_model.state = player.STATES.STOPPED
        return True


"""
remote_play_uri = play_uri_once
remote_toggle_play_pause = toggle_play_pause
remote_seek_forward = seek_forward
remote_seek_backward = seek_backward
remote_increment_playback_speed = increment_playback_speed
remote_decrement_playback_speed = decrement_playback_speed
remote_next = next
remote_get_current_item = get_current_item
remote_get_status_informations = get_status_informations
"""
