
from elisa.core.tests import component_test_case
from elisa.core.tests.elisa_test_case import BoilerPlateApp
from elisa.plugins.good.media_good import elisa_media
from elisa.core import common
from elisa.core.media_uri import MediaUri
from elisa.core.media_db import MediaDB
from elisa.core.db_backend import DBBackend, DBBackendError
from elisa.core.utils import classinit

import os
import threading

DB_CONNECTIONS = {}

class FakeMediaManager:

    # Allows property fget/fset/fdel/doc overriding
    __metaclass__ = classinit.ClassInitMeta
    __classinit__ = classinit.build_properties

    def __init__(self):
        self._db_lock = threading.Lock()

    def media_db__get(self):
        """ MediaDB instance accessor.
        @warning: If  '../elisa/plugins/base/tests/data/elisa.db' changes
                  the tests won't work anymore
        """

        db = None

        global DB_CONNECTIONS
        try:
            self._db_lock.acquire()
            current_thread = threading.currentThread()
            thread_id = id(current_thread)
            backend = DB_CONNECTIONS.get(thread_id)
            if not backend:
                db = '../elisa/plugins/good/media_good/tests/data/elisa.db'
                backend = DBBackend(db_backend='sqlite',
                                    database=db)

                DB_CONNECTIONS[thread_id] = backend
            if backend:
                db = MediaDB(backend)
        finally:
            self._db_lock.release()

        return db

class ElisaMediaApp(BoilerPlateApp):

    def __init__(self, config_file):
        BoilerPlateApp.__init__(self, config_file)
        self.media_manager = FakeMediaManager()


class TestElisaMedia(component_test_case.ComponentTestCase):

    component_class = elisa_media.ElisaMedia


    def __init__(self, methodName='runTest'):
        component_test_case.ComponentTestCase.__init__(self,
                                                       methodName=methodName)
        db_file = 'elisa/plugins/good/media_good/tests/data/elisa.db'
        try:
            db = DBBackend(db_backend='sqlite', database=db_file)
        except DBBackendError, error:
            self.skip = error

    def setUp(self):
        component_test_case.ComponentTestCase.setUp(self)

        common.boot()

        app = ElisaMediaApp('empty.conf')
        common.set_application(app)

        #common.application.media_manager.media_db = MediaDB(db)


    def test_get_artists(self):

        lc = []

        def gotchildren(l):
            res = MediaUri('elisa://localhost/artists/archive')

            uri = []
            for ur,els in l:
                uri.append(ur)

            self.failUnless(res in uri)


        uri = MediaUri('elisa://localhost/artists')
        dfr = self.component.get_direct_children(uri, lc)
        dfr.addCallback(gotchildren)
        return dfr


    def test_get_artists_by_name(self):

        lc = []

        def gotchildren(l):
            r = 'elisa://localhost/artists/archive/albums/'
            expected_uris = [ MediaUri('%s%s' % (r, u))
                              for u in ('lights',
                                        'londinium',
                                        'take%20my%20head',
                                        'you%20all%20look%20the%20same%20to%20me')
                             ]
            uris = []
            for ur,els in l:
                uris.append(ur)

            self.assertEqual(expected_uris, uris)

        uri = MediaUri('elisa://localhost/artists/archive')
        dfr = self.component.get_direct_children(uri, lc)
        dfr.addCallback(gotchildren)
        return dfr


    def test_get_artists_by_name_by_album(self):

        lc = []

        def gotchildren(l):
            uri = MediaUri('elisa://localhost/artists/archive/albums/londinium')
            uris = []
            for ur,els in l:
                uris.append(ur)

            self.failUnless(uri in uris)


        uri = MediaUri('elisa://localhost/artists/archive/albums')
        dfr = self.component.get_direct_children(uri, lc)
        dfr.addCallback(gotchildren)
        return dfr

    def test_get_files(self):

        lc = []

        def gotchildren(l):
            expected_len = 1364
            self.failUnless(len(l) == expected_len)


        uri = MediaUri('elisa://localhost/files')
        dfr = self.component.get_direct_children(uri, lc)
        dfr.addCallback(gotchildren)
        return dfr
