
from elisa.core.tests import component_test_case
from elisa.core import media_uri
import os

class TestTaglibMetadata(component_test_case.ComponentTestCase):

    component_class = 'elisa.plugins.good.media_good.taglib_metadata:TaglibMetadata'

    def test_able_to_handle(self):
        uri = media_uri.MediaUri('file://')

        able = self.component.able_to_handle({'uri': uri,
                                              'content-type': 'audio'})
        self.assertEqual(able, True)

        able = self.component.able_to_handle({'uri': uri,
                                              'content-type': 'video'})
        self.assertEqual(able, False)

        able = self.component.able_to_handle({'uri': uri,
                                              'content-type': 'directory'})

        self.assertEqual(able, False)




    def test_get_metadata(self):
        uri = media_uri.MediaUri("file://./../elisa/plugins/good/media_good/tests/data/test.ogg")

        def dict_filled(dict):
            static_tags = { 'album': u'httpopenmusiclinuxtagorg',
                            'artist': u'open_music', 'track': 1,
                            'song': u'open_source__magic_mushrooms',
                            'uri': uri ,'content-type': 'audio'}
            self.assertEqual(dict, static_tags)

        dfr = self.component.get_metadata({'uri': uri,
                                           'content-type':'audio'})
        dfr.addCallback(dict_filled)
        return dfr
