# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Authors: Benjamin Kampmann <benjamin@fluendo.com>
#          Olivier Tilloy <olivier@fluendo.com>
#          Philippe Normand <philippe@fluendo.com>

from elisa.core.utils.bindable import Bindable

class Model(Bindable):

    """
    A model is a data representation of a resource requested with a C{uri}.

    This one is just a general meta class, don't use it directly but create
    your own class inheriting from this one.

    *Conventions*:
     - the classname of a model should always end with 'Model' (e.g.
       AlbumModel or TrackModel).
     - all models inherit (directly or indirectly) from this model
     - the data fields of a model are set to C{None} at initialization time
     - list fields are set to an empty list at initialization time

    A model is a L{elisa.core.utils.bindable.Bindable} so that everyone can be
    informed about changes with this system (especially interesting for UIs).
    """

    # FIXME: this is not a component, it should be moved to elisa.core
    pass
