# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core.utils import exception_hook
import sys, platform

class TestExceptionHook(ElisaTestCase):
    
    def __init__(self, methodName='runTest'):
        ElisaTestCase.__init__(self, methodName)
        if platform.system() == 'Windows':
            self.skip = "test not supported under windows"

    def test_failure_formatting(self):
        # test, that it does not fail
        from twisted.python.failure import Failure
        f = Failure(Exception)
        data = exception_hook.format_failure(f)

    def test_exception_formatting(self):
        # test, that it does not fail
        try:
            raise Exception
        except:
            info = sys.exc_info()
            data = exception_hook.format_traceback()
            data2 = exception_hook.format_traceback(*info)

    def test_data_writing(self):
        data = 'Pocahontas\nMikey Mouse'
        path = exception_hook.write_to_logfile(data)
        self.failUnless(path)

        r = open(path,'r').read()
        self.assertEquals(data, r)

    def test_wrong_logdirs(self):
        path = exception_hook.write_to_logfile('', logdir='/')
        self.failIf(path)

        path = exception_hook.write_to_logfile('', logdir='/never')
        self.failIf(path)

        path = exception_hook.write_to_logfile('', logdir='/var/log')
        self.failIf(path)
