/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.Sequence;

public class SequenceJPanel
extends JPanel
implements ActionListener {
    private Color col;
    protected Sequence seq;
    private int fontSize = 12;
    private Font font = new Font("Monospaced", 0, this.fontSize);
    private int boundWidth;
    protected int boundWidth2;
    protected int resWidth;
    protected int seqHeight;
    private int pressedResidue;
    protected int interval;
    private int seqLength;
    private int ypad = 0;
    private Hashtable colorTable;
    private String padChar = new String("-");
    private String pattern;
    private boolean drawSequence = false;
    private boolean drawBlackBox = false;
    private boolean drawColorBox = false;
    protected boolean drawNumber = false;
    private boolean prettyPlot = false;
    private boolean highlightPattern = false;
    protected JComponent viewPane;
    private JPopupMenu popup;
    private Vector observers;

    public SequenceJPanel(Sequence seq, JComponent viewPane, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, Hashtable colorTable, int fontSize, int ypad) {
        this.drawSequence = drawSequence;
        this.drawBlackBox = drawBlackBox;
        this.drawColorBox = drawColorBox;
        this.viewPane = viewPane;
        this.seq = seq;
        this.ypad = ypad;
        this.setOpaque(false);
        if (colorTable != null) {
            this.colorTable = colorTable;
        } else {
            this.setDefaultColorHashtable();
        }
        if (fontSize != 0) {
            this.fontSize = fontSize;
            this.font = new Font("Monospaced", 0, fontSize);
        }
        FontMetrics metrics = this.getFontMetrics(this.font);
        this.boundWidth = metrics.stringWidth("A");
        this.boundWidth2 = this.boundWidth / 2;
        this.resWidth = metrics.stringWidth("A") + this.boundWidth2;
        if (seq != null) {
            this.seqLength = seq.getLength();
        }
        this.seqHeight = metrics.stringWidth("A") + this.boundWidth;
        this.init();
        this.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        JLabel labName = null;
        labName = seq.getID() != null ? new JLabel(" " + seq.getID()) : new JLabel(" " + seq.getName());
        this.popup.add(labName);
        this.popup.add(new JSeparator());
        JMenuItem menuItem = new JMenuItem("Delete ");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.popup.add(new JSeparator());
        menuItem = new JMenuItem("Reverse Complement ");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        menuItem = new JMenuItem("Reverse ");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        menuItem = new JMenuItem("Complement ");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.setPreferredSize(this.getPreferredSize());
    }

    public SequenceJPanel(Sequence seq, JComponent viewPane, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, Hashtable colorTable, int ypad) {
        this(seq, viewPane, drawSequence, drawBlackBox, drawColorBox, colorTable, 0, ypad);
    }

    public SequenceJPanel(int interval, int seqLength) {
        this.seq = null;
        this.drawNumber = true;
        this.interval = interval;
        this.seqLength = seqLength + 1;
        this.setOpaque(false);
        FontMetrics metrics = this.getFontMetrics(this.font);
        this.boundWidth = metrics.stringWidth("A");
        this.boundWidth2 = this.boundWidth / 2;
        this.resWidth = metrics.stringWidth("A") + this.boundWidth2;
        this.seqHeight = metrics.stringWidth("A") + this.boundWidth;
        this.setPreferredSize(this.getPreferredSize());
    }

    public void init() {
        if (!this.drawNumber) {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    Point loc = e.getPoint();
                    SequenceJPanel.this.pressedResidue = loc.x / SequenceJPanel.this.resWidth;
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent e) {
                    Point loc = e.getPoint();
                    int resPos = loc.x / SequenceJPanel.this.resWidth;
                    SequenceJPanel.this.notifyGroup(resPos, SequenceJPanel.this.pressedResidue);
                    SequenceJPanel.this.update(resPos, SequenceJPanel.this.pressedResidue);
                }
            });
        }
    }

    protected void update(int resPos, int pressed) {
        this.pressedResidue = pressed;
        if (resPos == this.pressedResidue + 1 && resPos > 0) {
            this.seq.insertResidue(this.padChar, this.pressedResidue);
            ((GraphicSequenceCollection)this.viewPane).setMaxSequenceLength(this.seq.getLength());
            ++this.pressedResidue;
            this.repaint();
            this.viewPaneResize();
        } else if (resPos == this.pressedResidue - 1 && resPos > -1 && this.seq.getResidueAt(resPos).equals(this.padChar)) {
            this.seq.deleteResidue(resPos);
            --this.pressedResidue;
            this.repaint();
        }
    }

    protected void attach(SequenceJPanel sjp) {
        if (this.observers == null) {
            this.observers = new Vector();
        }
        this.observers.add(sjp);
    }

    protected void detach(SequenceJPanel sjp) {
        if (this.observers != null && this.observers.contains(sjp)) {
            this.observers.remove(sjp);
        }
    }

    protected void detachAll() {
        this.observers = null;
    }

    protected void notifyGroup(int res, int pressed) {
        if (this.observers != null) {
            Enumeration enumer = this.observers.elements();
            while (enumer.hasMoreElements()) {
                ((SequenceJPanel)enumer.nextElement()).update(res, pressed);
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(this.font);
        FontMetrics metrics = g.getFontMetrics();
        this.boundWidth = metrics.stringWidth("A");
        this.boundWidth2 = this.boundWidth / 2;
        int boundWidth4 = this.boundWidth2 / 2;
        this.resWidth = metrics.stringWidth("A") + this.boundWidth2;
        this.seqHeight = metrics.stringWidth("A") + this.boundWidth;
        String seqS = null;
        if (!this.drawNumber) {
            seqS = this.seq.getSequence();
            this.seqLength = seqS.length();
        }
        int istart = 0;
        int istop = this.seqLength;
        try {
            Rectangle viewRect = ((GraphicSequenceCollection)this.viewPane).getViewRect();
            istart = viewRect.x / this.resWidth;
            istop = istart + viewRect.width / this.resWidth + 2;
            if (istop > this.seqLength) {
                istop = this.seqLength;
            }
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        Vector pvec = null;
        Font fontBold = null;
        if (this.drawSequence && this.highlightPattern) {
            int pstop;
            int patlen = this.pattern.length();
            int pstart = istart - patlen;
            if (pstart < 0) {
                pstart = 0;
            }
            if ((pstop = istop + patlen) > this.seqLength) {
                pstop = this.seqLength;
            }
            pvec = this.getPatternPositions(pstart, seqS.substring(pstart, pstop));
            fontBold = new Font(this.font.getName(), 1, this.font.getSize() + 3);
        }
        boolean leftResidue = false;
        for (int i = istart; i < istop; ++i) {
            int ipos = i * this.resWidth;
            if (this.drawColorBox) {
                g.setColor(this.getColor(seqS.substring(i, i + 1)));
                g.fillRect(ipos, 0, this.resWidth, this.seqHeight);
            }
            g.setColor(Color.black);
            if (this.drawSequence) {
                if (this.highlightPattern && pvec.contains(new Integer(i))) {
                    g.setFont(fontBold);
                }
                String res = seqS.substring(i, i + 1);
                if (this.prettyPlot) {
                    leftResidue = this.prettyDraw(i, ipos, istop, res, this.seqHeight, this.resWidth, leftResidue, g);
                }
                g.drawString(res, ipos + boundWidth4, this.seqHeight - this.boundWidth2);
                if (this.highlightPattern) {
                    g.setFont(this.font);
                }
            } else if (this.drawNumber && (i + 1) % this.interval == 0) {
                String snum = Integer.toString(i + 1);
                int numWidth = metrics.stringWidth(snum);
                g.drawString(snum, (int)(((double)i + 0.5) * (double)this.resWidth) - numWidth / 2, this.seqHeight - this.boundWidth2);
            }
            if (!this.drawBlackBox) continue;
            g.setColor(Color.black);
            g.drawRect(ipos, 0, this.resWidth, this.seqHeight);
        }
    }

    private boolean prettyDraw(int i, int ipos, int istop, String res, int seqHeight, int resWidth, boolean leftResidue, Graphics g) {
        GraphicSequenceCollection gsc = (GraphicSequenceCollection)this.viewPane;
        String sName = this.seq.getName();
        Color col = gsc.getColor(res, i, sName);
        Color colBackground = gsc.getPrettyBackground(col);
        if (colBackground != null) {
            g.setColor(colBackground);
            g.fillRect(ipos, 0, resWidth, seqHeight);
        }
        if (!col.equals(Color.black) && gsc.isPrettyBox()) {
            g.setColor(Color.black);
            if (!leftResidue) {
                g.drawLine(ipos, 0, ipos, seqHeight);
            }
            leftResidue = true;
            if (i + 2 > istop) {
                g.drawLine(ipos + resWidth, 0, ipos + resWidth, seqHeight);
            } else {
                String resRight = this.seq.getSequence().substring(i + 1, i + 2);
                Color rightCol = gsc.getColor(resRight, i + 1, sName);
                if (rightCol.equals(Color.black)) {
                    g.drawLine(ipos + resWidth, 0, ipos + resWidth, seqHeight);
                }
            }
            int upAndDown = gsc.testUpAndDown(i, this.seq);
            if (upAndDown == 1 || upAndDown == 3) {
                g.drawLine(ipos, 0, ipos + resWidth, 0);
            }
            if (upAndDown == 2 || upAndDown == 3) {
                g.drawLine(ipos, seqHeight - 1, ipos + resWidth, seqHeight - 1);
            }
        } else {
            leftResidue = false;
        }
        g.setColor(col);
        return leftResidue;
    }

    private Vector getPatternPositions(int istart, int istop, String seqS) {
        int ipat;
        Vector<Integer> pvec = new Vector<Integer>();
        int patlen = this.pattern.length();
        int pstart = istart - patlen;
        int pstop = istop + patlen;
        if (pstart < 0) {
            pstart = 0;
        }
        if (pstop > this.seqLength) {
            pstop = this.seqLength;
        }
        while ((ipat = seqS.substring(pstart, pstop).indexOf(this.pattern)) > -1) {
            for (int i = 0; i < patlen; ++i) {
                pvec.add(new Integer(ipat + pstart + i));
            }
            pstart = ipat + pstart + 1;
        }
        return pvec;
    }

    private Vector getPatternPositions(int subseqStart, String subseq) {
        int ipat;
        subseq = subseq.toLowerCase();
        Vector<Integer> pvec = new Vector<Integer>();
        int patlen = this.pattern.length();
        int pstart = 0;
        while ((ipat = subseq.substring(pstart).indexOf(this.pattern)) > -1) {
            for (int i = 0; i < patlen; ++i) {
                pvec.add(new Integer(ipat + pstart + subseqStart + i));
            }
            pstart = ipat + pstart + 1;
        }
        return pvec;
    }

    protected void showPattern(String pattern) {
        this.highlightPattern = true;
        this.pattern = pattern.toLowerCase();
    }

    public void setPrettyPlot(boolean prettyPlot) {
        this.prettyPlot = prettyPlot;
    }

    public boolean isPrettyPlot() {
        return this.prettyPlot;
    }

    public String getToolTipText(MouseEvent e) {
        Point loc = e.getPoint();
        int resPos = loc.x / this.resWidth;
        if (resPos < 0) {
            return null;
        }
        if (resPos > this.seq.getSequence().length() - 1) {
            return null;
        }
        String res = this.seq.getSequence().substring(resPos, resPos + 1);
        String ls = System.getProperty("line.separator");
        if (this.seq.getID() != null) {
            return this.seq.getID() + "\nResidue: " + res + ls + "Position: " + Integer.toString(resPos + 1);
        }
        return this.seq.getName() + "\nResidue: " + res + ls + "Position: " + Integer.toString(resPos + 1);
    }

    public Point getToolTipLocation(MouseEvent e) {
        Point loc = e.getPoint();
        int x = (loc.x + this.resWidth) / this.resWidth * this.resWidth;
        int y = this.seqHeight - this.resWidth / 2;
        return new Point(x, y);
    }

    private Color getColor(String s) {
        if (this.colorTable.containsKey(s = s.toUpperCase())) {
            return (Color)this.colorTable.get(s);
        }
        return this.getBackground();
    }

    public void setDefaultColorHashtable() {
        this.colorTable = new Hashtable();
        this.colorTable.put("A", Color.green);
        this.colorTable.put("T", Color.red);
        this.colorTable.put("C", Color.blue);
        this.colorTable.put("G", Color.white);
    }

    public void setDrawBoxes(boolean drawBlackBox) {
        if (this.drawNumber) {
            return;
        }
        this.drawBlackBox = drawBlackBox;
    }

    public void setDrawColor(boolean drawColorBox) {
        if (this.drawNumber) {
            return;
        }
        this.drawColorBox = drawColorBox;
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        this.font = new Font("Monospaced", 0, this.fontSize);
        FontMetrics metrics = this.getFontMetrics(this.font);
        this.boundWidth = metrics.stringWidth("A");
        this.resWidth = metrics.stringWidth("A") + this.boundWidth / 2;
        this.seqHeight = metrics.stringWidth("A") + this.boundWidth;
        this.setPreferredSize(this.getPreferredSize());
        this.repaint();
    }

    public int getResidueWidth() {
        return this.resWidth;
    }

    public void setColorScheme(Hashtable colorHash) {
        this.colorTable = colorHash;
        this.setPrettyPlot(false);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSequenceWidth(), this.getSequenceHeight());
    }

    protected void viewPaneResize() {
        Dimension dpane = this.viewPane.getPreferredSize();
        GraphicSequenceCollection gsc = (GraphicSequenceCollection)this.viewPane;
        int xpane = (int)dpane.getWidth();
        int xsize = gsc.getPanelWidth();
        if (xsize > xpane) {
            this.viewPane.setPreferredSize(new Dimension(xsize, gsc.getPanelHeight()));
        }
        gsc.setJScrollPaneViewportView();
    }

    public int getSequenceHeight() {
        return this.seqHeight + this.ypad;
    }

    public int getSequenceWidth() {
        return this.resWidth * this.seqLength;
    }

    public int getSequenceResidueWidth() {
        return this.resWidth;
    }

    public void setSequenceLength(int s) {
        this.seqLength = s;
    }

    public String getName() {
        return this.seq.getName();
    }

    public void getNamePrintGraphic(Graphics g2d) {
        if (this.seq == null) {
            return;
        }
        String name = this.seq.getName();
        if (this.seq.getID() != null) {
            name = this.seq.getID();
        }
        g2d.setFont(this.font);
        g2d.setColor(Color.black);
        g2d.drawString(name, 0, this.seqHeight - this.boundWidth2);
    }

    public void getSequencePrintGraphic(Graphics g2d, int MAXSEQNAME, int istart, int istop) {
        String seqS = null;
        g2d.setFont(this.font);
        if (this.drawSequence) {
            seqS = this.seq.getSequence();
            int seqLength = this.seq.getLength();
            if (seqLength < istop) {
                istop = seqLength;
            }
        }
        int boundWidth4 = this.boundWidth2 / 2;
        boolean leftResidue = false;
        FontMetrics metrics = this.getFontMetrics(this.font);
        for (int i = istart; i < istop; ++i) {
            int ipos = (i - istart) * this.resWidth + MAXSEQNAME;
            if (this.drawColorBox) {
                g2d.setColor(this.getColor(seqS.substring(i, i + 1)));
                g2d.fillRect(ipos, 0, this.resWidth, this.seqHeight);
            }
            g2d.setColor(Color.black);
            if (this.drawBlackBox) {
                g2d.drawRect((i - istart) * this.resWidth + MAXSEQNAME, 0, this.resWidth, this.seqHeight);
            }
            if (this.drawSequence) {
                String res = seqS.substring(i, i + 1);
                if (this.prettyPlot) {
                    leftResidue = this.prettyDraw(i, ipos, istop, res, this.seqHeight, this.resWidth, leftResidue, g2d);
                }
                g2d.drawString(res, (i - istart) * this.resWidth + boundWidth4 + MAXSEQNAME, this.seqHeight - this.boundWidth2);
                continue;
            }
            if (!this.drawNumber || (i + 1 - istart) % this.interval != 0) continue;
            String snum = Integer.toString(i + 1);
            int numWidth = metrics.stringWidth(snum);
            g2d.drawString(snum, (int)(((double)(i - istart) + 0.5) * (double)this.resWidth) - numWidth / 2 + MAXSEQNAME, this.seqHeight - this.boundWidth2);
        }
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText().startsWith("Delete ")) {
            ((GraphicSequenceCollection)this.viewPane).deleteSequence(this.seq.getName());
        } else if (source.getText().startsWith("Reverse Complement")) {
            this.seq.reverseComplementSequence();
            this.paintComponent(this.getGraphics());
        } else if (source.getText().startsWith("Reverse ")) {
            this.seq.reverseSequence();
            this.paintComponent(this.getGraphics());
        } else if (source.getText().startsWith("Complement ")) {
            this.seq.complementSequence();
            this.paintComponent(this.getGraphics());
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SequenceJPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

