/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import jalview.AlignFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.emboss.jemboss.gui.SwingWorker;
import org.emboss.jemboss.gui.form.SectionPanel;
import org.emboss.jemboss.gui.form.TextFieldSink;

public class LaunchJalView
extends JFrame {
    public LaunchJalView() {
        super("Jalview ");
        final TextFieldSink tfs = new TextFieldSink();
        final Cursor cbusy = new Cursor(3);
        final Cursor cdone = new Cursor(0);
        Box bacross = Box.createHorizontalBox();
        Box bdown = Box.createVerticalBox();
        bdown.add(Box.createVerticalStrut(5));
        JLabel lname = new JLabel("Multiple Sequence Filename");
        lname.setFont(SectionPanel.labfont);
        lname.setForeground(Color.black);
        bdown.add(Box.createVerticalStrut(1));
        bacross.add(Box.createHorizontalStrut(1));
        bacross.add(lname);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(1));
        bacross = Box.createHorizontalBox();
        bacross.add(Box.createHorizontalStrut(1));
        bacross.add(tfs);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(5));
        lname = new JLabel("File Format");
        lname.setFont(SectionPanel.labfont);
        lname.setForeground(Color.black);
        bacross = Box.createHorizontalBox();
        bacross.add(Box.createHorizontalStrut(1));
        bacross.add(lname);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(1));
        String[] sformats = new String[]{"MSF", "FASTA", "CLUSTAL", "PIR"};
        final JComboBox<String> format = new JComboBox<String>(sformats);
        bdown.add(format);
        bdown.add(Box.createVerticalStrut(5));
        final JTextField mailServer = new JTextField();
        mailServer.setText("mercury.hgmp.mrc.ac.uk");
        bacross = Box.createHorizontalBox();
        bacross.add(Box.createHorizontalStrut(1));
        bacross.add(mailServer);
        JLabel lmail = new JLabel(" Mail Server ");
        lmail.setForeground(Color.black);
        bacross.add(lmail);
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(5));
        JButton launch = new JButton("LAUNCH");
        bacross = Box.createHorizontalBox();
        bacross.add(Box.createHorizontalStrut(1));
        bacross.add(launch);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        final LaunchJalView fr = this;
        launch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingWorker launchworker = new SwingWorker(){

                    public Object construct() {
                        LaunchJalView.this.setCursor(cbusy);
                        String name = tfs.getText();
                        File fn = new File(name);
                        if (!fn.exists()) {
                            JOptionPane.showMessageDialog(fr, name + " not found.\n" + "Note if this is a file on the server then\n" + "drag it to the local file manager first.", "File Not Found", 0);
                            LaunchJalView.this.setCursor(cdone);
                            LaunchJalView.this.setVisible(false);
                            return null;
                        }
                        String[] args = new String[]{name, "File", (String)format.getSelectedItem(), "-mail", mailServer.getText()};
                        try {
                            AlignFrame af = AlignFrame.parseArgs((String[])args);
                            af.setSize(700, 500);
                            LaunchJalView.this.setCursor(cdone);
                            LaunchJalView.this.setVisible(false);
                            af.setVisible(true);
                        }
                        catch (Exception npe) {
                            LaunchJalView.this.setCursor(cdone);
                            JOptionPane.showMessageDialog(fr, "Check the sequence entered \nand the format chosen.", "Error Message", 0);
                        }
                        return null;
                    }
                };
                launchworker.start();
            }
        });
        JPanel jp = (JPanel)this.getContentPane();
        jp.setLayout(new BorderLayout());
        jp.add((Component)bdown, "Center");
        this.pack();
        this.setLocation(this.getWidth() / 4, this.getHeight() / 4);
        this.setVisible(true);
    }
}

