/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.sequenceChooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.emboss.jemboss.gui.form.TextFieldInt;
import org.emboss.jemboss.gui.sequenceChooser.FileChooser;

public class InputSequenceAttributes {
    private TextFieldInt sbeg = new TextFieldInt();
    private TextFieldInt send = new TextFieldInt();
    private JTextField UFO = new JTextField();
    private JComboBox dbs;
    private JComboBox fileFormats;
    private JRadioButton rev;
    private JRadioButton nucleotide;
    private JRadioButton protein;
    private JRadioButton lower;
    private JRadioButton upper;
    private JScrollPane rscroll;
    private String[] ff = new String[]{"unspecified", "text", "fasta", "msf", "gcg", "gcg8", "embl", "swiss", "ncbi", "pearson", "genbank", "nbrf", "pir", "codata", "strider", "clustal", "aln", "phylip", "acedb", "dbid", "hennig86", "jackknifer", "jackknifernon", "nexus", "nexusnon", "paup", "paupnon", "treecon", "mega", "meganon", "ig", "experiment", "staden", "plain", "gff", "raw", "selex"};

    public InputSequenceAttributes(String[] db, final FileChooser fc) {
        JPanel pscroll = new JPanel(new BorderLayout());
        this.rscroll = new JScrollPane(pscroll);
        Box b = new Box(1);
        pscroll.add((Component)b, "Center");
        JLabel lab = new JLabel("Sequence Attributes");
        lab.setForeground(Color.red);
        lab.setFont(new Font("SansSerif", 1, 13));
        Box bx = new Box(0);
        b.add(bx);
        bx.add(lab);
        bx.add(Box.createHorizontalGlue());
        this.sbeg.setPreferredSize(new Dimension(50, 28));
        this.sbeg.setMaximumSize(new Dimension(50, 28));
        this.send.setPreferredSize(new Dimension(50, 28));
        this.send.setMaximumSize(new Dimension(50, 28));
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        b.add(bx);
        this.dbs = new JComboBox<String>(db);
        this.dbs.insertItemAt("unspecified", 0);
        this.dbs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String sel = (String)((JComboBox)e.getSource()).getSelectedItem();
                if (!sel.equalsIgnoreCase("unspecified")) {
                    fc.setText(sel + ":");
                }
            }
        });
        Dimension min = this.dbs.getMinimumSize();
        this.dbs.setPreferredSize(min);
        this.dbs.setMaximumSize(min);
        this.dbs.setSelectedIndex(0);
        bx.add(this.dbs);
        bx.add(Box.createRigidArea(new Dimension(2, 0)));
        lab = new JLabel("Databases available");
        lab.setForeground(Color.black);
        bx.add(lab);
        bx.add(Box.createHorizontalGlue());
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        b.add(bx);
        this.fileFormats = new JComboBox<String>(this.ff);
        this.fileFormats.setPreferredSize(min);
        this.fileFormats.setMaximumSize(min);
        this.fileFormats.setSelectedIndex(0);
        bx.add(this.fileFormats);
        bx.add(Box.createRigidArea(new Dimension(2, 0)));
        lab = new JLabel("Sequence format");
        lab.setForeground(Color.black);
        bx.add(lab);
        bx.add(Box.createHorizontalGlue());
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        b.add(bx);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.sbeg);
        bx.add(Box.createRigidArea(new Dimension(2, 0)));
        lab = new JLabel("begin");
        lab.setForeground(Color.black);
        bx.add(lab);
        bx.add(Box.createHorizontalGlue());
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        b.add(bx);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.send);
        bx.add(Box.createRigidArea(new Dimension(2, 0)));
        lab = new JLabel("end");
        lab.setForeground(Color.black);
        bx.add(lab);
        bx.add(Box.createHorizontalGlue());
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        this.rev = new JRadioButton("reverse complement");
        this.rev.setSelected(false);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.rev);
        bx.add(Box.createHorizontalGlue());
        b.add(bx);
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        this.nucleotide = new JRadioButton("nucleotide");
        this.nucleotide.setSelected(false);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.nucleotide);
        bx.add(Box.createHorizontalGlue());
        b.add(bx);
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        this.protein = new JRadioButton("protein");
        this.protein.setSelected(false);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.protein);
        bx.add(Box.createHorizontalGlue());
        b.add(bx);
        ButtonGroup group = new ButtonGroup();
        group.add(this.nucleotide);
        group.add(this.protein);
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        this.lower = new JRadioButton("Make lower case");
        this.lower.setSelected(false);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.lower);
        bx.add(Box.createHorizontalGlue());
        b.add(bx);
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        this.upper = new JRadioButton("Make upper case");
        this.lower.setSelected(false);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.upper);
        bx.add(Box.createHorizontalGlue());
        b.add(bx);
        group = new ButtonGroup();
        group.add(this.upper);
        group.add(this.lower);
        this.UFO = new JTextField();
        this.UFO.setPreferredSize(new Dimension(100, 30));
        this.UFO.setMaximumSize(new Dimension(100, 30));
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        b.add(bx);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.UFO);
        bx.add(Box.createRigidArea(new Dimension(2, 0)));
        lab = new JLabel("UFO features");
        lab.setForeground(Color.black);
        bx.add(lab);
        bx.add(Box.createHorizontalGlue());
    }

    public JScrollPane getJScrollPane() {
        return this.rscroll;
    }

    public void setBegSeq(int iseq) {
        this.sbeg.setValue(iseq);
    }

    public void setEndSeq(int iseq) {
        this.send.setValue(iseq);
    }

    public void setBegSeq(String s) {
        this.sbeg.setText(s);
    }

    public void setEndSeq(String s) {
        this.send.setText(s);
    }

    public String getBegSeq() {
        return this.sbeg.getText();
    }

    public String getEndSeq() {
        return this.send.getText();
    }

    public boolean isBeginSeqDefault() {
        return this.sbeg.getText() == null || this.sbeg.getText().equals("");
    }

    public boolean isEndSeqDefault() {
        return this.send.getText() == null || this.sbeg.getText().equals("");
    }

    public boolean isUFODefault() {
        return this.UFO.getText() == null || this.UFO.getText().equals("");
    }

    public String getFormatChoosen() {
        return (String)this.fileFormats.getSelectedItem();
    }

    public String getInputSeqAttr(int seq) {
        String options = " ";
        if (!this.isBeginSeqDefault()) {
            options = options.concat(" -sbegin" + seq + " " + this.sbeg.getValue());
        }
        if (!this.isEndSeqDefault()) {
            options = options.concat(" -send" + seq + " " + this.send.getValue());
        }
        if (!this.getFormatChoosen().equals("unspecified")) {
            options = options.concat(" -sformat" + seq + " " + this.getFormatChoosen());
        }
        if (this.rev.isSelected()) {
            options = options.concat(" -srev" + seq);
        }
        if (this.nucleotide.isSelected()) {
            options = options.concat(" -snucleotide" + seq);
        }
        if (this.protein.isSelected()) {
            options = options.concat(" -sprotein" + seq);
        }
        if (this.lower.isSelected()) {
            options = options.concat(" -slower" + seq);
        }
        if (this.upper.isSelected()) {
            options = options.concat(" -supper" + seq);
        }
        if (!this.isUFODefault()) {
            options = options.concat(" -sufo" + seq + " " + this.UFO.getText());
        }
        return options;
    }

    public List getInputSeqAttrA(int seq) {
        ArrayList<String> optionsA = new ArrayList<String>();
        if (!this.isBeginSeqDefault()) {
            optionsA.add("-sbegin" + seq);
            optionsA.add(String.valueOf(this.sbeg.getValue()));
        }
        if (!this.isEndSeqDefault()) {
            optionsA.add("-send" + seq);
            optionsA.add(String.valueOf(this.send.getValue()));
        }
        if (!this.getFormatChoosen().equals("unspecified")) {
            optionsA.add("-sformat" + seq);
            optionsA.add(this.getFormatChoosen());
        }
        if (this.rev.isSelected()) {
            optionsA.add("-srev" + seq);
        }
        if (this.nucleotide.isSelected()) {
            optionsA.add("-snucleotide" + seq);
        }
        if (this.protein.isSelected()) {
            optionsA.add("-sprotein" + seq);
        }
        if (this.lower.isSelected()) {
            optionsA.add("-slower" + seq);
        }
        if (this.upper.isSelected()) {
            optionsA.add("-supper" + seq);
        }
        if (!this.isUFODefault()) {
            optionsA.add("-sufo" + seq);
            optionsA.add(this.UFO.getText());
        }
        return optionsA;
    }
}

