/* $Id: e2_about_dialog.c 469 2007-07-06 22:58:30Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "emelfm2.h"
#include <string.h>
#include "e2_dialog.h"
#include "e2_about_dialog.h"

  /*****************/
 /*** callbacks ***/
/*****************/
/**
@brief about-dialog response-signal callback

@param dialog the about-dialog
@param response UNUSED the response code generated by the dialog
@param data pointer to data for the dialog
@return
*/
static void _e2_about_dialog_response_cb (GtkDialog *dialog, gint response,
	E2_Sextet *data)
{
	gchar *command;
	switch (response)
	{
		case E2_RESPONSE_USER1:	//read button click
			if (data->d == data->a)	//check whether a file-headiong is used
				command = g_strconcat(_A(5),".",_A(92), NULL);	//file.view
			else
				command = g_strconcat(_A(5),".",_A(94), NULL);	//file.view_at
			e2_action_run_simple (command, (gchar *)data->d);
			g_free (command);
			break;
		default:
		//cleanup the strings constructed when dialog set up
			F_FREE (data->a);
			g_free (data->b);
			g_free (data->c);
			e2_utils_sextet_destroy (data);
			gtk_widget_destroy (GTK_WIDGET (dialog));
			break;
	}
}
/**
@brief the notebook's "switch-page" signal callback
Visisbility of view-file buttons is changed as appropriate
@param notebook UNUSED the notebook widget
@param page UNUSED the notebook page which is now focused
@param page_num the index of the new page
@param dialog_data pointer to dialog data

@return
*/
static void _e2_about_dialog_tabchange_cb (GtkNotebook *notebook,
	GtkNotebookPage *page, guint page_num, E2_Sextet *dialog_data)
{
	switch (page_num)
	{
		case 1:	//contribs
			dialog_data->d = dialog_data->a;	//set the string to use for viewing
			gtk_widget_show (dialog_data->f);
			break;
		case 2:	//usage
			dialog_data->d = dialog_data->b;
			gtk_widget_show (dialog_data->f);
			break;
		case 3:	//commands
			dialog_data->d = dialog_data->c;
			gtk_widget_show (dialog_data->f);
			break;
		default:
//		case 0:	//main
			gtk_widget_hide (dialog_data->f);
			break;
	}
}
/**
@brief create and show tabbed about-dialog
@return the dialog widget, or NULL in case of a problem
*/
static GtkWidget *_e2_about_dialog_create (void)
{
	E2_Sextet *dialog_data = e2_utils_sextet_new ();
	if (dialog_data == NULL)
		return NULL;
	gchar *localiconsdir = e2_utils_get_icons_path (FALSE);
	gchar *localpath = g_build_filename (localiconsdir, BINNAME"_48.png", NULL);
	GtkWidget *dialog = e2_dialog_create (localpath,
		"<span size=\"x-large\" weight=\"bold\">" PROGNAME " " VERSION "</span>",
		_("help"), _e2_about_dialog_response_cb, dialog_data);
	e2_dialog_set_negative_response (dialog, GTK_RESPONSE_CLOSE);
	gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);	//looks better, with notebook
	g_free (localiconsdir);
	g_free (localpath);

	GtkWidget *notebook = e2_widget_add_notebook
		(GTK_DIALOG(dialog)->vbox, TRUE, 0, NULL, NULL);
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
	//info tab
	GtkWidget *vbox = e2_widget_add_notebook_page (dialog, notebook, _("about"));
	gchar *public = g_markup_escape_text (COPYRIGHT, -1);
	gchar *utf1 = e2_utf8_from_locale (BUILDSTAMP);
//	gchar *utf2 = e2_utf8_from_locale (BUILDINFO);
	gchar *message = g_strdup_printf
	(
//		_("<b>A GTK+2 file manager</b>\n\n"
//		"<b>implementing a two-pane design</b>\n\n"
		_("<b>An \"orthodox\" file manager for GTK+2</b>\n\n"
		"Copyright &#169; %s\n\n"   //&#169; = ©
		"This program is licensed under the terms of the General Public License "
		"and comes with ABSOLUTELY NO WARRANTY\n\n"
		"This binary was compiled on %s\n"
		"using %s and GTK+%d.%d.%d"),
		public, utf1, BUILDINFO, GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION
//		public, BUILDSTAMP, BUILDINFO, GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION
	);
	GtkWidget *label = e2_widget_add_mid_label (vbox, message, 0.5, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);
//	gtk_label_set_selectable (GTK_LABEL (label), TRUE);	//convenience only BAD, selects text when tab is changed
	g_free (public);
	g_free (utf1);
//	g_free (utf2);
	g_free (message);
	gchar *fmsg = _("The file\n<b>%s</b>\ngives details.");
	//contribs tab
	vbox = e2_widget_add_notebook_page (dialog, notebook, _("contributors"));
	//assume no escaping needed in DOC_DIR
	gchar *helpfile = F_FILENAME_FROM_LOCALE (DOC_DIR G_DIR_SEPARATOR_S "CREDITS");
	gchar *message2 = g_strdup_printf (fmsg, helpfile);
	message = g_strconcat (
	_("This program is based on emelFM, developed by Michael Clark.\n\n"
		"Contributions have been made by many friends."), " ",
		message2, NULL);
	label = e2_widget_add_mid_label (vbox, message, 0.0, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
//	gtk_label_set_selectable (GTK_LABEL (label), TRUE);
	g_free (message2);
	g_free (message);
	dialog_data->a = helpfile;	//F_FREE this later
	//usage tab
	gchar *title = _("usage");	//this is not yet? translated in the helpfile heading
	vbox = e2_widget_add_notebook_page (dialog, notebook, title);
	helpfile = e2_option_str_get ("usage-help-doc");
	message = g_strdup_printf (fmsg, helpfile);	//same filename for usage and commands tabs
	label = e2_widget_add_mid_label (vbox, message, 0.0, FALSE, 0); //assumes no escaping needed
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
//	gtk_label_set_selectable (GTK_LABEL (label), TRUE);
	dialog_data->b = g_strconcat (helpfile," [usage]",NULL);	//remember, for cleanup when finished
	//commands tab
	title = _("commands");
	vbox = e2_widget_add_notebook_page (dialog, notebook, title);
	label = e2_widget_add_mid_label (vbox, message, 0.0, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
//	gtk_label_set_selectable (GTK_LABEL (label), TRUE);
	g_free (message);
	dialog_data->c = g_strconcat (helpfile," [commands]",NULL); //remember, for cleanup when finished

	//data->f is read-button widget
	dialog_data->f = e2_dialog_add_undefined_button_custom (dialog, FALSE,
		E2_RESPONSE_USER1, _("_View"), "view_"E2IP".png", _("Read the file"),
		NULL, NULL);
	//now it's safe to hide view-button ...
	g_signal_connect (G_OBJECT (notebook), "switch-page",
		G_CALLBACK (_e2_about_dialog_tabchange_cb), dialog_data);

//	e2_dialog_resize (dialog, 1.8);	//guess what is big enough for usual fonts
	e2_dialog_show (dialog, app.main_window, 0, &E2_BUTTON_CLOSE, NULL);

	return dialog;
}
  /******************/
 /***** action *****/
/******************/
/**
@brief about-dialog action to create and show dialog
@param from the button, menu item etc which was activated
@param art action runtime data
@return TRUE always
*/
static gboolean _e2_about_dialog_open (gpointer from, E2_ActionRuntime *art)
{
	GtkWidget *dialog = _e2_about_dialog_create ();
	return (dialog != NULL);
}
  /******************/
 /***** public *****/
/******************/
/**
@brief register about-dialog action
@return
*/
void e2_about_dialog_actions_register (void)
{
	gchar *action_name = g_strconcat(_A(3),".",_A(25),NULL);
		e2_action_register_simple (action_name, E2_ACTION_TYPE_ITEM,
		_e2_about_dialog_open, NULL, FALSE);
}
