/* $Id: e2_config_dialog.h 469 2007-07-06 22:58:30Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef E2_CONFIG_DIALOG_H
#define E2_CONFIG_DIALOG_H

enum
{
	E2_CFGDLG_SINGLE=1,
	E2_CFGDLG_MAIN,
	E2_CFGDLG_BASIC,
	E2_CFGDLG_ADVANCED,
};

typedef struct _E2_ConfigDialogRuntime
{
	GtkTreeStore *store;	//page-names store
	GtkWidget *treeview;	//page-names treeview
	GtkTreePath *openpath;	//path of startup-name in page-names treeview
	gint openpage;	//index of startup notebook page
	GtkNotebook *notebook;
	GHashTable *opthash;	//sizegroups hash
} E2_ConfigDialogRuntime;

gboolean e2_confdlg_key_press_cb (GtkWidget *widget,
	GdkEventKey *event, gpointer data);
void e2_config_dialog_create (gchar *page);
void e2_config_dialog_setup_labels (void);
void e2_config_dialog_actions_register (void);

void e2_confdlg_choose_plugin_cb (GtkWidget *widget, E2_OptionSet *set);
#ifdef E2_RAINBOW
void e2_confdlg_extcolorpick_cb (GtkWidget *widget, E2_OptionSet *set);
#endif

// things for single-page config dialogs

typedef struct _E2_SpecificConfDialogRuntime
{
	GtkWidget *dialog;
	E2_OptionSet *set;
	void (*apply_function) ();
} E2_SpecificConfDialogRuntime;

E2_SpecificConfDialogRuntime *e2_config_dialog_single
	(gchar *set_name, void *response_cb, gboolean showit);

#endif //ndef E2_CONFIG_DIALOG_H
