/* $Id: e2_fileview.h 557 2007-07-24 11:59:11Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef E2_FILEVIEW_H
#define E2_FILEVIEW_H

#include "emelfm2.h"

//type of "dir" in a pane
typedef enum
{
	FS_LOCAL   = 0,		//default, mounted-local dir
	FS_FUSE    = 1,		//virtual local dir that needs special handling
	FS_REMOTE  = 1 << 1,//virtual non-mounted remote dir
	FS_ARCHIVE = 1 << 2,//archive (can be local or remote)
	FS_KERNEL  = 1 << 3,//a namespace in a multi-space local filesystem
	FS_SYNTH   = 1 << 4,//a synthesised virtual dir e.g. from a search process or metadata derived
} E2_FSType;
//types of virtual dir that are non-native, and warrant timeout if misbehaved
#define FS_SLOW (FS_FUSE | FS_REMOTE | FS_ARCHIVE)

#ifdef E2_VFS
//enumerator for type of backend to handle "dir" operations in a pane
typedef enum
{
	FS_NONE = -1,
	FS_SELF = 0,	//0 = default
	FS_FUSEAPI,	//only relevant for linux and freeBSD
	FS_GVFS,
	FS_MC,	//use lib from mc
	FS_XDG,	//use lib from freedesktop.org
	FS_GNOMEVFS,
	FS_MAX	//array-size counter (1 too big!)
} E2_FSHandler;
#endif

//these are in same order as ascii <, =, >
typedef enum { LT, EQ, GT } Operator;
typedef enum { E2_REFRESH, E2_RECREATE, E2_CHANGE } E2_RefreshType;
typedef enum { CD_NOTFINISHED, CD_TIMEOUT, CD_SUCCESS } E2_CDType;
//filelist treestore column-number enumerator
enum { FILENAME = 0, SIZE, PERM, OWNER, GROUP, MODIFIED, ACCESSED, CHANGED, MAX_COLUMNS };
//directory-read failure codes
enum
{
	E2DREAD_ENOENT,	//empty dir (not really an error)
	E2DREAD_NS,		//stat dir failed
	E2DREAD_DNR,	//dir not opened
	E2DREAD_DNCH,	//cannot cd into dir to poll its contents
	E2DREAD_DNF,	//read cancelled by user after timeout
	E2DREAD_ENOTH,	//failed to create thread when doing timed read
	E2DREAD_ENOMEM,	//not enough memory for storing data about read item
	E2DREAD_ELAST	//just an enumerator
};
#define E2DREAD_FAILED(ptr) (!(ptr == NULL || (gpointer)ptr > GUINT_TO_POINTER (E2DREAD_ENOMEM)))

typedef struct _E2_PlaceInfo
{
	gchar *spacename;
	gchar *priv_name;	/* for mounted dir NULL
	   for remote site excaped utf8, no trailer, login-ready URI before the filepath proper with p/w etc
	   for archive utf8, with trailer, path of temp dir used for unpacking whole or part
	   constructed from vtab data (not storeed there, it may have P/W text in URI)
	*/
	gchar *tip;	/* for mounted dir NULL
	   for remote site "tip", utf8, no trailer, public components of 1st part of URI, before the filepath proper
	   for archive "tip", utf8, no trailer, pseudo-path of archive, with all ancestor(s) including remote URI and other archive
	*/
	gchar *workplace;	//path of local fs dir, absolute localised no trailer
	gchar *plain_pw;	//password, utf8-, or NULL
	GList *pane1_entered; //pane 1 dirline history, specific to current namespace
	GList *pane2_entered; //pane 2 dirline history, specific to current namespace
	GList *pane1_history; //pane1 dir_history, but specific to this namespace
	GList *pane2_history; //pane2 dir_history, but specific to this namespace
	GList *pane1_visited; //pane1 visited, opendirs, but specific to this namespace
	GList *pane2_visited; //pane2 visited, opendirs, but specific to this namespace
	E2_FSType dirtype;	//flags for type of namespace this is
//	E2_VFSOpFlags cando;	//flags for available operations
	gboolean monitored;	//alteration monitoring in effect for this place
	struct _E2_PlaceInfo* parentplace;	//for cd .. past root
	//etc
} PlaceInfo;

typedef struct _E2_ViewInfo
{
	GtkListStore *store;
	GtkTreeModel *model;	//may be a filter model or standard
	GtkWidget *treeview;
	GtkTreeSelection *selection;	//pointer to selection for this view's treeview
	GHashTable *selected_names;  //names of selected items (for reselection), or NULL
	gint sort_column;  //copy of current sort column, can be <0
	gboolean extsort;	//TRUE when name-sorting is by extension
	GtkSortType sort_order; //copy of current sort order
	GtkWidget *sort_arrows[MAX_COLUMNS];
	GtkLabel *name_label;	//for showing active pane by changing label content
	E2_FSType dirtype;	//flags for type of namespace this view belongs to
#ifdef E2_VFS
	PlaceInfo *spacedata;	//pointer to extra data for virual namespace, NULL for mounted dir
#endif
	gchar dir[PATH_MAX];	//path shown in this view (utf-8) with vpreface if approprate
	GList *dir_history;  //list of structs with focused line etc for each opened dir in the current namespace
						//FIXME clean list data at end-session
#ifdef E2_VFSTMP
	//FIXME preserve local dir_history when swapping to a v-dir
#endif
//#ifndef E2_FAM
	time_t dir_mtime;
	time_t dir_ctime;
//#endif
	GtkWidget *check_dirs; //filter sub-menu toggle-widget
	GtkWidget *check_name; //filter sub-menu toggle-widget
	struct
	{
		gchar *patternptr;
		GSList *compiled_patterns;	//list of _E2_SelectPattern's
		gboolean invert_mask;
		gboolean case_sensitive;
		gboolean active;
	} name_filter;
	GtkWidget *check_size;
	struct
	{
		size_t size;
		Operator op;
		gboolean active;
	} size_filter;
	GtkWidget *check_date;
	struct
	{
		time_t time;	//time_t may be int or long int
		Operator op;
		enum {MTIME, ATIME, CTIME} time_type;
		gboolean active;
	} date_filter;

	gboolean filtered_before;	//state of prior call to filter function
	gboolean filter_directories;
	gboolean show_hidden;  //whether to display hidden items in this view
	guint total_items;	//total displayed and undisplayed items in the dir - 2 (to ignore . and ..)
	gint row;	//index of most-recently clicked row in the treeview
	gint drop_row;	//index of most-recently moused row during a drag operation
	gboolean lit;	//TRUE if drop-row is highlighted
	E2_RefreshType refreshtype; //whether a view update is a refresh, recreate or cd
	gboolean refresh_requested;	//TRUE when something has proposed that the view be refreshed
	gboolean blocked;	//flag to block view updates when refresh is disabled
	gboolean completed; //flag to block recursive view updates
	gchar last_find[NAME_MAX]; //buffer for storing names used in find task
//	GHookList hook_refresh;	//data for functions to run during post-refresh idle-time function
} ViewInfo;

typedef struct _E2_FileInfo
{
	gchar filename[NAME_MAX+1];  //localised string
	struct stat statbuf;
} FileInfo;

typedef struct _E2_SelectedItemInfo
{
	gchar filename[NAME_MAX+1];  //localised string no trailing /
/*	FileInfo info;
	gchar *filename;  //selected item name (except no trailing /), utf-8 string
#ifdef E2_INCLIST
	//use this if the store data is changed on the fly
	GtkTreeRowReference *ref;
#else
	//this is used for un-selecting liststore items on the fly
	GtkTreePath *path;
#endif
*/
} E2_SelectedItemInfo;

typedef struct _E2_CDdata
{
	ViewInfo *view;	//use this when re-starting a cd after timeout
	gchar *newpath;	//stored copy of place to open
	gboolean history;
	gboolean hook;
	gboolean cd_blocked;	//TRUE to prevent re-entrant cd of the same filelist
	gboolean busy;	//TRUE when we are trying to cd using this data
	guint timer;	//id of timer running a cd process
} E2_CDdata;

typedef struct _E2_CDwatch
{
	ViewInfo *view;	//data for view being changed (can't use E2_PaneRuntime due to circular includes)
	gchar *newpath;	//place to be opened, utf8 with trailing separator
	gint repeats;	//current retry counter
//	guint watchtimer_id; //id of timer that is watching for completion
	E2_CDType *completed_flag;	//store for flag to set when completion detected
} E2_CDwatch;

typedef struct _E2_DRead
{
	pthread_t aid;	//read thread ID, 0 when stopped
	pthread_t mid;	//monitor thread ID, 0 when stopped
	GtkWidget *dialog;	//too-slow dialog widget, or NULL
} E2_DRead;

typedef struct _E2_SelectPattern
{
	GPatternSpec *pspec;
	gboolean negated;
} E2_SelectPattern;

#ifdef E2_VFS
//macro for getting the current path "string" for a dir
# define VIEWDIR(view) view->dir
//e2_utils_dircat (view,s) is a real function
//length of not-yet-constructed path with prepended place-data pointer
# define VDIRLEN(view) strlen(view->dir)+sizeof(PlaceInfo *)
//length of a constructed path string with prepended place-data pointer
# define VPATHLEN(s) sizeof(PlaceInfo *)+strlen(s+sizeof(PlaceInfo *))
# define VSUFFIX(s,n) g_str_has_suffix(s+sizeof(PlaceInfo *),n)
#else
# define VIEWDIR(view) e2_utils_get_vdir(view)
//appending a string to view->dir
# define e2_utils_dircat(view,s) e2_utils_strcat(view->dir,s)
# define VDIRLEN(view) strlen(view->dir)
//length of a path string without prepended pointer
# define VPATHLEN(s) strlen(s)
# define VSUFFIX(s,n) g_str_has_suffix(s,n)
#endif

gint e2_fileview_ext_sort (GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b,
	GtkSortType *direction);
void e2_fileview_refilter_list (ViewInfo *view);
void e2_fileview_filter_dirs_cb (GtkWidget *widget, ViewInfo *view);
void e2_fileview_remove_filters_cb (GtkWidget *widget, ViewInfo *view);
void e2_fileview_initialize_filters (ViewInfo *view);

void e2_fileview_set_menu_position (GtkMenu *menu,
	gint *x, gint *y, gboolean *push_in, GtkWidget *treeview);
void e2_fileview_focus_row (ViewInfo *view, gint row,
	gboolean select_row, gboolean clear_selection,
	gboolean center, gboolean grab_focus);
//void e2_fileview_select_row_by_filename (ViewInfo *view, gchar *filename); unused
GHashTable *e2_fileview_log_selected_names (ViewInfo *view);
void e2_fileview_reselect_names (ViewInfo *view);
void e2_fileview_translate_cols_array (gint *src_array,
	gint *dest_array, gint size);
void e2_fileview_switch_views (void);
//void e2_fileview_switch_views_simple (void);
void e2_fileview_set_font (void);
void e2_fileview_set_row_background (ViewInfo *view,
	GtkTreeIter *iter, GdkColor *color);
void e2_fileview_clear_row_background (ViewInfo *view,
	GtkTreeIter *iter);
void e2_fileview_update_col_cachedata (void);
void e2_fileview_get_scroll_data (ViewInfo *view, gint *leftcol, gint *toprow);
void e2_fileview_scroll_to_position (ViewInfo *view, gint leftcol, gint toprow);
//gint e2_fileview_find_name_col (ViewInfo *view); unused
gboolean e2_fileview_prepare_list (ViewInfo *view);
void e2_fileview_scroll_list (GThread *viewthread);
void e2_fileview_refresh_list (ViewInfo *view);
gboolean e2_fileview_treehash_free (GHashTable *data);
gboolean e2_fileview_cd_watch (E2_CDwatch *data);
gboolean e2_fileview_cd_manage (E2_CDdata *data);
//#ifdef E2_VFSTMPOK
//	E2_FSNewType fsclass, gchar *prefix,
//#endif
//	gchar *newpath, gboolean history, gboolean hook);
GtkWidget *e2_fileview_create_list (ViewInfo *view);
void e2_fileview_select_all (GtkWidget *widget, ViewInfo *view);
void e2_fileview_clean_selected (GPtrArray *selected);
GPtrArray *e2_fileview_get_selected (ViewInfo *view);
GList *e2_fileview_get_selected_local (ViewInfo *view);
FileInfo *e2_fileview_get_selected_first_local (ViewInfo *view, gboolean updir);
gchar *e2_fileview_get_row_name (ViewInfo *view, gint row);

#endif //ndef E2_FILEVIEW_H
