/* $Id: e2_keybinding.h 469 2007-07-06 22:58:30Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelfm2.
emelfm2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelfm2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef E2_KEYBINDING_H
#define E2_KEYBINDING_H

#include "emelfm2.h"

typedef struct _E2_KeyRuntime
{
	GdkModifierType mask;
	guint keyval;	//gdk key code
	gchar *action;	//name of action or command, maybe ""
	gchar *action_data;	//action data, maybe ""
	gboolean cont;	//TRUE to keep looking for other actions to activate
	GList *chained;	//list of E2_KeyRuntime's for immediate-child key(s)
					//i.e. chained directly to this one
} E2_KeyRuntime;

typedef struct _E2_KeybindingRuntime
{
	gchar *name;		//binding (category) name
//	GtkTreeModel *model;//always opt_keys->ex.tree.model so that all known keys appear in config dialog
	GtkTreeRowReference *ref;	//reference to model iter that's the root for the category
//#ifdef E2_IDLE_KEYSYNC
//	gboolean synced;	//TRUE when treestore data have been converted to runtime list
//#endif
	GList *keys;		//E2_KeyRuntime's for each key in the category
	GList *curr_chain;	//this is set to the chained list of the most-recent activated key
	guint timeout_id;	//id for chained keys timer
//	guint count;		//no. of widgets bound to this binding group
	GSList *instances;	//list of widgets bound to this binding group
} E2_KeybindingRuntime;

void e2_keybinding_register_all (void);
void e2_keybinding_register (gchar *category, GtkWidget *widget);
#ifdef E2_TRANSIENTKEYS
void e2_keybinding_register_transient (gchar *category, GtkWidget *widget,
	gpointer install_func);
void e2_keybinding_unregister (gchar *category, GtkWidget *widget);
#endif
void e2_keybinding_output_help (gchar *section);
void e2_keybinding_clean (void);
#ifdef E2_KEYALIAS
void e2_keybinding_actions_register (void);
#endif
void e2_keybinding_options_register (void);

#endif //ndef E2_KEYBINDING_H
