/* $Id: e2_fs_FAM_inotify.h 469 2007-07-06 22:58:30Z tpgww $

Copyright (C) 2005-2007 tooar <tooar@gmx.net>
Portions copyright (C) 2005 John McCutchan

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef _E2_FS_FAMINOTIFY_H
#define _E2_FS_FAMINOTIFY_H

#include <linux/inotify.h>

#ifdef IN_DELETE_SUBDIR
//we have a superseded inotify header, corrections needed
#define IN_CREATE 0x00000100
#define IN_DELETE 	0x00000200
#undef IN_DELETE_SELF
#define IN_DELETE_SELF 0x00000400
#define IN_MOVE_SELF 0x00000800
#define IN_ISDIR 0x40000000
#endif //def IN_DELETE_SUBDIR
//this is a workaround for a buggy linux/inotify.h
#ifndef IN_MOVE_SELF
#define IN_MOVE_SELF 0x00000800
#endif

/* when monitoring a dir we ignore these inotify events:
IN_CLOSE_WRITE this should be covered by IN_MODIFY
IN_CLOSE_NOWRITE
IN_OPEN we're monitoring dirs and config file and don't care about opening
and we always get these, so don't need to ask
IN_UNMOUNT
IN_Q_OVERFLOW
IN_IGNORED (item no longer watched, likely due to its deletion (or replacement))
*/
#define INDIR_FLAGS \
IN_ACCESS | IN_MODIFY | IN_ATTRIB | IN_MOVED_FROM | IN_MOVED_TO | \
IN_CREATE | IN_DELETE | IN_DELETE_SELF | IN_MOVE_SELF

/*for the config file we're interested only in events that would trigger a
reload of that file, ie modification or creation. Not deletion, as a replacement
may not yet be available.
However, in normal course of events, the file is deleted and then replaced, and
deletion causes a IN_IGNORED report to be generated, and monitoring ceases to be
effective - so no IN_CREATE report is generated, normally.
*/
#define INCFG_FLAGS \
IN_MODIFY | IN_CREATE

//the following are derived from local_inotify_syscalls.h used by gamin 0.1.5
#undef __NR_inotify_init
#if defined(__i386__)
# define __NR_inotify_init	291
# define __NR_inotify_add_watch	292
# define __NR_inotify_rm_watch	293
#elif defined(__x86_64__)
# define __NR_inotify_init	253
# define __NR_inotify_add_watch	254
# define __NR_inotify_rm_watch	255
#elif defined(__alpha__)
# define __NR_inotify_init      444
# define __NR_inotify_add_watch 445
# define __NR_inotify_rm_watch  446
#elif defined(__ppc__) || defined(__powerpc__) || defined(__powerpc64__)
# define __NR_inotify_init      275
# define __NR_inotify_add_watch 276
# define __NR_inotify_rm_watch  277
#elif defined(__sparc__) || defined (__sparc64__)
# define __NR_inotify_init      151
# define __NR_inotify_add_watch 152
# define __NR_inotify_rm_watch  156
#elif defined (__ia64__)
# define __NR_inotify_init  1277
# define __NR_inotify_add_watch 1278
# define __NR_inotify_rm_watch  1279
#elif defined (__s390__) || defined (__s390x__)
# define __NR_inotify_init  284
# define __NR_inotify_add_watch 285
# define __NR_inotify_rm_watch  286
#elif defined (__arm__)
# define __NR_inotify_init  316
# define __NR_inotify_add_watch 317
# define __NR_inotify_rm_watch  318
#elif defined (__SH4__)
# define __NR_inotify_init  290
# define __NR_inotify_add_watch 291
# define __NR_inotify_rm_watch  292
#elif defined (__SH5__)
# define __NR_inotify_init  318
# define __NR_inotify_add_watch 319
# define __NR_inotify_rm_watch  320
#endif

#ifdef __NR_inotify_init
#include <sys/syscall.h>
#define inotify_init(a)  syscall (__NR_inotify_init)
#define inotify_add_watch(a,b,c)  syscall (__NR_inotify_add_watch,a,b,c)
#define inotify_rm_watch(a,b)  syscall (__NR_inotify_rm_watch,a,b)
#else
#warning "Unsupported architecture"
#define inotify_init(a) -1
#define inotify_add_watch(a,b,c) -1
#define inotify_rm_watch(a,b) -1
#endif  //supported arch
//end of gamin-derived stuff

#endif //def _E2_FS_FAMINOTIFY_H
