# -*- coding: utf-8 -*-
# 
# Copyright (C) 2008 Alen Bou-Haidar <alencool@gmail.com>
#
# Elloquence Messenger is free software: you can redistribute it and/or modify 
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or 
# (at your option) any later version.
# 
# Elloquence Messenger is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>

from __future__ import division

import time
import gobject

class DelayedEvent(object):
    def __init__(self, call_back, delay=200):
        self._event_id = None
        self._milliseconds = float(delay)
        self._call_back = call_back
        self._call_time = time.time()
        self._params = ()
        
    def _time_out(self):
        call_time = self._call_time
        now_time = time.time()
        if (now_time - call_time) >= (self._milliseconds/1000):
            self._call_back(*self._params)
            self._event_id = None
            return False
        else:
            return True
          
    def call_event(self, *params):
        self._params = params
        self._call_time = time.time()
        if not self._event_id:
            interval = int(self._milliseconds/2)
            self._event_id = gobject.timeout_add(interval, self._time_out)
