/*
** 
** Copyright (C) 1993 Swedish University Network (SUNET)
** 
** 
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** 
**                                           Martin.Wendel@its.uu.se
** 				             Torbjorn.Wictorin@its.uu.se
** 
**                                           ITS	
**                                           P.O. Box 887
**                                           S-751 08 Uppsala
**                                           Sweden
** 
*/
/*
 * Message Structure 
 */

struct message {
  struct header *h;
  struct data *sd;
  struct data *sdl;
  struct data *td;
  struct data *tdl;
  struct data *rd;
  struct data *rdl;
  int level;
  int children;
  int headerdone;
  struct message *sibling;
  struct message *child;
  struct message *bigsib;
  struct message *parent;
  struct config_struct * c;
};

struct info {
  int a;
};
/*
 * Header structure
 */


#define UNIXFROM 1 /* Unix from line flag */
#define EMHEADER   2 /* Regular header line flag */

struct header {
  int type;        /* Unix from line or regular header */
  int format;      /* RFC822, MIME or MAILTOOL */
  struct data *field;     /* Field  */
  struct data *value;     /* Value */
  struct hprs *hvalue;
  struct header *next;
};

struct hprs {
  int encoding;
  int type;
  int types;
  int pstart;
  int pend;
  char *charset;
  struct data *sd;
  struct data *td;
  struct hprs *sibling;
  struct hprs *child;
};

/*
 * Data structure
 */

struct data {
  char *type;
  unsigned char *name;
  unsigned char *appletype;
  unsigned char *nameext;
  unsigned char *description;
  unsigned char *charset;   /* Charset */
  unsigned char *startbound;/* Start boundary */
  unsigned char *endbound;  /* End boundary */
  unsigned long length;      /* Predefined bodypart length */
  unsigned long bodylines;   /* Some predefined number of bodylines in the part */
  unsigned int format;      /* Main format of the message */
  unsigned int encoding;    /* E7BIT, EBINHEX, EUUENCODE, EBASE64, EQP or EMULTIPART */
  unsigned int check;       /* Check for these encodings */
  unsigned int applefile;
  unsigned long end;        /* End of defined data */
  unsigned long size;       /* Size of data area */
  unsigned long bodystart;  /* Start of bodypart data */
  unsigned long bodyend;    /* End of bodypart data */
  unsigned long offset;     /* Current position in data area */
  unsigned long linestart;  /* Linecount at start of body part */
  unsigned long lineend;    /* Linecount at end of bodypart */
  unsigned long loffset;    /* Current linecount */
  unsigned long lend;       /* Linecount of end of defined data */
  int count;
  unsigned char *contents;  /* Pointer to data area */
  struct data *next; /* Next data struct */
};
