C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE GGVALUE(NEWFLD, NEXT, INROW, RLAT, RLON,
     X                   POLELAT, POLELON, NGAUSS, TYPE, FIELD)
C
C---->
C**** GGVALUE
C
C     PURPOSE
C     _______
C
C     Rotates one line of latitude in a gaussian grid.
C
C     INTERFACE
C     _________
C
C     CALL GGVALUE(NEWFLD, NEXT, INROW, RLAT, RLON,
C    X             POLELAT, POLELON, NGAUSS, TYPE, FIELD)
C
C
C     Input parameters
C     ________________
C
C     NEWFLD  - The field of values being created
C     NEXT    - Start offset of the latitude row being created
C     INROW   - The number of points in the latitude row
C     RLAT    - Target point latitude in the rotated grid
C     RLON    - Target point longitude in the rotated grid
C     POLELAT - Latitude of the rotated South Pole
C     POLELON - Longitude of the rotated South Pole
C     FIELD   - Original unrotated gaussian field values
C     NGAUSS  - Original unrotated gaussian field number
C     TYPE    - Original unrotated gaussian field type
C               = 'F' for full (regular) gaussian field
C               = 'R' for reduced (quasi) gaussian field
C
C     Output parameters
C     ________________
C
C     NEWFLD(NEXT) to NEWFLD(NEXT+INROW-1) contains the latitude row
C     values.
C
C
C     METHOD
C     ______
C
C     Rotates the lat/long positions of points along a latitude row in
C     a rotated gaussian grid back to positions in the unrotated grid
C     and then interpolates values from the original grid.
C
C
C     EXTERNALS
C     _________
C
C     LL2XYZ  - Converts a latitude/longitude position to (x,y,z)
C               wrt axes through the centre of the globe. The z-axis
C               runs from the south to north pole. The x- and y-axes
C               are in the plane of the equator with the x-axis
C               pointing out through lat/long (0,0).
C     YROTATE - Rotates the globe about the new y-axis.
C     XYZ2LL  - Converts an (x,y,z) position to a latitude/longitude.
C     GGINTRP - Interpolates a value from an existing grid.
C
C
C     REFERENCE
C     _________
C
C     None
C
C
C     COMMENTS
C     ________
C
C     The input field is assumed to be global in extent, and a known
C     definition, either N160 or N80 (reduced or regular).
C
C
C     AUTHOR
C     ______
C
C     J.D.Chambers      ECMWF       April 1996
C
C
C     MODIFICATIONS
C     _____________
C
C     None.
C
C----<
C     _______________________________________________________
C
C*    Section 0. Definition of variables.
C     _______________________________________________________
C
      IMPLICIT NONE
C
C     Parameters
C
      INTEGER JPMAXGG
      PARAMETER( JPMAXGG = 1280 )
C
C     Function arguments
C
      REAL NEWFLD, RLAT, RLON, POLELAT, POLELON, FIELD
      DIMENSION NEWFLD(*), RLON(*), FIELD(*)
      INTEGER NEXT, INROW, NGAUSS
      CHARACTER*1 TYPE
C
C     Local variables
C
      REAL X(JPMAXGG), Y(JPMAXGG), Z(JPMAXGG)
      REAL RX(JPMAXGG),RY(JPMAXGG),RZ(JPMAXGG)
      REAL OLAT(JPMAXGG),OLON(JPMAXGG)
      INTEGER LOOP
C
C     Convert the rotated row points lat/longs to (x,y,z) coordinates
C
      CALL LL2XYZ(RLAT,RLON,X,Y,Z,INROW)
C
C     Rotate the rotated row points back through the original latitude
C     rotation
C
      CALL YROTATE(-(90.0+POLELAT),X,Y,Z,RX,RY,RZ,INROW)
C
C     Convert the rotated row points adjusted (x,y,z) coordinates to
C     lat/long in the original grid (after longitude rotation)
C
      CALL XYZ2LL(RX,RY,RZ,OLAT,OLON,INROW)
C
C     Adjust the rotated line longitudes to remove the longitude
C     rotation
C
      DO LOOP = 1, INROW
        OLON(LOOP) = OLON(LOOP) + POLELON
        IF( OLON(LOOP).LT.0.0 )   OLON(LOOP) = OLON(LOOP) + 360.0
        IF( OLON(LOOP).GE.360.0 ) OLON(LOOP) = OLON(LOOP) - 360.0
      ENDDO
C
C     Interpolate the original unrotated grid to the points in the
C     rotated line
C
      CALL GGINTRP(NEWFLD,NEXT,INROW,OLAT,OLON,NGAUSS,TYPE,FIELD)
C
      RETURN
      END
