C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE INTLOGD(KONOFF)
C
C---->
C**** INTLOGD
C
C     PURPOSE
C     _______
C
C     This routine toggles the debug flag LDEBUG.
C
C
C     INTERFACE
C     _________
C
C     CALL INTLOG(KONOFF)
C
C
C     Input parameters
C     ________________
C
C     KONOFF   - value to set in the debug flag LDEBUG.
C                = 0 for 'off'.
C                = 1 for 'on'.
C
C
C     Output parameters
C     ________________
C
C     None.
C
C
C     Common block usage
C     __________________
C
C     LDEBUG in /INTLOGC/ controls display of message
C                 = 0 for no display
C                 = 1 to display
C
C
C     Method
C     ______
C
C     Toggle flag.
C
C
C     Externals
C     _________
C
C     None.
C
C
C     Comments
C     ________
C
C     LDEBUG is toggled by a call to INTLOGD.
C
C
C     AUTHOR
C     ______
C
C     J.D.Chambers      *ECMWF*      Jul 1995
C
C
C     MODIFICATIONS
C     _____________
C
C     None.
C
C
C----<
C     _______________________________________________________
C
C     Subroutine arguments.
      INTEGER KONOFF
#include "intlog.h"
C
      LDEBUG =  (KONOFF.EQ.1)
C
      RETURN
      END
